/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.entity.semiblock;

import java.util.Collection;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import me.desht.pneumaticcraft.api.PNCCapabilities;
import me.desht.pneumaticcraft.api.semiblock.IDirectionalSemiblock;
import me.desht.pneumaticcraft.api.semiblock.ISemiBlock;
import me.desht.pneumaticcraft.api.semiblock.SemiblockEvent;
import me.desht.pneumaticcraft.common.block.entity.IGUIButtonSensitive;
import me.desht.pneumaticcraft.common.registry.ModDataComponents;
import me.desht.pneumaticcraft.common.registry.ModItems;
import me.desht.pneumaticcraft.common.semiblock.SemiblockTracker;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.capabilities.EntityCapability;
import net.neoforged.neoforge.common.NeoForge;

public abstract class AbstractSemiblockEntity
extends Entity
implements ISemiBlock,
IGUIButtonSensitive {
    private static final EntityDataAccessor<Integer> TIME_SINCE_HIT = SynchedEntityData.defineId(AbstractSemiblockEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Float> DAMAGE_TAKEN = SynchedEntityData.defineId(AbstractSemiblockEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final Set<LogKey> LOGGED_ERROR = new HashSet<LogKey>();
    private static final float MAX_HEALTH = 40.0f;
    private BlockEntity cachedTE;
    protected boolean beingRemoved = false;
    private AABB blockBounds;
    private BlockPos blockPos;
    private Vec3 dropOffset = Vec3.ZERO;
    private Block lastBlock;

    AbstractSemiblockEntity(EntityType<?> entityTypeIn, Level worldIn) {
        super(entityTypeIn, worldIn);
    }

    private void dropItem(ItemStack stack) {
        if (!stack.isEmpty()) {
            ItemEntity itemEntity = new ItemEntity(this.level(), this.getX() + this.dropOffset.x(), this.getY() + this.dropOffset.y(), this.getZ() + this.dropOffset.z(), stack);
            itemEntity.setDefaultPickUpDelay();
            Collection capture = this.captureDrops();
            if (capture != null) {
                capture.add(itemEntity);
            } else {
                this.level().addFreshEntity((Entity)itemEntity);
            }
        }
    }

    @Override
    public Component getSemiblockDisplayName() {
        return new ItemStack((ItemLike)this.getDroppedItem()).getDisplayName();
    }

    @Override
    public void tick() {
        Block curBlock;
        super.tick();
        if (this.tickCount == 1) {
            this.setBoundingBox(this.getBlockBounds().move(this.blockPos));
            this.lastBlock = this.getBlockState().getBlock();
        }
        if (this.getTimeSinceHit() > 0) {
            this.setTimeSinceHit(this.getTimeSinceHit() - 1);
        }
        if (this.getDamageTaken() > 0.0f) {
            this.setDamageTaken(this.getDamageTaken() - 1.0f);
        }
        if (!this.level().isClientSide && this.isAlive() && !this.canStay()) {
            this.beingRemoved = true;
            this.kill();
        }
        if ((curBlock = this.getBlockState().getBlock()) != this.lastBlock) {
            this.cachedTE = null;
            this.blockBounds = null;
            this.lastBlock = curBlock;
        }
    }

    public InteractionResult interactAt(Player player, Vec3 hitVec, InteractionHand hand) {
        InteractionResult res;
        Vec3 eye = player.getEyePosition(0.0f);
        Vec3 end = eye.add(player.getLookAngle().normalize().scale(5.0));
        ClipContext ctx = new ClipContext(eye, end, ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)player);
        BlockHitResult brtr = player.level().clip(ctx);
        if (brtr.getType() != HitResult.Type.BLOCK) {
            return InteractionResult.PASS;
        }
        if (player.getItemInHand(hand).getItem() == ModItems.LOGISTICS_CONFIGURATOR.get() && !player.level().isClientSide) {
            if (player.isShiftKeyDown()) {
                this.killedByEntity((Entity)player);
                return InteractionResult.SUCCESS;
            }
            if (this.onRightClickWithConfigurator(player, brtr.getDirection())) {
                PNCCapabilities.getAirHandler(player.getItemInHand(hand)).ifPresent(h -> h.addAir(-50));
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.PASS;
        }
        InteractionResult interactionResult = res = player.isShiftKeyDown() ? InteractionResult.PASS : this.getBlockState().useWithoutItem(this.level(), player, brtr);
        if (res.consumesAction() || res == InteractionResult.FAIL) {
            return res;
        }
        UseOnContext itemCtx = new UseOnContext(player, hand, brtr);
        res = player.getItemInHand(hand).onItemUseFirst(itemCtx);
        return res == InteractionResult.PASS ? player.getItemInHand(hand).useOn(itemCtx) : res;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(TIME_SINCE_HIT, (Object)0);
        builder.define(DAMAGE_TAKEN, (Object)Float.valueOf(0.0f));
    }

    @Override
    public Level getWorld() {
        return this.level();
    }

    @Override
    public BlockPos getBlockPos() {
        return this.blockPos;
    }

    public void setPos(double x, double y, double z) {
        if (!this.isAddedToLevel()) {
            super.setPos(x, y, z);
            this.blockPos = BlockPos.containing((double)x, (double)y, (double)z);
        }
    }

    public BlockState getBlockState() {
        return this.level().getBlockState(this.blockPos);
    }

    @Override
    public BlockEntity getCachedTileEntity() {
        if (!this.level().isLoaded(this.blockPos)) {
            return null;
        }
        if (this.cachedTE == null || this.cachedTE.isRemoved()) {
            this.cachedTE = this.level().getBlockEntity(this.blockPos);
        }
        return this.cachedTE;
    }

    protected Item getDroppedItem() {
        return (Item)BuiltInRegistries.ITEM.get(this.getSemiblockId());
    }

    @Override
    public NonNullList<ItemStack> getDrops() {
        NonNullList drops = NonNullList.create();
        Item item = this.getDroppedItem();
        if (item != null) {
            ItemStack stack = new ItemStack((ItemLike)this.getDroppedItem());
            CompoundTag tag = new CompoundTag();
            this.serializeNBT(tag, (HolderLookup.Provider)this.registryAccess());
            if (!tag.isEmpty()) {
                stack.set(ModDataComponents.SEMIBLOCK_DATA, (Object)CustomData.of((CompoundTag)tag));
            }
            drops.add((Object)stack);
        }
        return drops;
    }

    public final AABB getBlockBounds() {
        if (this.blockBounds == null) {
            this.blockBounds = this.calculateBlockBounds();
        }
        return this.blockBounds;
    }

    protected AABB calculateBlockBounds() {
        VoxelShape shape;
        AABB aabb = this.level() != null ? ((shape = this.level().getBlockState(this.blockPos).getShape((BlockGetter)this.level(), this.blockPos)).isEmpty() ? Shapes.block().bounds() : shape.bounds()) : Shapes.block().bounds();
        return aabb;
    }

    public boolean canStay() {
        return this.canPlace(null);
    }

    @Override
    public ResourceLocation getSemiblockId() {
        return PneumaticCraftUtils.getRegistryName(BuiltInRegistries.ENTITY_TYPE, this.getType()).orElseThrow();
    }

    @Override
    public CompoundTag serializeNBT(CompoundTag tag, HolderLookup.Provider provider) {
        return tag;
    }

    protected void readAdditionalSaveData(CompoundTag compound) {
    }

    protected void addAdditionalSaveData(CompoundTag compound) {
        this.serializeNBT(compound, (HolderLookup.Provider)this.registryAccess());
    }

    @Override
    public boolean isValid() {
        return this.isAlive();
    }

    public void onAddedToLevel() {
        super.onAddedToLevel();
        Level level = this.level();
        if (!level.isClientSide) {
            SemiblockTracker tracker = SemiblockTracker.getInstance();
            tracker.putSemiblock(level, this.blockPos, this);
            NeoForge.EVENT_BUS.post((Event)new SemiblockEvent.PlaceEvent(level, this.blockPos, this));
            level.markAndNotifyBlock(this.blockPos, level.getChunkAt(this.blockPos), this.getBlockState(), this.getBlockState(), 3, 512);
        }
    }

    public void onRemovedFromLevel() {
        Level level = this.level();
        if (!level.isClientSide) {
            Direction dir = IDirectionalSemiblock.getDirection(this);
            SemiblockTracker.getInstance().clearSemiblock(level, this.blockPos, dir);
            NeoForge.EVENT_BUS.post((Event)new SemiblockEvent.BreakEvent(level, this.blockPos, this));
            if (this.beingRemoved) {
                this.getDrops().forEach(this::dropItem);
            }
        }
        this.doExtraCleanupTasks(this.beingRemoved);
        super.onRemovedFromLevel();
    }

    protected void doExtraCleanupTasks(boolean removingSemiblock) {
    }

    public boolean isNoGravity() {
        return true;
    }

    public boolean isPickable() {
        return true;
    }

    @Override
    public int getTrackingId() {
        return this.isAddedToLevel() ? this.getId() : -1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean canCoexist(ISemiBlock otherSemiblock) {
        AbstractSemiblockEntity abstractSemiblockEntity = this;
        if (!(abstractSemiblockEntity instanceof IDirectionalSemiblock)) return otherSemiblock instanceof IDirectionalSemiblock;
        IDirectionalSemiblock d1 = (IDirectionalSemiblock)((Object)abstractSemiblockEntity);
        if (!(otherSemiblock instanceof IDirectionalSemiblock)) return true;
        IDirectionalSemiblock d2 = (IDirectionalSemiblock)((Object)otherSemiblock);
        if (d1.getSide() == d2.getSide()) return false;
        return true;
    }

    @Override
    public void killedByEntity(Entity entity) {
        entity.level().playSound(null, this.blockPos, SoundEvents.ITEM_PICKUP, SoundSource.PLAYERS, 1.0f, 1.0f);
        this.dropOffset = entity.position().subtract(this.position()).normalize();
        this.beingRemoved = true;
        this.kill();
    }

    public boolean hurt(DamageSource source, float amount) {
        if (this.isInvulnerableTo(source) || !(source.getDirectEntity() instanceof Player)) {
            return false;
        }
        if (!this.level().isClientSide && this.isAlive()) {
            this.setTimeSinceHit(10);
            this.setDamageTaken(this.getDamageTaken() + amount * 10.0f);
            if (this.getDamageTaken() > 40.0f) {
                if (source.getEntity() != null) {
                    this.killedByEntity(source.getEntity());
                } else {
                    this.kill();
                }
            }
        }
        return true;
    }

    private void setDamageTaken(float damageTaken) {
        this.entityData.set(DAMAGE_TAKEN, (Object)Float.valueOf(damageTaken));
    }

    public float getDamageTaken() {
        return ((Float)this.entityData.get(DAMAGE_TAKEN)).floatValue();
    }

    private void setTimeSinceHit(int timeSinceHit) {
        this.entityData.set(TIME_SINCE_HIT, (Object)timeSinceHit);
    }

    public int getTimeSinceHit() {
        return (Integer)this.entityData.get(TIME_SINCE_HIT);
    }

    public boolean isAir() {
        return this.getBlockState().isAir();
    }

    @Override
    public void handleGUIButtonPress(String tag, boolean shiftHeld, ServerPlayer player) {
    }

    @Override
    public void writeToBuf(RegistryFriendlyByteBuf payload) {
    }

    @Override
    public void readFromBuf(RegistryFriendlyByteBuf payload) {
    }

    @Override
    public <T> Optional<T> getSemiblockCapability(EntityCapability<T, Direction> capability, Direction direction) {
        return Optional.ofNullable(this.getCapability(capability, direction));
    }

    @Override
    public <T> Optional<T> getSemiblockCapability(EntityCapability<T, Void> capability) {
        return Optional.ofNullable(this.getCapability(capability));
    }

    private record LogKey(ResourceKey<Level> dimension, BlockPos pos, Direction dir) {
    }
}

