/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.item;

import java.util.List;
import java.util.function.BiFunction;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.common.block.PressureTubeBlock;
import me.desht.pneumaticcraft.common.block.entity.tube.PressureTubeBlockEntity;
import me.desht.pneumaticcraft.common.registry.ModItems;
import me.desht.pneumaticcraft.common.tubemodules.AbstractTubeModule;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class TubeModuleItem
extends Item {
    private final BiFunction<Direction, PressureTubeBlockEntity, AbstractTubeModule> moduleFactory;

    public TubeModuleItem(BiFunction<Direction, PressureTubeBlockEntity, AbstractTubeModule> moduleFactory) {
        super(ModItems.defaultProps());
        this.moduleFactory = moduleFactory;
    }

    @Nonnull
    public AbstractTubeModule createModule(Direction dir, @Nullable PressureTubeBlockEntity blockEntity) {
        return this.moduleFactory.apply(dir, blockEntity);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        super.appendHoverText(stack, context, tooltip, flag);
        AbstractTubeModule module = this.createModule(Direction.UP, null);
        MutableComponent yesNo = Component.translatable((String)(module.isInline() ? "gui.yes" : "gui.no"));
        tooltip.add((Component)Component.translatable((String)"pneumaticcraft.gui.tubeModule.inline", (Object[])new Object[]{yesNo}).withStyle(ChatFormatting.DARK_AQUA));
    }

    public InteractionResult useOn(UseOnContext context) {
        BlockState state;
        if (context.getPlayer() != null && context.getPlayer().isCrouching() && (state = context.getLevel().getBlockState(context.getClickedPos())).getBlock() instanceof PressureTubeBlock) {
            BlockHitResult brtr = new BlockHitResult(context.getClickLocation(), context.getClickedFace().getOpposite(), context.getClickedPos(), false);
            return state.useItemOn(context.getItemInHand(), context.getLevel(), context.getPlayer(), context.getHand(), brtr).result();
        }
        return super.useOn(context);
    }
}

