/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.network;

import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.common.drone.IDroneBase;
import me.desht.pneumaticcraft.common.network.DronePacket;
import me.desht.pneumaticcraft.common.pneumatic_armor.CommonArmorHandler;
import me.desht.pneumaticcraft.common.pneumatic_armor.CommonUpgradeHandlers;
import me.desht.pneumaticcraft.common.registry.ModDataComponents;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public record PacketUpdateDebuggingDrone(DronePacket.DroneTarget droneTarget) implements DronePacket
{
    public static final CustomPacketPayload.Type<PacketUpdateDebuggingDrone> TYPE = new CustomPacketPayload.Type(PneumaticRegistry.RL("update_debugging_drone"));
    public static final StreamCodec<FriendlyByteBuf, PacketUpdateDebuggingDrone> STREAM_CODEC = StreamCodec.composite(DronePacket.DroneTarget.STREAM_CODEC, PacketUpdateDebuggingDrone::droneTarget, PacketUpdateDebuggingDrone::new);

    public static PacketUpdateDebuggingDrone create(IDroneBase drone) {
        return new PacketUpdateDebuggingDrone(drone == null ? DronePacket.DroneTarget.none() : drone.getPacketTarget());
    }

    public CustomPacketPayload.Type<PacketUpdateDebuggingDrone> type() {
        return TYPE;
    }

    @Override
    public void handle(Player player, IDroneBase droneBase) {
        CommonArmorHandler handler;
        if (player instanceof ServerPlayer && (handler = CommonArmorHandler.getHandlerForPlayer(player)).upgradeUsable(CommonUpgradeHandlers.droneDebugHandler, false)) {
            ItemStack stack = player.getItemBySlot(EquipmentSlot.HEAD);
            if (droneBase == null) {
                stack.remove(ModDataComponents.DRONE_DEBUG_TARGET);
            } else {
                droneBase.storeTrackerData(stack);
                droneBase.getDebugger().trackAsDebugged((ServerPlayer)player);
            }
        }
    }
}

