/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.recipes.assembly;

import java.util.Collection;
import me.desht.pneumaticcraft.api.crafting.recipe.AssemblyRecipe;
import me.desht.pneumaticcraft.common.block.entity.processing.AssemblyControllerBlockEntity;
import me.desht.pneumaticcraft.common.item.AssemblyProgramItem;
import me.desht.pneumaticcraft.common.recipes.assembly.AssemblyProgram;
import me.desht.pneumaticcraft.common.registry.ModItems;
import me.desht.pneumaticcraft.common.registry.ModRecipeTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class ProgramLaser
extends AssemblyProgram {
    @Override
    public AssemblyProgram.EnumMachine[] getRequiredMachines() {
        return new AssemblyProgram.EnumMachine[]{AssemblyProgram.EnumMachine.PLATFORM, AssemblyProgram.EnumMachine.IO_UNIT_EXPORT, AssemblyProgram.EnumMachine.IO_UNIT_IMPORT, AssemblyProgram.EnumMachine.LASER};
    }

    @Override
    public boolean executeStep(AssemblyControllerBlockEntity.AssemblySystem system) {
        boolean useAir = true;
        Level world = system.getPlatform().getLevel();
        if (!system.getPlatform().getHeldStack().isEmpty()) {
            if (this.canItemBeLasered(world, system.getPlatform().getHeldStack())) {
                system.getLaser().startLasering();
            } else if (system.getLaser().isIdle()) {
                useAir = system.getExportUnit().pickupItem(null);
            }
        } else {
            useAir = !system.getExportUnit().isIdle() ? system.getExportUnit().pickupItem(null) : system.getImportUnit().pickupItem(this.getRecipeList(world));
        }
        return useAir;
    }

    @Override
    public boolean validateBlockEntity(AssemblyControllerBlockEntity.AssemblySystem system) {
        return system.getLaser() != null;
    }

    private boolean canItemBeLasered(Level world, ItemStack item) {
        return ModRecipeTypes.ASSEMBLY_LASER.get().findFirst(world, r -> r.matches(item)).isPresent();
    }

    @Override
    public void writeToNBT(CompoundTag tag) {
    }

    @Override
    public void readFromNBT(CompoundTag tag) {
    }

    @Override
    public Collection<AssemblyRecipe> getRecipeList(Level level) {
        return ModRecipeTypes.ASSEMBLY_LASER.get().allRecipes(level);
    }

    @Override
    public AssemblyProgramItem getItem() {
        return (AssemblyProgramItem)((Object)ModItems.ASSEMBLY_PROGRAM_LASER.get());
    }
}

