/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.recipes.other;

import com.google.common.collect.ImmutableMap;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import me.desht.pneumaticcraft.api.crafting.recipe.HeatPropertiesRecipe;
import me.desht.pneumaticcraft.api.heat.IHeatExchangerLogic;
import me.desht.pneumaticcraft.common.heat.HeatExchangerLogicConstant;
import me.desht.pneumaticcraft.common.registry.ModRecipeSerializers;
import me.desht.pneumaticcraft.common.registry.ModRecipeTypes;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.commands.arguments.blocks.BlockStateParser;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.network.codec.NeoForgeStreamCodecs;

public class HeatPropertiesRecipeImpl
extends HeatPropertiesRecipe {
    private final Block block;
    private final BlockState inputState;
    private final HeatPropertiesRecipe.Transforms transforms;
    private final Map<String, String> predicates;
    private final Optional<Integer> heatCapacity;
    private final int temperature;
    private final Optional<Double> thermalResistance;
    private final String descriptionKey;
    private final HeatExchangerLogicConstant logic;

    public HeatPropertiesRecipeImpl(Block block, HeatPropertiesRecipe.Transforms transforms, Optional<Integer> heatCapacity, int temperature, Optional<Double> thermalResistance, Map<String, String> predicates, String descriptionKey) {
        this.block = block;
        this.transforms = transforms;
        this.predicates = ImmutableMap.copyOf(predicates);
        this.heatCapacity = heatCapacity;
        this.temperature = temperature;
        this.thermalResistance = thermalResistance;
        this.descriptionKey = descriptionKey;
        this.logic = new HeatExchangerLogicConstant(temperature, thermalResistance.orElse(0.0));
        this.inputState = this.makeInputState();
    }

    private BlockState makeInputState() {
        if (!this.predicates.isEmpty()) {
            List<String> l = this.predicates.entrySet().stream().map(e -> (String)e.getKey() + "=" + (String)e.getValue()).toList();
            try {
                String regName = PneumaticCraftUtils.getRegistryName(this.block).orElseThrow().toString();
                String str = regName + "[" + String.join((CharSequence)",", l) + "]";
                BlockStateParser.BlockResult res = BlockStateParser.parseForBlock((HolderLookup)BuiltInRegistries.BLOCK.asLookup(), (String)str, (boolean)false);
                return res.blockState();
            }
            catch (CommandSyntaxException e2) {
                return this.block.defaultBlockState();
            }
        }
        return this.block.defaultBlockState();
    }

    @Override
    public Optional<Integer> getHeatCapacity() {
        return this.heatCapacity;
    }

    @Override
    public int getTemperature() {
        return this.temperature;
    }

    @Override
    public Optional<Double> getThermalResistance() {
        return this.thermalResistance;
    }

    @Override
    public Block getBlock() {
        return this.block;
    }

    @Override
    public BlockState getBlockState() {
        return this.inputState;
    }

    @Override
    public HeatPropertiesRecipe.Transforms getTransforms() {
        return this.transforms;
    }

    @Override
    public Optional<BlockState> getTransformHot() {
        return this.transforms.hot();
    }

    @Override
    public Optional<BlockState> getTransformCold() {
        return this.transforms.cold();
    }

    @Override
    public Optional<BlockState> getTransformHotFlowing() {
        return this.transforms.hotFlowing();
    }

    @Override
    public Optional<BlockState> getTransformColdFlowing() {
        return this.transforms.coldFlowing();
    }

    @Override
    public IHeatExchangerLogic getLogic() {
        return this.logic;
    }

    public RecipeSerializer<?> getSerializer() {
        return ModRecipeSerializers.HEAT_PROPERTIES.get();
    }

    public RecipeType<?> getType() {
        return ModRecipeTypes.BLOCK_HEAT_PROPERTIES.get();
    }

    @Override
    public boolean matchState(BlockState state) {
        if (this.predicates.isEmpty()) {
            return true;
        }
        for (Map.Entry<String, String> entry : this.predicates.entrySet()) {
            Property iproperty = state.getBlock().getStateDefinition().getProperty(entry.getKey());
            if (iproperty == null) {
                return false;
            }
            Comparable comparable = iproperty.getValue(entry.getValue()).orElse(null);
            if (comparable != null && state.getValue(iproperty) == comparable) continue;
            return false;
        }
        return true;
    }

    @Override
    public Map<String, String> getBlockStatePredicates() {
        return this.predicates;
    }

    @Override
    public String getDescriptionKey() {
        return this.descriptionKey;
    }

    public static class Serializer<T extends HeatPropertiesRecipe>
    implements RecipeSerializer<T> {
        private static final Codec<Map<String, String>> PREDICATES_CODEC = Codec.unboundedMap((Codec)Codec.STRING, (Codec)Codec.STRING);
        private final MapCodec<T> codec = RecordCodecBuilder.mapCodec(builder -> builder.group((App)BuiltInRegistries.BLOCK.byNameCodec().fieldOf("block").forGetter(HeatPropertiesRecipe::getBlock), (App)HeatPropertiesRecipe.Transforms.CODEC.optionalFieldOf("transforms", (Object)HeatPropertiesRecipe.Transforms.NONE).forGetter(HeatPropertiesRecipe::getTransforms), (App)ExtraCodecs.NON_NEGATIVE_INT.optionalFieldOf("heatCapacity").forGetter(HeatPropertiesRecipe::getHeatCapacity), (App)ExtraCodecs.NON_NEGATIVE_INT.optionalFieldOf("temperature", (Object)0).forGetter(HeatPropertiesRecipe::getTemperature), (App)Codec.DOUBLE.optionalFieldOf("thermalResistance").forGetter(HeatPropertiesRecipe::getThermalResistance), (App)PREDICATES_CODEC.optionalFieldOf("predicates", Map.of()).forGetter(HeatPropertiesRecipe::getBlockStatePredicates), (App)Codec.STRING.optionalFieldOf("description", (Object)"").forGetter(HeatPropertiesRecipe::getDescriptionKey)).apply((Applicative)builder, factory::create));
        private final StreamCodec<RegistryFriendlyByteBuf, T> streamCodec = NeoForgeStreamCodecs.composite((StreamCodec)ByteBufCodecs.fromCodec((Codec)BuiltInRegistries.BLOCK.byNameCodec()), HeatPropertiesRecipe::getBlock, HeatPropertiesRecipe.Transforms.STREAM_CODEC, HeatPropertiesRecipe::getTransforms, (StreamCodec)ByteBufCodecs.optional((StreamCodec)ByteBufCodecs.INT), HeatPropertiesRecipe::getHeatCapacity, (StreamCodec)ByteBufCodecs.INT, HeatPropertiesRecipe::getTemperature, (StreamCodec)ByteBufCodecs.optional((StreamCodec)ByteBufCodecs.DOUBLE), HeatPropertiesRecipe::getThermalResistance, (StreamCodec)ByteBufCodecs.map(HashMap::new, (StreamCodec)ByteBufCodecs.STRING_UTF8, (StreamCodec)ByteBufCodecs.STRING_UTF8), HeatPropertiesRecipe::getBlockStatePredicates, (StreamCodec)ByteBufCodecs.STRING_UTF8, HeatPropertiesRecipe::getDescriptionKey, factory::create);

        public Serializer(IFactory<T> factory) {
        }

        public MapCodec<T> codec() {
            return this.codec;
        }

        public StreamCodec<RegistryFriendlyByteBuf, T> streamCodec() {
            return this.streamCodec;
        }
    }

    public static interface IFactory<T extends HeatPropertiesRecipe> {
        public T create(Block var1, HeatPropertiesRecipe.Transforms var2, Optional<Integer> var3, int var4, Optional<Double> var5, Map<String, String> var6, String var7);
    }
}

