/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.thirdparty.jei;

import java.util.ArrayList;
import java.util.List;
import me.desht.pneumaticcraft.common.block.EtchingTankBlock;
import me.desht.pneumaticcraft.common.block.entity.processing.UVLightBoxBlockEntity;
import me.desht.pneumaticcraft.common.item.EmptyPCBItem;
import me.desht.pneumaticcraft.common.registry.ModBlocks;
import me.desht.pneumaticcraft.common.thirdparty.jei.AbstractPNCCategory;
import me.desht.pneumaticcraft.common.thirdparty.jei.RecipeTypes;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Textures;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.neoforge.NeoForgeTypes;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.fluids.FluidStack;

public class JEIEtchingTankCategory
extends AbstractPNCCategory<EtchingTankRecipe> {
    private final IDrawableAnimated progressBar;

    JEIEtchingTankCategory() {
        super(RecipeTypes.ETCHING_TANK, (Component)PneumaticCraftUtils.xlate(((EtchingTankBlock)ModBlocks.ETCHING_TANK.get()).getDescriptionId(), new Object[0]), (IDrawable)JEIEtchingTankCategory.guiHelper().createDrawable(Textures.GUI_JEI_ETCHING_TANK, 0, 0, 83, 42), JEIEtchingTankCategory.guiHelper().createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)ModBlocks.ETCHING_TANK.get())));
        IDrawableStatic d = JEIEtchingTankCategory.guiHelper().createDrawable(Textures.GUI_JEI_ETCHING_TANK, 83, 0, 42, 42);
        this.progressBar = JEIEtchingTankCategory.guiHelper().createAnimatedDrawable(d, 60, IDrawableAnimated.StartDirection.LEFT, false);
    }

    public void setRecipe(IRecipeLayoutBuilder builder, EtchingTankRecipe recipe, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 1, 13).addIngredients(recipe.input);
        builder.addSlot(RecipeIngredientRole.INPUT, 26, 13).addIngredients((IIngredientType)NeoForgeTypes.FLUID_STACK, List.of(recipe.etchingFluid().copyWithAmount(1000)));
        builder.addSlot(RecipeIngredientRole.OUTPUT, 66, 1).addItemStack(recipe.output);
        builder.addSlot(RecipeIngredientRole.OUTPUT, 66, 25).addItemStack(recipe.failed);
    }

    public void draw(EtchingTankRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics graphics, double mouseX, double mouseY) {
        this.progressBar.draw(graphics, 20, 0);
    }

    static List<EtchingTankRecipe> getAllRecipes() {
        ArrayList<EtchingTankRecipe> recipes = new ArrayList<EtchingTankRecipe>();
        for (Item item : BuiltInRegistries.ITEM) {
            if (!(item instanceof EmptyPCBItem)) continue;
            EmptyPCBItem emptyPCBItem = (EmptyPCBItem)item;
            ItemStack[] inputs = new ItemStack[4];
            for (int i = 0; i < inputs.length; ++i) {
                inputs[i] = new ItemStack((ItemLike)emptyPCBItem);
                UVLightBoxBlockEntity.setExposureProgress(inputs[i], 25 + 25 * i);
            }
            recipes.add(new EtchingTankRecipe(Ingredient.of((ItemStack[])inputs), emptyPCBItem.getSuccessItem(), emptyPCBItem.getFailedItem(), EmptyPCBItem.getEtchingFluid()));
        }
        return recipes;
    }

    public record EtchingTankRecipe(Ingredient input, ItemStack output, ItemStack failed, FluidStack etchingFluid) {
    }
}

