/*
 * Decompiled with CFR 0.152.
 */
package mchorse.blockbuster;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.HashMap;
import java.util.List;
import mchorse.blockbuster.Blockbuster;
import mchorse.blockbuster.CommonProxy;
import mchorse.blockbuster.aperture.CameraHandler;
import mchorse.blockbuster.api.ModelClientHandler;
import mchorse.blockbuster.api.ModelHandler;
import mchorse.blockbuster.audio.AudioLibrary;
import mchorse.blockbuster.client.ActorsPack;
import mchorse.blockbuster.client.KeyboardHandler;
import mchorse.blockbuster.client.RenderingHandler;
import mchorse.blockbuster.client.gui.GuiRecordingOverlay;
import mchorse.blockbuster.client.gui.dashboard.GuiBlockbusterPanels;
import mchorse.blockbuster.client.render.GunMiscRender;
import mchorse.blockbuster.client.render.RenderActor;
import mchorse.blockbuster.client.render.RenderGunProjectile;
import mchorse.blockbuster.client.render.tileentity.TileEntityDirectorRenderer;
import mchorse.blockbuster.client.render.tileentity.TileEntityGunItemStackRenderer;
import mchorse.blockbuster.client.render.tileentity.TileEntityModelItemStackRenderer;
import mchorse.blockbuster.client.render.tileentity.TileEntityModelRenderer;
import mchorse.blockbuster.commands.CommandItemNBT;
import mchorse.blockbuster.commands.CommandModel;
import mchorse.blockbuster.common.block.BlockGreen;
import mchorse.blockbuster.common.entity.EntityActor;
import mchorse.blockbuster.common.entity.EntityGunProjectile;
import mchorse.blockbuster.common.tileentity.TileEntityDirector;
import mchorse.blockbuster.common.tileentity.TileEntityModel;
import mchorse.blockbuster.recording.RecordManager;
import mchorse.blockbuster.recording.capturing.FrameHandler;
import mchorse.blockbuster.utils.mclib.BlockbusterJarTree;
import mchorse.blockbuster.utils.mclib.BlockbusterTree;
import mchorse.blockbuster_pack.client.gui.trackers.GuiBaseTracker;
import mchorse.blockbuster_pack.client.gui.trackers.GuiMorphTracking;
import mchorse.blockbuster_pack.client.render.RenderCustomActor;
import mchorse.blockbuster_pack.morphs.StructureMorph;
import mchorse.blockbuster_pack.morphs.structure.StructureRenderer;
import mchorse.blockbuster_pack.trackers.ApertureCamera;
import mchorse.blockbuster_pack.trackers.BaseTracker;
import mchorse.blockbuster_pack.trackers.MorphTracker;
import mchorse.blockbuster_pack.trackers.TrackerRegistry;
import mchorse.mclib.McLib;
import mchorse.mclib.utils.files.FileTree;
import mchorse.mclib.utils.files.GlobalTree;
import mchorse.mclib.utils.files.entries.FolderEntry;
import mchorse.mclib.utils.resources.RLUtils;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.client.renderer.ItemModelMesher;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.tileentity.TileEntityItemStackRenderer;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.resources.IReloadableResourceManager;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.IResourcePack;
import net.minecraft.client.resources.SimpleReloadableResourceManager;
import net.minecraft.command.ICommand;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.ClientCommandHandler;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ClientProxy
extends CommonProxy {
    public static ActorsPack actorPack;
    public static GuiRecordingOverlay recordingOverlay;
    public static GuiBlockbusterPanels panels;
    public static RecordManager manager;
    public static RenderCustomActor actorRenderer;
    public static TileEntityModelRenderer modelRenderer;
    public static KeyboardHandler keys;
    public static BlockbusterTree tree;
    public static AudioLibrary audio;
    public static File skinsFolder;

    @Override
    public void preLoad(FMLPreInitializationEvent event) {
        super.preLoad(event);
        this.registerItemModel(Blockbuster.playbackItem, Blockbuster.path("playback"));
        this.registerItemModel(Blockbuster.registerItem, Blockbuster.path("register"));
        this.registerItemModel(Blockbuster.actorConfigItem, Blockbuster.path("actor_config"));
        this.registerItemModel(Blockbuster.gunItem, Blockbuster.path("gun"));
        this.registerItemModel(Blockbuster.directorBlock, Blockbuster.path("director"));
        ModelResourceLocation modelStatic = new ModelResourceLocation(Blockbuster.path("model_static"), "inventory");
        ModelResourceLocation model = new ModelResourceLocation(Blockbuster.path("model"), "inventory");
        ItemMeshDefinition meshDefinition = stack -> (Boolean)Blockbuster.modelBlockDisableItemRendering.get() != false ? modelStatic : model;
        TileEntityModelItemStackRenderer teModelItemSR = new TileEntityModelItemStackRenderer();
        for (int i = 0; i < Blockbuster.modelBlockItems.length; ++i) {
            Item modelBlockItem = Blockbuster.modelBlockItems[i];
            ModelBakery.registerItemVariants((Item)modelBlockItem, (ResourceLocation[])new ResourceLocation[]{model, modelStatic});
            ModelLoader.setCustomMeshDefinition((Item)modelBlockItem, (ItemMeshDefinition)meshDefinition);
            modelBlockItem.setTileEntityItemStackRenderer((TileEntityItemStackRenderer)teModelItemSR);
        }
        Blockbuster.gunItem.setTileEntityItemStackRenderer((TileEntityItemStackRenderer)new TileEntityGunItemStackRenderer());
        this.registerEntityRender(EntityActor.class, new RenderActor.FactoryActor());
        this.registerEntityRender(EntityGunProjectile.class, new RenderGunProjectile.FactoryGunProjectile());
        modelRenderer = new TileEntityModelRenderer();
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityModel.class, (TileEntitySpecialRenderer)modelRenderer);
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityDirector.class, (TileEntitySpecialRenderer)new TileEntityDirectorRenderer());
        this.injectResourcePack(CommonProxy.configFile.getAbsolutePath());
        StructureMorph.STRUCTURES = new HashMap<String, StructureRenderer>();
        audio = new AudioLibrary(new File(CommonProxy.configFile, "audio"));
        skinsFolder = new File(configFile, "skins");
        skinsFolder.mkdirs();
        ResourceLocation blockbusterIcon = RLUtils.create((String)"blockbuster", (String)"textures/gui/icon.png");
        File skinsDirectory = new File(configFile, "models/image/skins");
        File targetFile = new File(skinsDirectory, "default.png");
        if (!targetFile.exists()) {
            try {
                InputStream originalStream = Minecraft.func_71410_x().func_110442_L().func_110536_a(blockbusterIcon).func_110527_b();
                Files.copy(originalStream, targetFile.toPath(), new CopyOption[0]);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void injectResourcePack(String path) {
        try {
            Field field = FMLClientHandler.class.getDeclaredField("resourcePackList");
            field.setAccessible(true);
            List packs = (List)field.get(FMLClientHandler.instance());
            actorPack = new ActorsPack();
            packs.add(actorPack);
            IResourceManager manager = Minecraft.func_71410_x().func_110442_L();
            if (manager instanceof SimpleReloadableResourceManager) {
                ((SimpleReloadableResourceManager)manager).func_110545_a((IResourcePack)actorPack);
            }
            BlockbusterJarTree jarTree = new BlockbusterJarTree();
            tree = new BlockbusterTree(this.pack.folders.get(0));
            GlobalTree.TREE.register((FileTree)tree);
            GlobalTree.TREE.register((FileTree)jarTree);
            FileTree.addBackEntry((FolderEntry)jarTree.root);
            new File(path + "/models/steve/skins").mkdirs();
            new File(path + "/models/alex/skins").mkdirs();
            new File(path + "/models/fred/skins").mkdirs();
            new File(path + "/models/image/skins").mkdirs();
            new File(path + "/models/cape/skins").mkdirs();
            new File(path + "/models/eyes/3.0/skins").mkdirs();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void load(FMLInitializationEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        Item green = Item.func_150898_a((Block)Blockbuster.greenBlock);
        Item dimGreen = Item.func_150898_a((Block)Blockbuster.dimGreenBlock);
        ItemModelMesher mesher = mc.func_175599_af().func_175037_a();
        for (BlockGreen.ChromaColor color : BlockGreen.ChromaColor.values()) {
            ModelResourceLocation location = new ModelResourceLocation("blockbuster:green", "color=" + color.name);
            mesher.func_178086_a(green, color.ordinal(), location);
            mesher.func_178086_a(dimGreen, color.ordinal(), location);
        }
        recordingOverlay = new GuiRecordingOverlay(mc);
        actorRenderer = new RenderCustomActor(mc.func_175598_ae(), null, 0.0f);
        super.load(event);
        MinecraftForge.EVENT_BUS.register((Object)new FrameHandler());
        keys = new KeyboardHandler();
        MinecraftForge.EVENT_BUS.register((Object)keys);
        MinecraftForge.EVENT_BUS.register((Object)new RenderingHandler(recordingOverlay));
        MinecraftForge.EVENT_BUS.register((Object)new GunMiscRender());
        panels = new GuiBlockbusterPanels();
        McLib.EVENT_BUS.register((Object)panels);
        CameraHandler.registerClient();
        ClientCommandHandler.instance.func_71560_a((ICommand)new CommandModel());
        ClientCommandHandler.instance.func_71560_a((ICommand)new CommandItemNBT());
        ((IReloadableResourceManager)mc.func_110442_L()).func_110542_a(manager -> {
            audio.reset();
            if (Minecraft.func_71410_x().field_71439_g != null) {
                StructureMorph.reloadStructures();
            }
        });
        TrackerRegistry.CLIENT = new HashMap<Class<? extends BaseTracker>, GuiBaseTracker<? extends BaseTracker>>();
        TrackerRegistry.CLIENT.put(MorphTracker.class, new GuiMorphTracking(mc));
        TrackerRegistry.CLIENT.put(ApertureCamera.class, new GuiBaseTracker(mc));
    }

    protected void registerItemModel(Block block, String path) {
        this.registerItemModel(Item.func_150898_a((Block)block), path);
    }

    protected void registerItemModel(Item item, String path) {
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)new ModelResourceLocation(path, "inventory"));
    }

    protected void registerEntityRender(Class eclass, IRenderFactory factory) {
        RenderingRegistry.registerEntityRenderingHandler((Class)eclass, (IRenderFactory)factory);
    }

    @Override
    public boolean isClient() {
        return true;
    }

    @Override
    public ModelHandler getHandler() {
        return new ModelClientHandler();
    }

    @Override
    public String getLanguageString(String key, String defaultComment) {
        String comment = I18n.func_135052_a((String)key, (Object[])new Object[0]);
        return comment.equals(key) ? defaultComment : comment;
    }

    static {
        manager = new RecordManager();
    }
}

