/*
 * Decompiled with CFR 0.152.
 */
package mchorse.blockbuster.aperture.camera.modifiers;

import java.util.ArrayList;
import java.util.Iterator;
import mchorse.aperture.camera.CameraProfile;
import mchorse.aperture.camera.data.Angle;
import mchorse.aperture.camera.data.Position;
import mchorse.aperture.camera.fixtures.AbstractFixture;
import mchorse.aperture.camera.modifiers.AbstractModifier;
import mchorse.aperture.camera.modifiers.EntityModifier;
import mchorse.blockbuster.ClientProxy;
import mchorse.blockbuster.aperture.CameraHandler;
import mchorse.blockbuster.recording.scene.Replay;
import mchorse.blockbuster.utils.EntityUtils;
import mchorse.blockbuster_pack.morphs.TrackerMorph;
import mchorse.blockbuster_pack.trackers.ApertureCamera;
import mchorse.mclib.config.values.Value;
import mchorse.mclib.config.values.ValueBoolean;
import mchorse.mclib.config.values.ValueFloat;
import mchorse.metamorph.api.MorphUtils;
import mchorse.metamorph.api.morphs.AbstractMorph;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import org.lwjgl.opengl.GL11;

public class TrackerModifier
extends EntityModifier {
    public final ValueFloat yaw = new ValueFloat("yaw");
    public final ValueFloat pitch = new ValueFloat("pitch");
    public final ValueFloat roll = new ValueFloat("roll");
    public final ValueBoolean relative = new ValueBoolean("relative", true);
    public final ValueBoolean mainCam = new ValueBoolean("main_cam", true);
    public final ValueBoolean lookAt = new ValueBoolean("look_at");

    public TrackerModifier() {
        this.register((Value)this.yaw);
        this.register((Value)this.pitch);
        this.register((Value)this.roll);
        this.register((Value)this.relative);
        this.register((Value)this.mainCam);
        this.register((Value)this.lookAt);
    }

    public AbstractModifier create() {
        return new TrackerModifier();
    }

    public void modify(long ticks, long offset, AbstractFixture fixture, float partialTick, float previewPartialTick, CameraProfile profile, Position pos) {
        if (this.checkForDead()) {
            this.tryFindingEntity();
        }
        if (this.entities == null) {
            return;
        }
        if (!((Boolean)this.lookAt.get()).booleanValue()) {
            this.position.copy(pos);
        }
        if (fixture != null && ((Boolean)this.relative.get()).booleanValue()) {
            fixture.applyFixture(0L, 0.0f, 0.0f, profile, this.position);
        }
        if (!((Boolean)this.lookAt.get()).booleanValue()) {
            this.position.point.x = pos.point.x - this.position.point.x;
            this.position.point.y = pos.point.y - this.position.point.y;
            this.position.point.z = pos.point.z - this.position.point.z;
            this.position.angle.yaw = pos.angle.yaw - this.position.angle.yaw;
            this.position.angle.pitch = pos.angle.pitch - this.position.angle.pitch;
            this.position.angle.roll = pos.angle.roll - this.position.angle.roll;
            ApertureCamera.tracking = (String)this.selector.get();
            ApertureCamera.offsetPos.x = (float)this.offset.get().x;
            ApertureCamera.offsetPos.y = (float)this.offset.get().y;
            ApertureCamera.offsetPos.z = (float)this.offset.get().z;
            ApertureCamera.offsetRot.x = ((Float)this.pitch.get()).floatValue();
            ApertureCamera.offsetRot.y = ((Float)this.yaw.get()).floatValue();
            ApertureCamera.offsetRot.z = ((Float)this.roll.get()).floatValue();
            if (((Boolean)this.mainCam.get()).booleanValue()) {
                ApertureCamera.offsetPos.x = (float)((double)ApertureCamera.offsetPos.x + this.position.point.x);
                ApertureCamera.offsetPos.y = (float)((double)ApertureCamera.offsetPos.y + this.position.point.y);
                ApertureCamera.offsetPos.z = (float)((double)ApertureCamera.offsetPos.z + this.position.point.z);
                ApertureCamera.offsetRot.x += this.position.angle.pitch;
                ApertureCamera.offsetRot.y += this.position.angle.yaw;
                ApertureCamera.offsetRot.z += this.position.angle.roll;
            }
        }
        Entity entity = (Entity)this.entities.get(0);
        Render render = Minecraft.func_71410_x().func_175598_ae().func_78713_a(entity);
        double baseX = entity.field_70142_S + (entity.field_70165_t - entity.field_70142_S) * (double)partialTick;
        double baseY = entity.field_70137_T + (entity.field_70163_u - entity.field_70137_T) * (double)partialTick;
        double baseZ = entity.field_70136_U + (entity.field_70161_v - entity.field_70136_U) * (double)partialTick;
        float yaw = entity.field_70126_B + (entity.field_70177_z - entity.field_70126_B) * partialTick;
        GL11.glMatrixMode((int)5888);
        GL11.glPushMatrix();
        GL11.glLoadIdentity();
        ApertureCamera.enable = true;
        render.func_76986_a(entity, baseX, baseY, baseZ, yaw, partialTick);
        ApertureCamera.enable = false;
        GL11.glPopMatrix();
        GlStateManager.func_179140_f();
        if (((Boolean)this.lookAt.get()).booleanValue()) {
            double dX = (double)ApertureCamera.pos.x - pos.point.x + this.offset.get().x;
            double dY = (double)ApertureCamera.pos.y - pos.point.y + this.offset.get().y;
            double dZ = (double)ApertureCamera.pos.z - pos.point.z + this.offset.get().z;
            Angle angle = Angle.angle((double)dX, (double)dY, (double)dZ);
            if (((Boolean)this.relative.get()).booleanValue()) {
                angle.yaw += pos.angle.yaw + ((Float)this.yaw.get()).floatValue() - this.position.angle.yaw;
                angle.pitch += pos.angle.pitch + ((Float)this.pitch.get()).floatValue() - this.position.angle.pitch;
            }
            pos.angle.set(angle.yaw, angle.pitch);
        } else {
            pos.point.set((double)ApertureCamera.pos.x, (double)ApertureCamera.pos.y, (double)ApertureCamera.pos.z);
            if (((Boolean)this.mainCam.get()).booleanValue()) {
                pos.angle.set(ApertureCamera.rot.y, ApertureCamera.rot.x, ApertureCamera.rot.z, pos.angle.fov);
            } else {
                pos.point.x += this.position.point.x;
                pos.point.y += this.position.point.y;
                pos.point.z += this.position.point.z;
            }
        }
    }

    public void tryFindingEntity() {
        String selector = (String)this.selector.get();
        this.entities = null;
        if (selector != null && !selector.isEmpty() && FMLCommonHandler.instance().getSide() == Side.CLIENT) {
            this.queryActor(selector);
        }
    }

    protected boolean checkForDead() {
        if (!super.checkForDead()) {
            Iterator it = this.entities.iterator();
            while (it.hasNext()) {
                if (this.checkTracker(mchorse.metamorph.api.EntityUtils.getMorph((EntityLivingBase)((EntityLivingBase)it.next())), (String)this.selector.get())) continue;
                it.remove();
            }
            if (this.entities.isEmpty()) {
                this.entities = null;
            }
        }
        return this.entities == null;
    }

    private void queryActor(String selector) {
        if (CameraHandler.get() == null) {
            return;
        }
        ArrayList<String> replays = new ArrayList<String>();
        ArrayList<EntityLivingBase> entities = new ArrayList<EntityLivingBase>();
        for (Replay replay : ClientProxy.panels.scenePanel.getReplays()) {
            replays.add(replay.id);
        }
        for (EntityLivingBase actor2 : Minecraft.func_71410_x().field_71441_e.func_175644_a(EntityLivingBase.class, actor -> actor.func_70089_S() && EntityUtils.getRecordPlayer(actor) != null && EntityUtils.getRecordPlayer((EntityLivingBase)actor).record != null && replays.contains(EntityUtils.getRecordPlayer((EntityLivingBase)actor).record.filename) && mchorse.metamorph.api.EntityUtils.getMorph((EntityLivingBase)actor) != null)) {
            if (!this.checkTracker(mchorse.metamorph.api.EntityUtils.getMorph((EntityLivingBase)actor2), selector)) continue;
            entities.add(actor2);
        }
        if (!entities.isEmpty()) {
            this.entities = entities;
        }
    }

    private boolean checkTracker(AbstractMorph morph, String selector) {
        return MorphUtils.anyMatch((AbstractMorph)morph, element -> element instanceof TrackerMorph && ((TrackerMorph)element).tracker instanceof ApertureCamera && selector.equals(((TrackerMorph)element).tracker.name));
    }
}

