/*
 * Decompiled with CFR 0.152.
 */
package mchorse.blockbuster.api;

import java.util.HashMap;
import java.util.Map;
import mchorse.blockbuster.Blockbuster;
import mchorse.blockbuster.api.Model;
import mchorse.blockbuster.api.ModelPack;
import mchorse.blockbuster.api.loaders.lazy.IModelLazyLoader;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ModelHandler {
    public static long lastUpdate;
    public Map<String, Model> models = new HashMap<String, Model>();
    public ModelPack pack;

    public void loadModels(ModelPack pack, boolean force) {
        pack.reload();
        for (Map.Entry<String, IModelLazyLoader> entry : (force ? pack.models : pack.changed).entrySet()) {
            IModelLazyLoader loader = entry.getValue();
            try {
                if (force) {
                    this.removeModel(entry.getKey());
                }
                this.addModel(entry.getKey(), loader);
            }
            catch (Exception e) {
                e.printStackTrace();
                System.out.println("Error happened with " + entry.getKey());
            }
        }
        for (String key : pack.removed) {
            this.removeModel(key);
        }
        lastUpdate = System.currentTimeMillis();
    }

    public void addModel(String key, IModelLazyLoader loader) throws Exception {
        Model model = loader.loadModel(key);
        this.models.put(key, model);
        this.addMorph(key, model);
    }

    protected void addMorph(String key, Model model) {
        Blockbuster.proxy.factory.section.add(key, model, false);
    }

    public void removeModel(String key) {
        Model model = this.models.remove(key);
        if (model != null) {
            Blockbuster.proxy.factory.section.remove(key);
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onClientConnect(FMLNetworkEvent.ClientConnectedToServerEvent event) {
        Blockbuster.proxy.loadModels(false);
        Blockbuster.proxy.particles.reload();
    }
}

