/*
 * Decompiled with CFR 0.152.
 */
package mchorse.blockbuster.api;

import com.google.common.collect.ImmutableList;
import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import java.io.File;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import mchorse.blockbuster.Blockbuster;
import mchorse.blockbuster.CommonProxy;
import mchorse.blockbuster.api.ModelUserItem;
import mchorse.blockbuster.api.loaders.IModelLoader;
import mchorse.blockbuster.api.loaders.ModelLoaderJSON;
import mchorse.blockbuster.api.loaders.ModelLoaderOBJ;
import mchorse.blockbuster.api.loaders.ModelLoaderVOX;
import mchorse.blockbuster.api.loaders.lazy.IModelLazyLoader;
import mchorse.blockbuster.api.loaders.lazy.ModelLazyLoaderJSON;
import mchorse.blockbuster.api.loaders.lazy.ModelLazyLoaderOBJ;
import mchorse.blockbuster.api.loaders.lazy.ModelLazyLoaderVOX;
import mchorse.blockbuster.api.resource.IResourceEntry;
import mchorse.blockbuster.api.resource.StreamEntry;
import mchorse.blockbuster.utils.mclib.ImageFolder;
import net.minecraftforge.common.DimensionManager;
import org.apache.commons.io.IOUtils;

public class ModelPack {
    public List<IModelLoader> loaders = new ArrayList<IModelLoader>();
    public Map<String, IModelLazyLoader> models = new HashMap<String, IModelLazyLoader>();
    public List<File> folders = new ArrayList<File>();
    public Map<String, IModelLazyLoader> changed = new HashMap<String, IModelLazyLoader>();
    public List<String> removed = new ArrayList<String>();
    private long lastTime;
    private Map<String, ModelUserItem> packed = new HashMap<String, ModelUserItem>();

    public ModelPack() {
        this.loaders.add(new ModelLoaderVOX());
        this.loaders.add(new ModelLoaderOBJ());
        this.loaders.add(new ModelLoaderJSON());
        this.setupFolders();
        this.setupPackedModels();
    }

    private void setupPackedModels() {
        try {
            InputStream stream = this.getClass().getClassLoader().getResourceAsStream("assets/blockbuster/models/user.json");
            String json = IOUtils.toString((InputStream)stream, (Charset)StandardCharsets.UTF_8);
            this.packed = (Map)new Gson().fromJson(json, new TypeToken<Map<String, ModelUserItem>>(){}.getType());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public IModelLazyLoader create(File file) {
        IModelLoader loader;
        IModelLazyLoader lazyLoader = null;
        Iterator<IModelLoader> iterator = this.loaders.iterator();
        while (iterator.hasNext() && (lazyLoader = (loader = iterator.next()).load(file)) == null) {
        }
        return lazyLoader;
    }

    public void setupFolders() {
        File server;
        this.folders.clear();
        this.addFolder(new ImageFolder(CommonProxy.configFile, "models"));
        if (Blockbuster.modelFolderPath != null && !((String)Blockbuster.modelFolderPath.get()).isEmpty()) {
            this.addFolder(new File((String)Blockbuster.modelFolderPath.get()));
        }
        if ((server = DimensionManager.getCurrentSaveRootDirectory()) != null) {
            this.addFolder(new File(server, "blockbuster/models"));
        }
    }

    private void addFolder(File folder) {
        folder.mkdirs();
        if (folder.isDirectory()) {
            this.folders.add(folder);
        }
    }

    public void reload() {
        this.setupFolders();
        this.changed.clear();
        this.removed.clear();
        this.lastTime = System.currentTimeMillis();
        for (File folder : this.folders) {
            this.reloadModels(folder, "");
        }
        this.removeOld();
        try {
            this.addDefaultModel("alex");
            this.addDefaultModel("alex_3d");
            this.addDefaultModel("steve");
            this.addDefaultModel("steve_3d");
            this.addDefaultModel("fred");
            this.addDefaultModel("fred_3d");
            this.addDefaultModel("empty");
            this.addDefaultModel("cape");
            ImmutableList shapes = ImmutableList.of((Object)"eyebrow_l", (Object)"eyebrow_r", (Object)"eyelid_lb", (Object)"eyelid_lt", (Object)"eyelid_rb", (Object)"eyelid_rt");
            this.addDefaultModel("eyes/3.0");
            this.addDefaultModel("eyes/3.0_1px");
            this.addDefaultModelWithShapes("eyes/3.1", (List<String>)shapes);
            this.addDefaultModelWithShapes("eyes/3.1_simple", (List<String>)shapes);
            this.addDefaultModel("eyes/alex");
            this.addDefaultModel("eyes/steve");
            this.addDefaultModel("eyes/fred");
            this.addDefaultModel("eyes/head");
            this.addDefaultModel("eyes/head_3d");
            this.addDefaultModel("mchorse/head");
            if (this.packed != null) {
                for (Map.Entry<String, ModelUserItem> entry : this.packed.entrySet()) {
                    this.addUserModel(entry.getKey(), entry.getValue());
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void addUserModel(String id, ModelUserItem userItem) {
        IModelLazyLoader lazy = this.models.get(id);
        if (lazy == null) {
            String path = "assets/blockbuster/models/user/" + id;
            ClassLoader loader = this.getClass().getClassLoader();
            StreamEntry json = new StreamEntry(path + "/model.json", 0L, loader);
            if (userItem.obj != null) {
                String mtlPath = userItem.mtl == null ? null : path + "/" + userItem.mtl;
                StreamEntry obj = new StreamEntry(path + "/" + userItem.obj, 0L, loader);
                StreamEntry mtl = new StreamEntry(mtlPath, 0L, loader);
                ArrayList<IResourceEntry> s = new ArrayList<IResourceEntry>();
                if (userItem.shapes != null) {
                    for (String shape : userItem.shapes) {
                        s.add(new StreamEntry(path + "/" + shape, 0L, loader));
                    }
                }
                lazy = new ModelLazyLoaderOBJ((IResourceEntry)json, (IResourceEntry)obj, (IResourceEntry)mtl, s);
            } else {
                lazy = userItem.vox != null ? new ModelLazyLoaderVOX(json, new StreamEntry(path + "/" + userItem.vox, 0L, loader)) : new ModelLazyLoaderJSON(json);
            }
            lazy.setLastTime(-1L);
            this.models.put(id, lazy);
            this.changed.put(id, lazy);
            this.removed.remove(id);
        }
    }

    private void removeOld() {
        Iterator<Map.Entry<String, IModelLazyLoader>> it = this.models.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, IModelLazyLoader> entry = it.next();
            long lastTime = entry.getValue().getLastTime();
            if (lastTime >= this.lastTime || lastTime < 0L) continue;
            it.remove();
            this.removed.add(entry.getKey());
        }
    }

    private void addDefaultModel(String id) throws Exception {
        IModelLazyLoader lazy = this.models.get(id);
        if (lazy == null) {
            String path = "assets/blockbuster/models/entity/";
            ClassLoader loader = this.getClass().getClassLoader();
            lazy = new ModelLazyLoaderJSON(new StreamEntry(path + id + ".json", 0L, loader));
            lazy.setLastTime(-1L);
            this.models.put(id, lazy);
            this.changed.put(id, lazy);
            this.removed.remove(id);
        }
    }

    private void addDefaultModelWithShapes(String id, List<String> shapes) throws Exception {
        IModelLazyLoader lazy = this.models.get(id);
        if (lazy == null) {
            String path = "assets/blockbuster/models/entity/";
            ClassLoader loader = this.getClass().getClassLoader();
            StreamEntry json = new StreamEntry(path + id + ".json", 0L, loader);
            StreamEntry obj = new StreamEntry(path + id + "/base.obj", 0L, loader);
            ArrayList<IResourceEntry> s = new ArrayList<IResourceEntry>();
            for (String shape : shapes) {
                s.add(new StreamEntry(path + id + "/" + shape + ".obj", 0L, loader));
            }
            lazy = new ModelLazyLoaderOBJ((IResourceEntry)json, (IResourceEntry)obj, (IResourceEntry)new StreamEntry(null, 0L, loader), s);
            lazy.setLastTime(-1L);
            this.models.put(id, lazy);
            this.changed.put(id, lazy);
            this.removed.remove(id);
        }
    }

    protected void reloadModels(File folder, String prefix) {
        for (File file : folder.listFiles()) {
            String name = file.getName();
            if (name.startsWith("__") || name.equals("skins") || file.isFile() || name.equals("particles") && prefix.isEmpty()) continue;
            String path = prefix + name;
            IModelLazyLoader lazyLoader = this.models.get(path);
            if (lazyLoader != null && lazyLoader.getLastTime() >= 0L) {
                if (lazyLoader.stillExists()) {
                    lazyLoader.setLastTime(this.lastTime);
                    if (!lazyLoader.hasChanged()) continue;
                    this.changed.put(path, lazyLoader);
                    continue;
                }
            } else {
                lazyLoader = null;
            }
            for (IModelLoader loader : this.loaders) {
                lazyLoader = loader.load(file);
                if (lazyLoader == null) continue;
                lazyLoader.setLastTime(this.lastTime);
                break;
            }
            if (lazyLoader != null) {
                this.models.put(path, lazyLoader);
                this.changed.put(path, lazyLoader);
                continue;
            }
            this.reloadModels(file, path + "/");
        }
    }
}

