/*
 * Decompiled with CFR 0.152.
 */
package mchorse.blockbuster.api.formats.obj;

import java.util.Objects;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class ShapeKey {
    public String name;
    public float value;
    public boolean relative = true;

    public ShapeKey() {
    }

    public ShapeKey(String name, float value) {
        this.name = name;
        this.value = value;
    }

    public ShapeKey(String name, float value, boolean relative) {
        this(name, value);
        this.relative = relative;
    }

    public ShapeKey setValue(float value) {
        this.value = value;
        return this;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ShapeKey) {
            ShapeKey shape = (ShapeKey)obj;
            return this.value == shape.value && Objects.equals(this.name, shape.name) && this.relative == shape.relative;
        }
        return super.equals(obj);
    }

    public ShapeKey copy() {
        return new ShapeKey(this.name, this.value, this.relative);
    }

    public NBTBase toNBT() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74778_a("Name", this.name);
        tag.func_74776_a("Value", this.value);
        tag.func_74757_a("Relative", this.relative);
        return tag;
    }

    public void fromNBT(NBTTagCompound key) {
        this.name = key.func_74779_i("Name");
        this.value = key.func_74760_g("Value");
        this.relative = key.func_74767_n("Relative");
    }
}

