/*
 * Decompiled with CFR 0.152.
 */
package mchorse.blockbuster.api.formats.vox;

import javax.vecmath.Matrix3f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;
import mchorse.blockbuster.api.formats.Mesh;
import mchorse.blockbuster.api.formats.vox.data.Vox;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class VoxBuilder {
    public Matrix3f transform;
    public Vector3f vector = new Vector3f();
    private Vector3f right;
    private Vector3f left;
    private Vector3f front;
    private Vector3f back;
    private Vector3f bottom;
    private Vector3f top;

    public VoxBuilder(Matrix3f transform) {
        this.transform = transform;
        this.right = this.processNormal(new Vector3f(-1.0f, 0.0f, 0.0f));
        this.left = this.processNormal(new Vector3f(1.0f, 0.0f, 0.0f));
        this.front = this.processNormal(new Vector3f(0.0f, 0.0f, 1.0f));
        this.back = this.processNormal(new Vector3f(0.0f, 0.0f, -1.0f));
        this.bottom = this.processNormal(new Vector3f(0.0f, -1.0f, 0.0f));
        this.top = this.processNormal(new Vector3f(0.0f, 1.0f, 0.0f));
    }

    private Vector3f processNormal(Vector3f normal) {
        normal.set(normal.x, normal.z, normal.y);
        this.transform.transform((Tuple3f)normal);
        normal.set(normal.x, normal.z, normal.y);
        normal.normalize();
        return normal;
    }

    public Mesh build(Vox vox) {
        Mesh mesh = new Mesh(vox.blocks * 12);
        mesh.triangles = 0;
        for (int x = 0; x < vox.x; ++x) {
            for (int y = 0; y < vox.y; ++y) {
                for (int z = 0; z < vox.z; ++z) {
                    int voxel = vox.voxels[vox.toIndex(x, y, z)];
                    if (voxel == 0) continue;
                    this.buildVertex(mesh, x, y, z, voxel, vox);
                }
            }
        }
        return mesh;
    }

    private void buildVertex(Mesh mesh, int x, int y, int z, int voxel, Vox vox) {
        Vector3f normal;
        boolean top = vox.has(x, y + 1, z);
        boolean bottom = vox.has(x, y - 1, z);
        boolean left = vox.has(x + 1, y, z);
        boolean right = vox.has(x - 1, y, z);
        boolean front = vox.has(x, y, z + 1);
        boolean back = vox.has(x, y, z - 1);
        if (!top) {
            normal = this.top;
            this.add(mesh, vox, x, y + 1, z, voxel, -0.5f, -0.5f, normal);
            this.add(mesh, vox, x + 1, y + 1, z, voxel, 0.5f, -0.5f, normal);
            this.add(mesh, vox, x, y + 1, z + 1, voxel, -0.5f, 0.5f, normal);
            this.add(mesh, vox, x, y + 1, z + 1, voxel, -0.5f, 0.5f, normal);
            this.add(mesh, vox, x + 1, y + 1, z, voxel, 0.5f, -0.5f, normal);
            this.add(mesh, vox, x + 1, y + 1, z + 1, voxel, 0.5f, 0.5f, normal);
        }
        if (!bottom) {
            normal = this.bottom;
            this.add(mesh, vox, x, y, z, voxel, -0.5f, -0.5f, normal);
            this.add(mesh, vox, x, y, z + 1, voxel, -0.5f, 0.5f, normal);
            this.add(mesh, vox, x + 1, y, z, voxel, 0.5f, -0.5f, normal);
            this.add(mesh, vox, x, y, z + 1, voxel, -0.5f, 0.5f, normal);
            this.add(mesh, vox, x + 1, y, z + 1, voxel, 0.5f, 0.5f, normal);
            this.add(mesh, vox, x + 1, y, z, voxel, 0.5f, -0.5f, normal);
        }
        if (!left) {
            normal = this.left;
            this.add(mesh, vox, x + 1, y, z, voxel, -0.5f, -0.5f, normal);
            this.add(mesh, vox, x + 1, y, z + 1, voxel, -0.5f, 0.5f, normal);
            this.add(mesh, vox, x + 1, y + 1, z, voxel, 0.5f, -0.5f, normal);
            this.add(mesh, vox, x + 1, y + 1, z, voxel, 0.5f, -0.5f, normal);
            this.add(mesh, vox, x + 1, y, z + 1, voxel, -0.5f, 0.5f, normal);
            this.add(mesh, vox, x + 1, y + 1, z + 1, voxel, 0.5f, 0.5f, normal);
        }
        if (!right) {
            normal = this.right;
            this.add(mesh, vox, x, y, z, voxel, -0.5f, -0.5f, normal);
            this.add(mesh, vox, x, y + 1, z, voxel, 0.5f, -0.5f, normal);
            this.add(mesh, vox, x, y, z + 1, voxel, -0.5f, 0.5f, normal);
            this.add(mesh, vox, x, y + 1, z, voxel, 0.5f, -0.5f, normal);
            this.add(mesh, vox, x, y + 1, z + 1, voxel, 0.5f, 0.5f, normal);
            this.add(mesh, vox, x, y, z + 1, voxel, -0.5f, 0.5f, normal);
        }
        if (!front) {
            normal = this.front;
            this.add(mesh, vox, x, y, z + 1, voxel, -0.5f, -0.5f, normal);
            this.add(mesh, vox, x, y + 1, z + 1, voxel, -0.5f, 0.5f, normal);
            this.add(mesh, vox, x + 1, y, z + 1, voxel, 0.5f, -0.5f, normal);
            this.add(mesh, vox, x, y + 1, z + 1, voxel, -0.5f, 0.5f, normal);
            this.add(mesh, vox, x + 1, y + 1, z + 1, voxel, 0.5f, 0.5f, normal);
            this.add(mesh, vox, x + 1, y, z + 1, voxel, 0.5f, -0.5f, normal);
        }
        if (!back) {
            normal = this.back;
            this.add(mesh, vox, x, y, z, voxel, -0.5f, -0.5f, normal);
            this.add(mesh, vox, x + 1, y, z, voxel, 0.5f, -0.5f, normal);
            this.add(mesh, vox, x, y + 1, z, voxel, -0.5f, 0.5f, normal);
            this.add(mesh, vox, x, y + 1, z, voxel, -0.5f, 0.5f, normal);
            this.add(mesh, vox, x + 1, y, z, voxel, 0.5f, -0.5f, normal);
            this.add(mesh, vox, x + 1, y + 1, z, voxel, 0.5f, 0.5f, normal);
        }
    }

    private void add(Mesh mesh, Vox vox, int x, int y, int z, int voxel, float offsetU, float offsetV, Vector3f normal) {
        int tris = mesh.triangles++;
        float u = ((float)voxel + 0.5f + offsetU) / 256.0f;
        float v = 0.5f + offsetV;
        Vector3f vertex = this.process(x, y, z, vox);
        mesh.posData[tris * 3] = vertex.x;
        mesh.posData[tris * 3 + 1] = vertex.y;
        mesh.posData[tris * 3 + 2] = vertex.z;
        mesh.normData[tris * 3] = normal.x;
        mesh.normData[tris * 3 + 1] = normal.y;
        mesh.normData[tris * 3 + 2] = normal.z;
        mesh.texData[tris * 2] = u;
        mesh.texData[tris * 2 + 1] = v;
    }

    private Vector3f process(int x, int y, int z, Vox vox) {
        int w = (int)((float)vox.x / 2.0f);
        int h = (int)((float)vox.y / 2.0f);
        int d = (int)((float)vox.z / 2.0f);
        this.vector.set((float)(x - w), (float)(z - d), (float)(y - h));
        this.transform.transform((Tuple3f)this.vector);
        this.vector.set(this.vector.x, this.vector.z, this.vector.y);
        return this.vector;
    }
}

