/*
 * Decompiled with CFR 0.152.
 */
package mchorse.blockbuster.api.formats.vox.data;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.vecmath.Matrix3f;
import javax.vecmath.Matrix4f;
import javax.vecmath.Vector3f;
import mchorse.blockbuster.api.formats.vox.VoxReader;
import mchorse.blockbuster.api.formats.vox.data.VoxBaseNode;

public class VoxTransform
extends VoxBaseNode {
    public int childId;
    public int unusedId;
    public int layerId;
    public List<Matrix4f> transforms;

    public VoxTransform(InputStream stream, VoxReader reader) throws Exception {
        this.id = reader.readInt(stream);
        this.attrs = reader.readDictionary(stream);
        this.childId = reader.readInt(stream);
        this.unusedId = reader.readInt(stream);
        this.layerId = reader.readInt(stream);
        this.num = reader.readInt(stream);
        this.transforms = new ArrayList<Matrix4f>();
        for (int i = 0; i < this.num; ++i) {
            String[] splits;
            Map<String, String> dict = reader.readDictionary(stream);
            Matrix3f rotation = new Matrix3f();
            Vector3f translate = new Vector3f(0.0f, 0.0f, 0.0f);
            rotation.setIdentity();
            if (dict.containsKey("_r")) {
                rotation = reader.readRotation(Integer.parseInt(dict.get("_r")));
            }
            if (dict.containsKey("_t") && (splits = dict.get("_t").split(" ")).length == 3) {
                translate.set((float)(-Integer.parseInt(splits[0])), (float)Integer.parseInt(splits[1]), (float)Integer.parseInt(splits[2]));
            }
            Matrix4f transform = new Matrix4f();
            transform.set(rotation);
            transform.setTranslation(translate);
            this.transforms.add(transform);
        }
    }
}

