/*
 * Decompiled with CFR 0.152.
 */
package mchorse.blockbuster.api.json;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import mchorse.blockbuster.api.ModelLimb;
import mchorse.blockbuster.api.json.ModelAdapter;
import mchorse.blockbuster.api.json.ModelPoseAdapter;
import mchorse.blockbuster.common.OrientedBB;

public class ModelLimbAdapter
implements JsonSerializer<ModelLimb>,
JsonDeserializer<ModelLimb> {
    public JsonElement serialize(ModelLimb src, Type typeOfSrc, JsonSerializationContext context) {
        JsonElement serial = ModelAdapter.plainGSON.toJsonTree((Object)src, typeOfSrc);
        JsonObject map = serial.getAsJsonObject();
        map.remove("sizeOffset");
        map.remove("itemScale");
        map.remove("holding");
        map.remove("slot");
        map.remove("parent");
        map.remove("name");
        map.remove("opacity");
        map.remove("color");
        if (!src.obbs.isEmpty()) {
            JsonArray jsonOBBs = new JsonArray();
            for (OrientedBB obb : src.obbs) {
                JsonObject jsonOBB = new JsonObject();
                JsonArray size = new JsonArray();
                size.add((Number)(obb.hw * 32.0));
                size.add((Number)(obb.hu * 32.0));
                size.add((Number)(obb.hv * 32.0));
                jsonOBB.add("size", (JsonElement)size);
                if (obb.anchorOffset.x != 0.0 || obb.anchorOffset.y != 0.0 || obb.anchorOffset.z != 0.0) {
                    JsonArray anchor = new JsonArray();
                    anchor.add((Number)(obb.anchorOffset.x * 16.0));
                    anchor.add((Number)(obb.anchorOffset.y * 16.0));
                    anchor.add((Number)(obb.anchorOffset.z * 16.0));
                    jsonOBB.add("anchor", (JsonElement)anchor);
                }
                if (obb.limbOffset.x != 0.0 || obb.limbOffset.y != 0.0 || obb.limbOffset.z != 0.0) {
                    JsonArray translate = new JsonArray();
                    translate.add((Number)(obb.limbOffset.x * 16.0));
                    translate.add((Number)(obb.limbOffset.y * 16.0));
                    translate.add((Number)(obb.limbOffset.z * 16.0));
                    jsonOBB.add("translate", (JsonElement)translate);
                }
                if (obb.rotation0[0] != 0.0 || obb.rotation0[1] != 0.0 || obb.rotation0[2] != 0.0) {
                    JsonArray rotation = new JsonArray();
                    rotation.add((Number)obb.rotation0[0]);
                    rotation.add((Number)obb.rotation0[1]);
                    rotation.add((Number)obb.rotation0[2]);
                    jsonOBB.add("rotate", (JsonElement)rotation);
                }
                jsonOBBs.add((JsonElement)jsonOBB);
            }
            map.add("orientedBBs", (JsonElement)jsonOBBs);
        }
        if (src.sizeOffset != 0.0f) {
            map.addProperty("sizeOffset", (Number)Float.valueOf(src.sizeOffset));
        }
        if (src.itemScale != 1.0f) {
            map.addProperty("itemScale", (Number)Float.valueOf(src.itemScale));
        }
        if (src.holding != ModelLimb.Holding.NONE) {
            map.addProperty("holding", src.holding == ModelLimb.Holding.RIGHT ? "right" : "left");
        }
        if (src.slot != null && src.slot != ModelLimb.ArmorSlot.NONE) {
            map.addProperty("slot", src.slot.name);
        }
        if (!src.parent.isEmpty()) {
            map.addProperty("parent", src.parent);
        }
        if (!ModelPoseAdapter.isDefault(src.color, 1.0f)) {
            ModelPoseAdapter.addFloatArray(map, "color", src.color);
        }
        if (src.opacity != 1.0f) {
            map.addProperty("opacity", (Number)Float.valueOf(src.opacity));
        }
        this.addBoolean(map, "lighting", src.lighting, true);
        this.addBoolean(map, "shading", src.shading, true);
        this.addBoolean(map, "smooth", src.smooth, false);
        this.addBoolean(map, "is3D", src.is3D, false);
        this.addBoolean(map, "hold", src.hold, true);
        this.addBoolean(map, "mirror", src.mirror, false);
        this.addBoolean(map, "lookX", src.lookX, false);
        this.addBoolean(map, "lookY", src.lookY, false);
        this.addBoolean(map, "idle", src.idle, false);
        this.addBoolean(map, "swinging", src.swinging, false);
        this.addBoolean(map, "swiping", src.swiping, false);
        this.addBoolean(map, "invert", src.invert, false);
        this.addBoolean(map, "wheel", src.wheel, false);
        this.addBoolean(map, "wing", src.wing, false);
        this.addBoolean(map, "roll", src.roll, false);
        this.addBoolean(map, "cape", src.cape, false);
        if (!ModelPoseAdapter.isDefault(src.origin, 0.0f)) {
            ModelPoseAdapter.addFloatArray(map, "origin", src.origin);
        }
        return map;
    }

    public ModelLimb deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        ModelLimb limb = (ModelLimb)ModelAdapter.plainGSON.fromJson(json, ModelLimb.class);
        JsonObject object = json.getAsJsonObject();
        if (object.has("orientedBBs")) {
            JsonArray obbs = object.getAsJsonArray("orientedBBs");
            for (JsonElement element : obbs) {
                JsonObject jsonOBB = element.getAsJsonObject();
                OrientedBB obb = new OrientedBB();
                if (jsonOBB.has("size")) {
                    obb.hw = jsonOBB.getAsJsonArray("size").get(0).getAsDouble() / 32.0;
                    obb.hu = jsonOBB.getAsJsonArray("size").get(1).getAsDouble() / 32.0;
                    obb.hv = jsonOBB.getAsJsonArray("size").get(2).getAsDouble() / 32.0;
                }
                if (jsonOBB.has("anchor")) {
                    obb.anchorOffset.x = jsonOBB.getAsJsonArray("anchor").get(0).getAsDouble() / 16.0;
                    obb.anchorOffset.y = jsonOBB.getAsJsonArray("anchor").get(1).getAsDouble() / 16.0;
                    obb.anchorOffset.z = jsonOBB.getAsJsonArray("anchor").get(2).getAsDouble() / 16.0;
                }
                if (jsonOBB.has("translate")) {
                    obb.limbOffset.x = jsonOBB.getAsJsonArray("translate").get(0).getAsDouble() / 16.0;
                    obb.limbOffset.y = jsonOBB.getAsJsonArray("translate").get(1).getAsDouble() / 16.0;
                    obb.limbOffset.z = jsonOBB.getAsJsonArray("translate").get(2).getAsDouble() / 16.0;
                }
                if (jsonOBB.has("rotate")) {
                    obb.rotation0[0] = jsonOBB.getAsJsonArray("rotate").get(0).getAsDouble();
                    obb.rotation0[1] = jsonOBB.getAsJsonArray("rotate").get(1).getAsDouble();
                    obb.rotation0[2] = jsonOBB.getAsJsonArray("rotate").get(2).getAsDouble();
                }
                limb.obbs.add(obb);
            }
        }
        if (object.has("looking") && object.get("looking").isJsonPrimitive()) {
            boolean looking;
            limb.lookX = limb.lookY = (looking = object.get("looking").getAsBoolean());
        }
        if (object.has("holding") && object.get("holding").isJsonPrimitive()) {
            String holding = object.get("holding").getAsString();
            if (holding.equals("right")) {
                limb.holding = ModelLimb.Holding.RIGHT;
            } else if (holding.equals("left")) {
                limb.holding = ModelLimb.Holding.LEFT;
            }
        }
        if (limb.holding == null) {
            limb.holding = ModelLimb.Holding.NONE;
        }
        if (object.has("slot")) {
            try {
                limb.slot = ModelLimb.ArmorSlot.fromName(object.get("slot").getAsString());
            }
            catch (Exception exception) {}
        } else {
            limb.slot = ModelLimb.ArmorSlot.NONE;
        }
        return limb;
    }

    private void addBoolean(JsonObject map, String name, boolean value, boolean defaultValue) {
        map.remove(name);
        if (value != defaultValue) {
            map.addProperty(name, Boolean.valueOf(value));
        }
    }
}

