/*
 * Decompiled with CFR 0.152.
 */
package mchorse.blockbuster.client.gui;

import java.util.Stack;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.vecmath.Matrix4f;
import javax.vecmath.Vector3f;
import mchorse.blockbuster.client.gui.GuiImmersiveEditor;
import mchorse.blockbuster.common.entity.EntityActor;
import mchorse.blockbuster.recording.data.Frame;
import mchorse.blockbuster_pack.client.gui.GuiSequencerMorph;
import mchorse.mclib.client.gui.framework.GuiBase;
import mchorse.mclib.client.gui.framework.elements.GuiModelRenderer;
import mchorse.mclib.client.gui.framework.elements.IGuiElement;
import mchorse.mclib.client.gui.framework.elements.buttons.GuiButtonElement;
import mchorse.mclib.client.gui.framework.elements.utils.GuiContext;
import mchorse.mclib.client.gui.utils.keys.IKey;
import mchorse.mclib.utils.MathUtils;
import mchorse.metamorph.api.EntityUtils;
import mchorse.metamorph.api.MorphAPI;
import mchorse.metamorph.api.MorphUtils;
import mchorse.metamorph.api.morphs.AbstractMorph;
import mchorse.metamorph.client.gui.creative.GuiCreativeMorphsMenu;
import mchorse.metamorph.client.gui.creative.GuiMorphRenderer;
import mchorse.metamorph.client.gui.editor.GuiAbstractMorph;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.Gui;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class GuiImmersiveMorphMenu
extends GuiCreativeMorphsMenu {
    public boolean immersionMode = true;
    public EntityLivingBase target;
    public Consumer<GuiImmersiveMorphMenu> updateCallback;
    public boolean hideGuiModel = true;
    public Function<Integer, Frame> frameProvider;
    public Consumer<GuiContext> beforeRender;
    public Consumer<GuiContext> afterRender;
    private PreviewMorph preview = new PreviewMorph();
    private AbstractMorph lastMorph;
    private Stack<Boolean> stack = new Stack();

    public GuiImmersiveMorphMenu(Minecraft mc) {
        super(mc, true, null);
        GuiButtonElement close = new GuiButtonElement(mc, IKey.str((String)"X"), b -> this.exit());
        close.flex().w(20);
        this.bar.add((IGuiElement)close);
        this.keys().register(IKey.lang((String)"blockbuster.gui.morphs.keys.toggle_gui_model"), 61, () -> {
            this.hideGuiModel = !this.hideGuiModel;
        }).category(GuiImmersiveEditor.CATEGORY).active(() -> this.isImmersionMode());
    }

    public void nestEdit(AbstractMorph selected, boolean editing, boolean keepViewport, Consumer<AbstractMorph> callback) {
        this.stack.add(this.immersionMode);
        this.immersionMode &= keepViewport;
        super.nestEdit(selected, editing, keepViewport, callback);
    }

    public void restoreEdit() {
        super.restoreEdit();
        this.immersionMode = this.stack.pop();
    }

    public void exit() {
        if (this.isEditMode() || this.isNested()) {
            if (this.isEditMode()) {
                ((GuiAbstractMorph)this.editor.delegate).renderer.fov = 70.0f;
            }
            super.exit();
        } else {
            ((GuiImmersiveEditor)this.mc.field_71462_r).closeThisScreen();
        }
    }

    public void finish() {
        super.finish();
        this.frameProvider = null;
        this.beforeRender = null;
        this.afterRender = null;
        this.pickMorph(this.getSelected());
    }

    public void draw(GuiContext context) {
        if (!this.isImmersionMode()) {
            Gui.func_73734_a((int)this.area.x, (int)this.area.y, (int)this.area.ex(), (int)this.area.ey(), (int)0x33000000);
        }
        if (this.isEditMode()) {
            this.refreshImmersive();
        }
        super.draw(context);
    }

    protected void beforeRenderModel(GuiContext context) {
        super.beforeRenderModel(context);
        if (this.isImmersionMode() && this.beforeRender != null) {
            this.beforeRender.accept(context);
        }
    }

    protected void afterRenderModel(GuiContext context) {
        super.afterRenderModel(context);
        if (this.isImmersionMode() && this.afterRender != null) {
            this.afterRender.accept(context);
        }
    }

    public Frame getFrame(int tick) {
        if (this.frameProvider != null && !this.isNested()) {
            return this.frameProvider.apply(tick);
        }
        return null;
    }

    @SubscribeEvent
    public void onRenderTick(TickEvent.RenderTickEvent event) {
        if (this.isEditMode() && this.immersionMode && event.phase == TickEvent.Phase.START) {
            this.preview.renderComplete = false;
            if (this.updateCallback != null) {
                this.updateCallback.accept(this);
            }
        }
        if (this.isImmersionMode()) {
            if (event.phase == TickEvent.Phase.START) {
                this.lastMorph = EntityUtils.getMorph((EntityLivingBase)this.target);
                if (this.target instanceof EntityActor) {
                    ((EntityActor)this.target).morph.setDirect((AbstractMorph)this.preview);
                } else if (this.target instanceof EntityPlayer) {
                    MorphAPI.morph((EntityPlayer)((EntityPlayer)this.target), (AbstractMorph)this.preview, (boolean)true);
                }
                GuiModelRenderer renderer = ((GuiAbstractMorph)this.editor.delegate).renderer;
                Vector3f temp = new Vector3f(renderer.pos);
                Vector3f vec = new Vector3f();
                vec.set(0.0f, 0.0f, (renderer.flight ? 0.0f : -renderer.scale) - 0.05f);
                renderer.pitch = MathUtils.clamp((float)renderer.pitch, (float)-90.0f, (float)90.0f);
                Matrix4f mat = new Matrix4f();
                mat.rotX(renderer.pitch / 180.0f * (float)Math.PI);
                mat.transform(vec);
                mat.rotY((180.0f - renderer.yaw) / 180.0f * (float)Math.PI);
                mat.transform(vec);
                temp.x += vec.x;
                temp.y += vec.y;
                temp.z += vec.z;
                mat.rotY(-this.target.field_70177_z / 180.0f * (float)Math.PI);
                mat.transform(temp);
                temp.x = (float)((double)temp.x + this.target.field_70165_t);
                temp.y = (float)((double)temp.y + this.target.field_70163_u);
                temp.z = (float)((double)temp.z + this.target.field_70161_v);
                EntityPlayerSP camera = this.mc.field_71439_g;
                camera.func_70080_a((double)temp.x, Math.max((double)(temp.y - camera.func_70047_e()), -64.0), (double)temp.z, renderer.yaw + this.target.field_70177_z + 180.0f, renderer.pitch);
                camera.func_70012_b((double)temp.x, Math.max((double)(temp.y - camera.func_70047_e()), -64.0), (double)temp.z, renderer.yaw + this.target.field_70177_z + 180.0f, renderer.pitch);
                camera.field_70179_y = 0.0;
                camera.field_70181_x = 0.0;
                camera.field_70159_w = 0.0;
            } else if (this.target instanceof EntityActor) {
                ((EntityActor)this.target).morph.setDirect(this.lastMorph);
            } else if (this.target instanceof EntityPlayer) {
                MorphAPI.morph((EntityPlayer)((EntityPlayer)this.target), (AbstractMorph)this.lastMorph, (boolean)true);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onFovModifierEvent(EntityViewRenderEvent.FOVModifier event) {
        if (this.isImmersionMode()) {
            event.setFOV(((GuiAbstractMorph)this.editor.delegate).renderer.fov);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onCameraOrient(EntityViewRenderEvent.CameraSetup event) {
        if (this.isImmersionMode()) {
            event.setRoll(0.0f);
        }
    }

    @SubscribeEvent
    public void onRenderGameOverlayEvent(RenderGameOverlayEvent event) {
        event.setCanceled(true);
    }

    public void refreshImmersive() {
        GuiModelRenderer renderer = ((GuiAbstractMorph)this.editor.delegate).renderer;
        renderer.hideModel = this.isImmersionMode() && this.preview.renderComplete && this.hideGuiModel && (!this.doRenderOnionSkin || !this.haveOnionSkin());
        renderer.customEntity = this.isImmersionMode();
        renderer.fullScreen = this.isImmersionMode();
        if (renderer.customEntity) {
            renderer.entityPitch = this.target.field_70125_A;
            renderer.entityYawHead = this.target.field_70759_as - this.target.field_70177_z;
            renderer.entityYawBody = this.target.field_70761_aq - this.target.field_70177_z;
            renderer.entityTicksExisted = this.target.field_70173_aa;
        }
    }

    public boolean isImmersionMode() {
        return this.isEditMode() && this.immersionMode && this.target != null;
    }

    public class PreviewMorph
    extends AbstractMorph {
        public boolean renderComplete;

        public void renderOnScreen(EntityPlayer player, int x, int y, float scale, float alpha) {
        }

        public void render(EntityLivingBase entity, double x, double y, double z, float entityYaw, float partialTicks) {
            this.renderComplete = true;
            GuiImmersiveMorphMenu menu = GuiImmersiveMorphMenu.this;
            AbstractMorph morph = ((GuiAbstractMorph)menu.editor.delegate).morph;
            GuiModelRenderer renderer = ((GuiAbstractMorph)menu.editor.delegate).renderer;
            if (renderer instanceof GuiSequencerMorph.GuiSequencerMorphRenderer) {
                GuiContext context = GuiBase.getCurrent();
                context.partialTicks = GuiImmersiveMorphMenu.this.mc.func_184121_ak();
                ((GuiSequencerMorph.GuiSequencerMorphRenderer)renderer).doRender(GuiBase.getCurrent(), entity, x, y, z);
                morph = null;
            } else if (renderer instanceof GuiMorphRenderer) {
                morph = ((GuiMorphRenderer)renderer).morph;
            }
            if (morph != null) {
                MorphUtils.render((AbstractMorph)morph, (EntityLivingBase)entity, (double)x, (double)y, (double)z, (float)entityYaw, (float)partialTicks);
            }
        }

        public AbstractMorph create() {
            return null;
        }

        public float getWidth(EntityLivingBase target) {
            return 0.0f;
        }

        public float getHeight(EntityLivingBase target) {
            return 0.0f;
        }
    }
}

