/*
 * Decompiled with CFR 0.152.
 */
package mchorse.blockbuster.client.gui.dashboard.panels.model_editor.tabs;

import javax.vecmath.Matrix4d;
import javax.vecmath.Matrix4f;
import javax.vecmath.Vector3f;
import mchorse.blockbuster.api.Model;
import mchorse.blockbuster.api.ModelLimb;
import mchorse.blockbuster.api.ModelTransform;
import mchorse.blockbuster.client.gui.dashboard.panels.model_editor.GuiModelEditorPanel;
import mchorse.blockbuster.client.gui.dashboard.panels.model_editor.tabs.GuiAnchorModal;
import mchorse.blockbuster.client.gui.dashboard.panels.model_editor.tabs.GuiModelEditorTab;
import mchorse.blockbuster.client.gui.dashboard.panels.model_editor.utils.GuiTextureCanvas;
import mchorse.blockbuster.client.gui.dashboard.panels.model_editor.utils.GuiThreeElement;
import mchorse.blockbuster.client.model.ModelCustomRenderer;
import mchorse.blockbuster.client.model.ModelOBJRenderer;
import mchorse.blockbuster.client.model.ModelVoxRenderer;
import mchorse.mclib.client.gui.framework.elements.GuiElement;
import mchorse.mclib.client.gui.framework.elements.GuiScrollElement;
import mchorse.mclib.client.gui.framework.elements.IGuiElement;
import mchorse.mclib.client.gui.framework.elements.buttons.GuiButtonElement;
import mchorse.mclib.client.gui.framework.elements.buttons.GuiCirculateElement;
import mchorse.mclib.client.gui.framework.elements.buttons.GuiIconElement;
import mchorse.mclib.client.gui.framework.elements.buttons.GuiToggleElement;
import mchorse.mclib.client.gui.framework.elements.context.GuiSimpleContextMenu;
import mchorse.mclib.client.gui.framework.elements.input.GuiColorElement;
import mchorse.mclib.client.gui.framework.elements.input.GuiTrackpadElement;
import mchorse.mclib.client.gui.framework.elements.list.GuiStringListElement;
import mchorse.mclib.client.gui.framework.elements.modals.GuiListModal;
import mchorse.mclib.client.gui.framework.elements.modals.GuiMessageModal;
import mchorse.mclib.client.gui.framework.elements.modals.GuiModal;
import mchorse.mclib.client.gui.framework.elements.modals.GuiPromptModal;
import mchorse.mclib.client.gui.utils.Elements;
import mchorse.mclib.client.gui.utils.Icons;
import mchorse.mclib.client.gui.utils.keys.IKey;
import mchorse.mclib.client.gui.utils.resizers.IResizer;
import mchorse.mclib.utils.Color;
import mchorse.mclib.utils.Interpolations;
import mchorse.mclib.utils.MatrixUtils;
import net.minecraft.client.Minecraft;

public class GuiModelLimbs
extends GuiModelEditorTab {
    private GuiIconElement addLimb;
    private GuiIconElement dupeLimb;
    private GuiIconElement removeLimb;
    private GuiIconElement renameLimb;
    private GuiIconElement parentLimb;
    private GuiStringListElement limbs;
    private GuiScrollElement scroll;
    private GuiThreeElement size;
    private GuiTrackpadElement sizeOffset;
    private GuiTrackpadElement itemScale;
    private GuiButtonElement texture;
    private GuiThreeElement anchor;
    private GuiThreeElement origin;
    private GuiTextureCanvas textureEditor;
    private GuiToggleElement mirror;
    private GuiToggleElement lighting;
    private GuiToggleElement shading;
    private GuiToggleElement smooth;
    private GuiToggleElement is3D;
    private GuiElement colors;
    private GuiColorElement color;
    private GuiColorElement specular;
    private GuiCirculateElement holding;
    private GuiCirculateElement slot;
    private GuiToggleElement hold;
    private GuiToggleElement swiping;
    private GuiToggleElement lookX;
    private GuiToggleElement lookY;
    private GuiToggleElement swinging;
    private GuiToggleElement idle;
    private GuiToggleElement invert;
    private GuiToggleElement wheel;
    private GuiToggleElement wing;
    private GuiToggleElement roll;
    private GuiToggleElement cape;
    private GuiElement vanillaPanel;
    private GuiElement objPanel;
    private float lastAnchorX;
    private float lastAnchorY;
    private float lastAnchorZ;

    public GuiModelLimbs(Minecraft mc, GuiModelEditorPanel panel) {
        super(mc, panel);
        this.title = IKey.lang((String)"blockbuster.gui.me.limbs.title");
        this.limbs = new GuiStringListElement(mc, str -> this.setLimb((String)str.get(0)));
        this.limbs.background().flex().relative((GuiElement)this).y(20).w(1.0f).h(100);
        this.scroll = new GuiScrollElement(mc);
        this.scroll.scroll.scrollSpeed = 15;
        this.scroll.flex().relative((GuiElement)this.limbs).y(1.0f).w(1.0f).hTo((IResizer)this.area, 1.0f).column(5).vertical().stretch().scroll().height(20).padding(10);
        this.textureEditor = new GuiTextureCanvas(mc, this);
        this.textureEditor.flex().relative((GuiElement)this.limbs).y(1.0f).w(1.0f).hTo((IResizer)this.area, 1.0f);
        this.size = new GuiThreeElement(mc, values -> {
            this.panel.limb.size[0] = values[0].intValue();
            this.panel.limb.size[1] = values[1].intValue();
            this.panel.limb.size[2] = values[2].intValue();
            this.panel.rebuildModel();
        });
        this.size.setLimit(0, 8192, true);
        this.sizeOffset = new GuiTrackpadElement(mc, value -> {
            this.panel.limb.sizeOffset = value.floatValue();
            this.panel.rebuildModel();
        });
        this.itemScale = new GuiTrackpadElement(mc, value -> {
            this.panel.limb.itemScale = value.floatValue();
            this.panel.dirty();
        });
        this.texture = new GuiButtonElement(mc, IKey.comp((IKey[])new IKey[]{IKey.lang((String)"blockbuster.gui.edit"), IKey.str((String)"...")}), b -> {
            this.textureEditor.toggleVisible();
            this.textureEditor.setSize(this.panel.model.texture[0], this.panel.model.texture[1]);
        });
        this.anchor = new GuiThreeElement(mc, values -> {
            if (this.is3D.isVisible()) {
                this.fixLimbPosition(values[0].floatValue(), values[1].floatValue(), values[2].floatValue());
                this.lastAnchorX = this.panel.limb.anchor[0] = values[0].floatValue();
                this.lastAnchorY = this.panel.limb.anchor[1] = values[1].floatValue();
                this.lastAnchorZ = this.panel.limb.anchor[2] = values[2].floatValue();
            } else {
                this.panel.limb.anchor[0] = values[0].floatValue();
                this.panel.limb.anchor[1] = values[1].floatValue();
                this.panel.limb.anchor[2] = values[2].floatValue();
            }
            this.panel.rebuildModel();
        });
        this.origin = new GuiThreeElement(mc, values -> {
            this.fixLimbPosition(values[0].floatValue(), values[1].floatValue(), values[2].floatValue());
            this.lastAnchorX = this.panel.limb.origin[0] = values[0].floatValue();
            this.lastAnchorY = this.panel.limb.origin[1] = values[1].floatValue();
            this.lastAnchorZ = this.panel.limb.origin[2] = values[2].floatValue();
            this.panel.rebuildModel();
        });
        this.origin.context(() -> {
            ModelCustomRenderer renderer = this.panel.renderModel.get(this.panel.limb.name);
            if (renderer != null && renderer.min != null && renderer.max != null) {
                return new GuiSimpleContextMenu(this.mc).action(Icons.FULLSCREEN, IKey.lang((String)"blockbuster.gui.me.limbs.context.anchor_setup"), () -> this.setupAnchorPoint(renderer, false)).action(Icons.DOWNLOAD, IKey.lang((String)"blockbuster.gui.me.limbs.context.anchor_move"), () -> this.setupAnchorPoint(renderer, true));
            }
            return null;
        });
        this.slot = new GuiCirculateElement(mc, b -> {
            this.panel.limb.slot = ModelLimb.ArmorSlot.values()[this.slot.getValue()];
            this.panel.dirty();
        });
        this.slot.tooltip(IKey.lang((String)"blockbuster.gui.me.limbs.slot"));
        this.hold = new GuiToggleElement(mc, IKey.lang((String)"blockbuster.gui.me.limbs.holding"), false, b -> {
            this.panel.limb.hold = b.isToggled();
            this.panel.dirty();
        });
        for (ModelLimb.ArmorSlot slot : ModelLimb.ArmorSlot.values()) {
            this.slot.addLabel(IKey.lang((String)("blockbuster.gui.me.limbs.slots." + slot.name)));
        }
        this.color = new GuiColorElement(mc, eh -> {
            Color color = this.color.picker.color;
            this.panel.limb.color[0] = color.r;
            this.panel.limb.color[1] = color.g;
            this.panel.limb.color[2] = color.b;
            this.panel.limb.opacity = color.a;
            this.panel.dirty();
        });
        this.color.picker.editAlpha();
        this.color.tooltip(IKey.lang((String)"blockbuster.gui.me.limbs.color"));
        this.specular = new GuiColorElement(mc, eh -> {
            Color color = this.specular.picker.color;
            this.panel.limb.specular = color.getRGBAColor();
            this.panel.dirty();
        });
        this.specular.picker.editAlpha();
        this.specular.tooltip(IKey.lang((String)"blockbuster.gui.me.limbs.specular"));
        this.mirror = new GuiToggleElement(mc, IKey.lang((String)"blockbuster.gui.me.limbs.mirror"), false, b -> {
            this.panel.limb.mirror = b.isToggled();
            this.panel.rebuildModel();
        });
        this.mirror.flex().h(20);
        this.lighting = new GuiToggleElement(mc, IKey.lang((String)"blockbuster.gui.me.limbs.lighting"), false, b -> {
            this.panel.limb.lighting = b.isToggled();
            this.panel.dirty();
        });
        this.shading = new GuiToggleElement(mc, IKey.lang((String)"blockbuster.gui.me.limbs.shading"), false, b -> {
            this.panel.limb.shading = b.isToggled();
            this.panel.dirty();
        });
        this.smooth = new GuiToggleElement(mc, IKey.lang((String)"blockbuster.gui.me.limbs.smooth"), false, b -> {
            this.panel.limb.smooth = b.isToggled();
            this.panel.dirty();
        });
        this.is3D = new GuiToggleElement(mc, IKey.str((String)"3D"), false, b -> {
            this.panel.limb.is3D = b.isToggled();
            this.panel.dirty();
        });
        this.holding = new GuiCirculateElement(mc, b -> {
            this.panel.limb.holding = ModelLimb.Holding.values()[this.holding.getValue()];
            this.panel.rebuildModel();
        });
        this.holding.tooltip(IKey.lang((String)"blockbuster.gui.me.limbs.hold"));
        this.holding.addLabel(IKey.lang((String)"blockbuster.gui.me.limbs.none"));
        this.holding.addLabel(IKey.lang((String)"blockbuster.gui.me.limbs.right"));
        this.holding.addLabel(IKey.lang((String)"blockbuster.gui.me.limbs.left"));
        this.swiping = new GuiToggleElement(mc, IKey.lang((String)"blockbuster.gui.me.limbs.swiping"), false, b -> {
            this.panel.limb.swiping = b.isToggled();
            this.panel.dirty();
        });
        this.lookX = new GuiToggleElement(mc, IKey.comp((IKey[])new IKey[]{IKey.lang((String)"blockbuster.gui.me.limbs.looking"), IKey.str((String)" X")}), false, b -> {
            this.panel.limb.lookX = b.isToggled();
            this.panel.dirty();
        });
        this.lookY = new GuiToggleElement(mc, IKey.comp((IKey[])new IKey[]{IKey.lang((String)"blockbuster.gui.me.limbs.looking"), IKey.str((String)" Y")}), false, b -> {
            this.panel.limb.lookY = b.isToggled();
            this.panel.dirty();
        });
        this.swinging = new GuiToggleElement(mc, IKey.lang((String)"blockbuster.gui.me.limbs.swinging"), false, b -> {
            this.panel.limb.swinging = b.isToggled();
            this.panel.dirty();
        });
        this.idle = new GuiToggleElement(mc, IKey.lang((String)"blockbuster.gui.me.limbs.idle"), false, b -> {
            this.panel.limb.idle = b.isToggled();
            this.panel.dirty();
        });
        this.invert = new GuiToggleElement(mc, IKey.lang((String)"blockbuster.gui.me.limbs.invert"), false, b -> {
            this.panel.limb.invert = b.isToggled();
            this.panel.dirty();
        });
        this.wheel = new GuiToggleElement(mc, IKey.lang((String)"blockbuster.gui.me.limbs.wheel"), false, b -> {
            this.panel.limb.wheel = b.isToggled();
            this.panel.dirty();
        });
        this.wing = new GuiToggleElement(mc, IKey.lang((String)"blockbuster.gui.me.limbs.wing"), false, b -> {
            this.panel.limb.wing = b.isToggled();
            this.panel.dirty();
        });
        this.roll = new GuiToggleElement(mc, IKey.lang((String)"blockbuster.gui.me.limbs.roll"), false, b -> {
            this.panel.limb.roll = b.isToggled();
            this.panel.dirty();
        });
        this.cape = new GuiToggleElement(mc, IKey.lang((String)"blockbuster.gui.me.limbs.cape"), false, b -> {
            this.panel.limb.cape = b.isToggled();
            this.panel.dirty();
        });
        this.vanillaPanel = Elements.column((Minecraft)mc, (int)5, (GuiElement[])new GuiElement[0]);
        this.vanillaPanel.add(new IGuiElement[]{Elements.label((IKey)IKey.lang((String)"blockbuster.gui.me.limbs.size")).background(), this.size});
        this.vanillaPanel.add(new IGuiElement[]{Elements.label((IKey)IKey.lang((String)"blockbuster.gui.me.limbs.size_offset")).background(), this.sizeOffset});
        this.vanillaPanel.add(new IGuiElement[]{Elements.label((IKey)IKey.lang((String)"blockbuster.gui.me.limbs.texture")).background().marginTop(12), Elements.row((Minecraft)mc, (int)5, (int)0, (int)20, (GuiElement[])new GuiElement[]{this.texture, this.mirror})});
        this.objPanel = Elements.column((Minecraft)mc, (int)5, (GuiElement[])new GuiElement[0]);
        this.objPanel.add(new IGuiElement[]{Elements.label((IKey)IKey.lang((String)"blockbuster.gui.me.limbs.origin")).background(), this.origin});
        GuiElement appearance = new GuiElement(mc);
        appearance.flex().grid(5).items(2).resizes(true);
        appearance.add(new IGuiElement[]{this.lighting, this.shading});
        appearance.add(new IGuiElement[]{this.smooth, this.is3D});
        this.colors = new GuiElement(mc);
        this.colors.flex().grid(5).items(1).resizes(true);
        this.colors.add((IGuiElement)this.color);
        GuiElement animation = new GuiElement(mc);
        animation.flex().grid(5).items(2).resizes(true);
        animation.add(new IGuiElement[]{this.lookX, this.lookY});
        animation.add(new IGuiElement[]{this.idle, this.swinging});
        animation.add(new IGuiElement[]{this.invert, this.swiping});
        animation.add(new IGuiElement[]{this.hold, this.wheel});
        animation.add(new IGuiElement[]{this.wing, this.roll});
        animation.add((IGuiElement)this.cape);
        this.scroll.add(new IGuiElement[]{Elements.label((IKey)IKey.lang((String)"blockbuster.gui.me.limbs.anchor")).background().marginTop(12), this.anchor});
        this.scroll.add((IGuiElement)Elements.row((Minecraft)mc, (int)5, (GuiElement[])new GuiElement[]{this.slot, this.holding}));
        this.scroll.add(new IGuiElement[]{Elements.label((IKey)IKey.lang((String)"blockbuster.gui.me.limbs.item_scale")).background(), this.itemScale});
        this.scroll.add(new IGuiElement[]{Elements.label((IKey)IKey.lang((String)"blockbuster.gui.me.limbs.appearance")).background().marginTop(12), appearance, this.colors});
        this.scroll.add(new IGuiElement[]{Elements.label((IKey)IKey.lang((String)"blockbuster.gui.me.limbs.animation")).background().marginTop(12), animation});
        this.addLimb = new GuiIconElement(mc, Icons.ADD, b -> this.addLimb());
        this.dupeLimb = new GuiIconElement(mc, Icons.DUPE, b -> this.dupeLimb());
        this.removeLimb = new GuiIconElement(mc, Icons.REMOVE, b -> this.removeLimb());
        this.renameLimb = new GuiIconElement(mc, Icons.EDIT, b -> this.renameLimb());
        this.parentLimb = new GuiIconElement(mc, Icons.LIMB, b -> this.parentLimb());
        GuiElement sidebar = Elements.row((Minecraft)mc, (int)0, (int)0, (int)20, (GuiElement[])new GuiElement[]{this.addLimb, this.dupeLimb, this.parentLimb, this.renameLimb, this.removeLimb});
        sidebar.flex().relative((GuiElement)this).x(1.0f).h(20).anchorX(1.0f).row(0).resize();
        this.add(new IGuiElement[]{sidebar, this.limbs, this.scroll, this.textureEditor});
    }

    private void setupAnchorPoint(ModelCustomRenderer renderer, boolean move) {
        GuiAnchorModal modal;
        this.panel.modelRenderer.anchorPreview = modal = new GuiAnchorModal(this.mc, IKey.lang((String)"blockbuster.gui.me.limbs.anchor_modal"), anchor -> this.doSetupAnchorPoint(renderer, (Vector3f)anchor, move));
        GuiModal.addFullModal((GuiElement)this, () -> modal);
    }

    private void doSetupAnchorPoint(ModelCustomRenderer renderer, Vector3f anchor, boolean move) {
        renderer.limb.origin[0] = Interpolations.lerp((float)renderer.min.x, (float)renderer.max.x, (float)anchor.x);
        renderer.limb.origin[1] = Interpolations.lerp((float)renderer.min.y, (float)renderer.max.y, (float)anchor.y);
        renderer.limb.origin[2] = Interpolations.lerp((float)renderer.min.z, (float)renderer.max.z, (float)anchor.z);
        if (move) {
            float[] translate = this.panel.pose.limbs.get((Object)renderer.limb.name).translate;
            translate[0] = -renderer.limb.origin[0] * 16.0f;
            translate[1] = renderer.limb.origin[1] * 16.0f;
            translate[2] = -renderer.limb.origin[2] * 16.0f;
        }
        this.panel.modelRenderer.anchorPreview = null;
        this.panel.setLimb(renderer.limb.name);
        this.panel.rebuildModel();
    }

    private void addLimb() {
        GuiModal.addFullModal((GuiElement)this, () -> {
            GuiPromptModal modal = new GuiPromptModal(this.mc, IKey.lang((String)"blockbuster.gui.me.limbs.new_limb"), this::addLimb);
            return modal.setValue(this.panel.limb.name);
        });
    }

    private void addLimb(String text) {
        if (!this.panel.model.limbs.containsKey(text)) {
            this.panel.model.addLimb(text);
            this.limbs.add((Object)text);
            this.limbs.setCurrent((Object)text);
            this.panel.rebuildModel();
            this.panel.setLimb(text);
        }
    }

    private void dupeLimb() {
        if (this.getLimbClass(this.panel.limb) != ModelCustomRenderer.class) {
            GuiModal.addFullModal((GuiElement)this, () -> new GuiMessageModal(this.mc, IKey.lang((String)"blockbuster.gui.me.limbs.obj_limb")));
            return;
        }
        ModelLimb limb = this.panel.limb.clone();
        while (this.panel.model.limbs.containsKey(limb.name)) {
            limb.name = limb.name + "_copy";
        }
        this.panel.model.addLimb(limb);
        this.limbs.add((Object)limb.name);
        this.limbs.setCurrent((Object)limb.name);
        this.panel.rebuildModel();
        this.panel.setLimb(limb.name);
    }

    private void removeLimb() {
        int size = this.panel.model.limbs.size();
        if (this.getLimbClass(this.panel.limb) != ModelCustomRenderer.class) {
            GuiModal.addFullModal((GuiElement)this, () -> new GuiMessageModal(this.mc, IKey.lang((String)"blockbuster.gui.me.limbs.obj_limb")));
        } else if (size == this.panel.model.getLimbCount(this.panel.limb)) {
            GuiModal.addFullModal((GuiElement)this, () -> new GuiMessageModal(this.mc, IKey.lang((String)"blockbuster.gui.me.limbs.last_limb")));
        } else {
            this.panel.model.removeLimb(this.panel.limb);
            String newLimb = this.panel.model.limbs.keySet().iterator().next();
            this.fillData(this.panel.model);
            this.panel.rebuildModel();
            this.panel.setLimb(newLimb);
        }
    }

    private void renameLimb() {
        if (this.getLimbClass(this.panel.limb) != ModelCustomRenderer.class) {
            GuiModal.addFullModal((GuiElement)this, () -> new GuiMessageModal(this.mc, IKey.lang((String)"blockbuster.gui.me.limbs.obj_limb")));
        } else {
            GuiModal.addFullModal((GuiElement)this, () -> new GuiPromptModal(this.mc, IKey.lang((String)"blockbuster.gui.me.limbs.rename_limb"), this::renameLimb).setValue(this.panel.limb.name));
        }
    }

    private void renameLimb(String text) {
        if (this.panel.model.renameLimb(this.panel.limb, text)) {
            this.limbs.replace((Object)text);
            this.panel.rebuildModel();
        }
    }

    private void parentLimb() {
        GuiModal.addFullModal((GuiElement)this, () -> {
            GuiToggleElement button = new GuiToggleElement(this.mc, IKey.lang((String)"blockbuster.gui.me.limbs.parent_limb_transform_correction"), true, null);
            button.tooltip(IKey.lang((String)"blockbuster.gui.me.limbs.parent_limb_transform_correction_tooltip"));
            GuiListModal modal = new GuiListModal(this.mc, IKey.lang((String)"blockbuster.gui.me.limbs.parent_limb"), text -> this.parentLimb((String)text, button.isToggled()));
            button.flex().relative(modal.bar).x(10).w(1.0f, -20).y(-0.25f, -5);
            modal.add((IGuiElement)button);
            return modal.addValues(this.panel.model.limbs.keySet()).setValue(this.panel.limb.parent);
        });
    }

    private void parentLimb(String text) {
        this.parentLimb(text, false);
    }

    private void correctTransformationParenting(String newParent) {
        ModelCustomRenderer currentLimbRenderer = null;
        ModelCustomRenderer newParentRenderer = null;
        for (ModelCustomRenderer limbRenderer : this.panel.renderModel.limbs) {
            if (limbRenderer.limb == this.panel.limb) {
                currentLimbRenderer = limbRenderer;
                continue;
            }
            if (!limbRenderer.limb.name.equals(newParent)) continue;
            newParentRenderer = limbRenderer;
        }
        if (currentLimbRenderer == null) {
            return;
        }
        Matrix4d diff = new Matrix4d();
        diff.setIdentity();
        if (newParentRenderer != null) {
            diff = newParentRenderer.getWorldTransformation();
            diff.invert();
            diff.mul(currentLimbRenderer.getWorldTransformation());
        } else {
            diff = this.panel.modelRenderer.getModelMatrix();
            diff.invert();
            diff.mul(currentLimbRenderer.getModelView());
            diff.m13 -= 1.5;
        }
        MatrixUtils.Transformation correction = MatrixUtils.getTransformation((Matrix4d)diff);
        correction.rotation.transpose();
        Vector3f trans = correction.getTranslation3f();
        Vector3f rot = correction.getRotation(MatrixUtils.RotationOrder.XYZ);
        Vector3f scale = correction.getScale();
        trans.scale(16.0f);
        ModelTransform transform = currentLimbRenderer.model.pose.limbs.get(this.panel.limb.name);
        if (transform != null) {
            transform.translate = new float[]{trans.x, -trans.y, -trans.z};
            transform.rotate = new float[]{rot.x, -rot.y, -rot.z};
            transform.scale = new float[]{scale.x, scale.y, scale.z};
        }
    }

    private void parentLimb(String text, boolean correctTransformation) {
        if (!this.panel.limb.name.equals(text)) {
            this.panel.limb.parent = text;
            if (correctTransformation) {
                this.correctTransformationParenting(text);
            }
            this.panel.rebuildModel();
        }
    }

    private void setLimb(String str) {
        this.panel.setLimb(str);
        this.fillLimbData(this.panel.limb);
    }

    public void setCurrent(String str) {
        this.limbs.setCurrent((Object)str);
        this.fillLimbData(this.panel.limb);
    }

    public void fillData(Model model) {
        this.limbs.clear();
        this.limbs.add(model.limbs.keySet());
        this.limbs.sort();
        this.textureEditor.setVisible(false);
    }

    public void fillLimbData(ModelLimb limb) {
        this.textureEditor.x.setValue((double)this.panel.limb.texture[0]);
        this.textureEditor.y.setValue((double)this.panel.limb.texture[1]);
        this.size.setValues(limb.size[0], limb.size[1], limb.size[2]);
        this.sizeOffset.setValue((double)limb.sizeOffset);
        this.itemScale.setValue((double)limb.itemScale);
        this.anchor.setValues(limb.anchor[0], limb.anchor[1], limb.anchor[2]);
        this.origin.setValues(limb.origin[0], limb.origin[1], limb.origin[2]);
        this.color.picker.setColor(limb.color[0], limb.color[1], limb.color[2], limb.opacity);
        this.mirror.toggled(limb.mirror);
        this.lighting.toggled(limb.lighting);
        this.shading.toggled(limb.shading);
        this.smooth.toggled(limb.smooth);
        this.is3D.toggled(limb.is3D);
        this.holding.setValue(limb.holding.ordinal());
        this.slot.setValue(limb.slot.ordinal());
        this.hold.toggled(limb.hold);
        this.swiping.toggled(limb.swiping);
        this.lookX.toggled(limb.lookX);
        this.lookY.toggled(limb.lookY);
        this.swinging.toggled(limb.swinging);
        this.idle.toggled(limb.idle);
        this.invert.toggled(limb.invert);
        this.wheel.toggled(limb.wheel);
        this.wing.toggled(limb.wing);
        this.roll.toggled(limb.roll);
        this.cape.toggled(limb.cape);
        boolean isObj = this.getLimbClass(limb) != ModelCustomRenderer.class;
        boolean isVOX = this.getLimbClass(limb) == ModelVoxRenderer.class;
        this.vanillaPanel.removeFromParent();
        this.objPanel.removeFromParent();
        this.is3D.setVisible(!isObj);
        if (isObj) {
            this.lastAnchorX = limb.origin[0];
            this.lastAnchorY = limb.origin[1];
            this.lastAnchorZ = limb.origin[2];
            this.scroll.prepend((IGuiElement)this.objPanel);
        } else {
            this.lastAnchorX = limb.anchor[0];
            this.lastAnchorY = limb.anchor[1];
            this.lastAnchorZ = limb.anchor[2];
            this.scroll.prepend((IGuiElement)this.vanillaPanel);
        }
        if (isVOX) {
            if (!this.specular.hasParent()) {
                this.colors.flex().grid(5).items(2).resizes(true);
                this.colors.add((IGuiElement)this.specular);
            }
            this.specular.picker.setColor(limb.specular);
        } else {
            this.specular.removeFromParent();
            this.colors.flex().grid(5).items(1).resizes(true);
        }
        this.scroll.resize();
    }

    private void fixLimbPosition(float x, float y, float z) {
        Model model = this.panel.model;
        ModelLimb limb = this.panel.limb;
        ModelTransform transform = this.panel.transform;
        Class<? extends ModelCustomRenderer> clazz = this.getLimbClass(limb);
        Matrix4f mat = new Matrix4f();
        mat.setIdentity();
        mat.m03 = transform.translate[0];
        mat.m13 = transform.translate[1];
        mat.m23 = transform.translate[2];
        Matrix4f mat2 = new Matrix4f();
        mat2.rotZ((float)Math.toRadians(transform.rotate[2]));
        mat.mul(mat2);
        mat2.rotY((float)Math.toRadians(transform.rotate[1]));
        mat.mul(mat2);
        mat2.rotX((float)Math.toRadians(transform.rotate[0]));
        mat.mul(mat2);
        mat2.setIdentity();
        mat2.m00 = transform.scale[0];
        mat2.m11 = transform.scale[1];
        mat2.m22 = transform.scale[2];
        mat.mul(mat2);
        if (clazz != ModelCustomRenderer.class) {
            if (clazz == ModelOBJRenderer.class) {
                mat2.setIdentity();
                mat2.m00 = model.legacyObj || this.getLimbClass(this.panel.limb) == ModelVoxRenderer.class ? 16.0f : -16.0f;
                mat2.m11 = 16.0f;
                mat2.m22 = 16.0f;
                mat.mul(mat2);
            }
            mat2.setIdentity();
            mat2.m03 = x - this.lastAnchorX;
            mat2.m13 = y - this.lastAnchorY;
            mat2.m23 = this.lastAnchorZ - z;
            mat.mul(mat2);
        } else {
            mat2.setIdentity();
            mat2.m00 = limb.size[0];
            mat2.m11 = limb.size[1];
            mat2.m22 = limb.size[2];
            mat.mul(mat2);
            mat2.setIdentity();
            mat2.m03 = this.lastAnchorX - x;
            mat2.m13 = this.lastAnchorY - y;
            mat2.m23 = this.lastAnchorZ - z;
            mat.mul(mat2);
        }
        transform.translate[0] = mat.m03;
        transform.translate[1] = mat.m13;
        transform.translate[2] = mat.m23;
    }

    private Class<? extends ModelCustomRenderer> getLimbClass(ModelLimb limb) {
        for (ModelCustomRenderer limbRenderer : this.panel.renderModel.limbs) {
            if (!limbRenderer.limb.name.equals(limb.name)) continue;
            return ((Object)((Object)limbRenderer)).getClass();
        }
        return null;
    }
}

