/*
 * Decompiled with CFR 0.152.
 */
package mchorse.blockbuster.client.gui.dashboard.panels.model_editor.utils;

import java.util.List;
import java.util.Map;
import javax.vecmath.Matrix4d;
import javax.vecmath.Vector3d;
import mchorse.blockbuster.api.ModelLimb;
import mchorse.blockbuster.api.ModelPose;
import mchorse.blockbuster.api.formats.obj.ShapeKey;
import mchorse.blockbuster.client.gui.dashboard.panels.model_editor.tabs.GuiAnchorModal;
import mchorse.blockbuster.client.model.ModelCustom;
import mchorse.blockbuster.client.model.ModelCustomRenderer;
import mchorse.blockbuster.client.render.RenderCustomModel;
import mchorse.blockbuster.client.render.layer.LayerHeldItem;
import mchorse.mclib.client.Draw;
import mchorse.mclib.client.gui.framework.elements.GuiModelRenderer;
import mchorse.mclib.client.gui.framework.elements.input.GuiTransformations;
import mchorse.mclib.client.gui.framework.elements.utils.GuiContext;
import mchorse.mclib.utils.DummyEntity;
import mchorse.mclib.utils.Interpolations;
import mchorse.mclib.utils.MatrixUtils;
import mchorse.mclib.utils.RenderingUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderGlobal;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHandSide;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import org.lwjgl.opengl.GL11;

public class GuiBBModelRenderer
extends GuiModelRenderer {
    public boolean swinging;
    private float swing;
    private float swingAmount;
    private int swipe;
    public boolean items;
    public boolean aabb;
    public boolean origin;
    public boolean looking = true;
    public Map<String, ResourceLocation> materials;
    public ResourceLocation texture;
    public ModelCustom model;
    public ModelLimb limb;
    public GuiAnchorModal anchorPreview;
    private ModelPose pose;
    private List<ShapeKey> shapes;
    private Matrix4d modelMatrix;

    public Matrix4d getModelMatrix() {
        return new Matrix4d(this.modelMatrix);
    }

    public static void renderItems(EntityLivingBase entity, ModelCustom model) {
        ItemStack main = entity.func_184614_ca();
        ItemStack offhand = entity.func_184592_cb();
        if (!offhand.func_190926_b() || !main.func_190926_b()) {
            GlStateManager.func_179094_E();
            LayerHeldItem.renderHeldItem(entity, offhand, model, ItemCameraTransforms.TransformType.THIRD_PERSON_LEFT_HAND, EnumHandSide.LEFT);
            LayerHeldItem.renderHeldItem(entity, main, model, ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND, EnumHandSide.RIGHT);
            GlStateManager.func_179121_F();
        }
    }

    public GuiBBModelRenderer(Minecraft mc) {
        super(mc);
    }

    public void swipe() {
        this.swipe = 6;
    }

    public void toggleItems() {
        this.items = !this.items;
        ((DummyEntity)this.entity).toggleItems(this.items);
    }

    protected void update() {
        super.update();
        if (this.swipe > -1) {
            --this.swipe;
        }
        if (this.swinging) {
            this.swing += 0.75f;
            this.swingAmount = 1.0f;
        } else {
            this.swing = 0.0f;
            this.swingAmount = 0.0f;
        }
    }

    public boolean mouseClicked(GuiContext context) {
        boolean result = super.mouseClicked(context);
        if (this.dragging && GuiScreen.func_146271_m()) {
            this.tryPicking = true;
            this.dragging = false;
        }
        return result;
    }

    public void mouseReleased(GuiContext context) {
        super.mouseReleased(context);
        this.tryPicking = false;
    }

    protected float getScale() {
        return 1.0f;
    }

    protected void drawUserModel(GuiContext context) {
        ModelCustomRenderer targetLimb;
        float limbSwing;
        if (this.model == null) {
            return;
        }
        float partial = context.partialTicks;
        float headYaw = this.yaw - (this.customEntity ? this.entityYawBody : 0.0f);
        float headPitch = -this.pitch;
        float factor = 0.0625f;
        float f = limbSwing = this.swinging ? this.swing + partial : 0.0f;
        if (!this.looking) {
            headYaw = this.customEntity ? this.entityYawHead - this.entityYawBody : 0.0f;
            headPitch = this.customEntity ? this.entityPitch : 0.0f;
        }
        this.updateModel(limbSwing, headYaw, headPitch, 0.0625f, partial);
        float scale = this.getScale();
        GlStateManager.func_179094_E();
        GlStateManager.func_179152_a((float)this.model.model.scale[0], (float)this.model.model.scale[1], (float)this.model.model.scale[2]);
        GlStateManager.func_179152_a((float)(-1.0f * scale), (float)(-1.0f * scale), (float)(1.0f * scale));
        GlStateManager.func_179109_b((float)0.0f, (float)-1.501f, (float)0.0f);
        GlStateManager.func_179114_b((float)(180.0f + (this.customEntity ? this.entityYawBody : 0.0f)), (float)0.0f, (float)1.0f, (float)0.0f);
        this.modelMatrix = MatrixUtils.readModelViewDouble();
        if (this.texture != null) {
            RenderCustomModel.bindLastTexture(this.texture);
        }
        this.tryPicking(context);
        this.renderModel(this.entity, headYaw, headPitch, this.customEntity ? this.entityTicksExisted : this.timer, context.mouseX, context.mouseY, partial, 0.0625f);
        if (this.items) {
            GuiBBModelRenderer.renderItems(this.entity, this.model);
        }
        this.updateModel(limbSwing, headYaw, headPitch, 0.0625f, partial);
        GlStateManager.func_179094_E();
        GlStateManager.func_179090_x();
        GlStateManager.func_179097_i();
        GlStateManager.func_179140_f();
        if (this.limb != null && (targetLimb = this.model.get(this.limb.name)) != null) {
            if (this.model.limbs.length > 1) {
                if (((Object)((Object)targetLimb)).getClass() != ModelCustomRenderer.class) {
                    this.renderObjHighlight(targetLimb);
                } else {
                    targetLimb.func_78794_c(0.0625f);
                    this.renderLimbHighlight(this.limb);
                }
            } else if (this.origin) {
                targetLimb.func_78794_c(0.0625f);
                this.drawAxis(targetLimb, 0.25f);
            }
            this.renderAnchorPreview(targetLimb);
        }
        GlStateManager.func_179145_e();
        GlStateManager.func_179126_j();
        GlStateManager.func_179098_w();
        GlStateManager.func_179121_F();
        GlStateManager.func_179121_F();
        if (this.aabb) {
            this.renderAABB();
        }
    }

    protected void drawAxis(ModelCustomRenderer target, float length) {
        GlStateManager.func_179094_E();
        if (GuiTransformations.GuiStaticTransformOrientation.getOrientation() == GuiTransformations.TransformOrientation.GLOBAL) {
            RenderingUtils.glRevertRotationScale((Vector3d)new Vector3d((double)target.field_78795_f, (double)target.field_78796_g, (double)target.field_78808_h), (Vector3d)new Vector3d((double)target.scaleX, (double)target.scaleY, (double)target.scaleZ), (MatrixUtils.RotationOrder)MatrixUtils.RotationOrder.XYZ);
        }
        Draw.axis((float)length);
        GlStateManager.func_179121_F();
    }

    protected void updateModel(float limbSwing, float headYaw, float headPitch, float factor, float partial) {
        this.model.materials = this.materials;
        this.model.shapes = this.shapes;
        this.model.pose = this.pose;
        this.model.field_78095_p = this.swipe == -1 ? 0.0f : MathHelper.func_76131_a((float)(1.0f - ((float)this.swipe - 1.0f * partial) / 6.0f), (float)0.0f, (float)1.0f);
        this.model.func_78086_a(this.entity, headYaw, headPitch, partial);
        this.model.func_78087_a(limbSwing, this.swingAmount, this.customEntity ? (float)this.entityTicksExisted : (float)this.timer, headYaw, headPitch, factor, (Entity)this.entity);
    }

    protected void renderModel(EntityLivingBase dummy, float headYaw, float headPitch, int timer, int yaw, int pitch, float partial, float factor) {
        this.model.func_78088_a((Entity)dummy, headYaw, headPitch, timer, yaw, pitch, factor);
    }

    protected void drawForStencil(GuiContext context) {
        if (this.model != null) {
            this.model.renderForStencil((Entity)this.entity, this.swing + context.partialTicks, this.swingAmount, this.customEntity ? (float)this.entityTicksExisted : (float)this.timer, this.yaw, this.pitch, 0.0625f);
        }
    }

    protected String getStencilValue(int value) {
        return this.model.limbs[value - 1].limb.name;
    }

    protected void renderLimbHighlight(ModelLimb limb) {
        float f = 0.0625f;
        float w = (float)limb.size[0] * f;
        float h = (float)limb.size[1] * f;
        float d = (float)limb.size[2] * f;
        float o = limb.sizeOffset * f;
        float minX = 0.0f;
        float minY = 0.0f;
        float minZ = 0.0f;
        float maxX = w;
        float maxY = h;
        float maxZ = d;
        float alpha = 0.2f;
        minX -= w * limb.anchor[0] + 0.1f * f;
        maxX -= w * limb.anchor[0] - 0.1f * f;
        GlStateManager.func_179141_d();
        GlStateManager.func_179147_l();
        Draw.cube((double)((minX *= -1.0f) + o), (double)((minY -= h * limb.anchor[1] + 0.1f * f) - o), (double)((minZ -= d * limb.anchor[2] + 0.1f * f) - o), (double)((maxX *= -1.0f) - o), (double)((maxY -= h * limb.anchor[1] - 0.1f * f) + o), (double)((maxZ -= d * limb.anchor[2] - 0.1f * f) + o), (float)0.0f, (float)0.5f, (float)1.0f, (float)alpha);
        GlStateManager.func_179118_c();
        GlStateManager.func_179084_k();
        if (this.origin) {
            this.drawAxis(this.model.get(limb.name), 0.25f);
        }
    }

    protected void renderObjHighlight(ModelCustomRenderer renderer) {
        float f = 0.0625f;
        GlStateManager.func_179094_E();
        GL11.glClearStencil((int)0);
        GL11.glClear((int)1024);
        GL11.glEnable((int)2960);
        GL11.glStencilOp((int)7680, (int)7681, (int)7681);
        GL11.glColorMask((boolean)false, (boolean)false, (boolean)false, (boolean)false);
        if (renderer.parent != null) {
            renderer.parent.func_78794_c(f);
        }
        List children = renderer.field_78805_m;
        renderer.field_78805_m = null;
        renderer.setupStencilRendering(1);
        renderer.func_78785_a(f);
        renderer.field_78805_m = children;
        GL11.glStencilMask((int)0);
        GL11.glStencilFunc((int)514, (int)1, (int)-1);
        GL11.glStencilOp((int)7680, (int)7680, (int)7680);
        GL11.glColorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        GL11.glLoadIdentity();
        GlStateManager.func_179128_n((int)5889);
        GlStateManager.func_179094_E();
        GL11.glLoadIdentity();
        GlStateManager.func_179147_l();
        GlStateManager.func_179131_c((float)0.0f, (float)0.5f, (float)1.0f, (float)0.2f);
        GL11.glBegin((int)5);
        GL11.glVertex3f((float)-1.0f, (float)-1.0f, (float)0.0f);
        GL11.glVertex3f((float)1.0f, (float)-1.0f, (float)0.0f);
        GL11.glVertex3f((float)-1.0f, (float)1.0f, (float)0.0f);
        GL11.glVertex3f((float)1.0f, (float)1.0f, (float)0.0f);
        GL11.glEnd();
        GL11.glFlush();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179084_k();
        GL11.glStencilMask((int)-1);
        GL11.glStencilFunc((int)512, (int)0, (int)0);
        GL11.glStencilOp((int)7680, (int)7680, (int)7680);
        GL11.glDisable((int)2960);
        GlStateManager.func_179121_F();
        GlStateManager.func_179128_n((int)5888);
        GlStateManager.func_179121_F();
        renderer.func_78794_c(f);
        if (this.origin) {
            this.drawAxis(renderer, 0.25f);
        }
    }

    protected void renderAABB() {
        ModelPose current = this.pose;
        float minX = -current.size[0] / 2.0f;
        float maxX = current.size[0] / 2.0f;
        float minY = 0.0f;
        float maxY = current.size[1];
        float minZ = -current.size[0] / 2.0f;
        float maxZ = current.size[0] / 2.0f;
        GlStateManager.func_179132_a((boolean)false);
        GlStateManager.func_179090_x();
        GlStateManager.func_179140_f();
        GlStateManager.func_179129_p();
        GlStateManager.func_179084_k();
        GlStateManager.func_179141_d();
        RenderGlobal.func_189694_a((double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ, (float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179098_w();
        GlStateManager.func_179145_e();
        GlStateManager.func_179089_o();
        GlStateManager.func_179084_k();
        GlStateManager.func_179132_a((boolean)true);
    }

    protected void renderAnchorPreview(ModelCustomRenderer renderer) {
        if (this.anchorPreview != null && renderer.min != null && renderer.max != null) {
            float ax = (float)this.anchorPreview.vector.a.value;
            float ay = (float)this.anchorPreview.vector.b.value;
            float az = (float)this.anchorPreview.vector.c.value;
            float dx = renderer.max.x - renderer.min.x;
            float dy = renderer.max.y - renderer.min.y;
            float dz = renderer.max.z - renderer.min.z;
            float x = renderer.min.x + Interpolations.lerp((float)0.0f, (float)dx, (float)ax) - this.limb.origin[0];
            float y = renderer.min.y + Interpolations.lerp((float)0.0f, (float)dy, (float)ay) - this.limb.origin[1];
            float z = renderer.min.z + Interpolations.lerp((float)0.0f, (float)dz, (float)az) - this.limb.origin[2];
            GlStateManager.func_179140_f();
            GlStateManager.func_179090_x();
            GlStateManager.func_179097_i();
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)(-x), (float)(-y), (float)z);
            Draw.point((double)0.0, (double)0.0, (double)0.0);
            GlStateManager.func_179121_F();
            GlStateManager.func_179126_j();
            GlStateManager.func_179098_w();
            GlStateManager.func_179145_e();
        }
    }

    public void setPose(ModelPose pose) {
        this.setPose(pose, pose == null ? null : pose.shapes);
    }

    public void setPose(ModelPose pose, List<ShapeKey> shapes) {
        this.pose = pose;
        this.shapes = shapes;
    }
}

