/*
 * Decompiled with CFR 0.152.
 */
package mchorse.blockbuster.client.gui.dashboard.panels.recording_editor.actions;

import java.util.ArrayList;
import java.util.Iterator;
import mchorse.blockbuster.Blockbuster;
import mchorse.blockbuster.ClientProxy;
import mchorse.blockbuster.aperture.CameraHandler;
import mchorse.blockbuster.client.gui.GuiImmersiveEditor;
import mchorse.blockbuster.client.gui.GuiImmersiveMorphMenu;
import mchorse.blockbuster.client.gui.dashboard.panels.recording_editor.GuiRecordingEditorPanel;
import mchorse.blockbuster.client.gui.dashboard.panels.recording_editor.actions.GuiActionPanel;
import mchorse.blockbuster.common.entity.EntityActor;
import mchorse.blockbuster.network.Dispatcher;
import mchorse.blockbuster.network.common.scene.sync.PacketSceneGoto;
import mchorse.blockbuster.recording.actions.MorphAction;
import mchorse.blockbuster.recording.data.Frame;
import mchorse.blockbuster.recording.data.Record;
import mchorse.blockbuster.recording.scene.Replay;
import mchorse.blockbuster.utils.EntityUtils;
import mchorse.mclib.client.gui.framework.elements.GuiElement;
import mchorse.mclib.client.gui.framework.elements.IGuiElement;
import mchorse.mclib.client.gui.framework.elements.input.GuiColorElement;
import mchorse.mclib.client.gui.framework.elements.utils.GuiContext;
import mchorse.mclib.client.gui.framework.elements.utils.GuiDraw;
import mchorse.mclib.client.gui.utils.Elements;
import mchorse.mclib.client.gui.utils.keys.IKey;
import mchorse.mclib.client.gui.utils.resizers.IResizer;
import mchorse.mclib.utils.Color;
import mchorse.mclib.utils.DummyEntity;
import mchorse.metamorph.api.MorphAPI;
import mchorse.metamorph.api.MorphUtils;
import mchorse.metamorph.api.morphs.AbstractMorph;
import mchorse.metamorph.client.gui.creative.GuiCreativeMorphsList;
import mchorse.metamorph.client.gui.creative.GuiNestedEdit;
import mchorse.metamorph.client.gui.editor.GuiAbstractMorph;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class GuiMorphActionPanel
extends GuiActionPanel<MorphAction> {
    public GuiNestedEdit pickMorph;
    public GuiColorElement onionSkin;
    public GuiElement onionSkinPanel;
    private DummyEntity actor;
    private int lastTick;
    private GuiCreativeMorphsList.OnionSkin skin;
    private boolean isImmersiveEditing;
    private boolean showRecordList;
    private int cursor;

    public GuiMorphActionPanel(Minecraft mc, GuiRecordingEditorPanel panel) {
        super(mc, panel);
        this.pickMorph = new GuiNestedEdit(mc, this::doNestEdit);
        this.pickMorph.flex().relative((IResizer)this.area).set(0.0f, 5.0f, 100.0f, 20.0f).x(0.5f, -30);
        this.onionSkin = new GuiColorElement(mc, Blockbuster.morphActionOnionSkinColor);
        this.onionSkinPanel = Elements.column((Minecraft)mc, (int)10, (int)5, (GuiElement[])new GuiElement[]{Elements.label((IKey)IKey.lang((String)"blockbuster.config.onion_skin.title")), this.onionSkin});
        this.onionSkinPanel.flex().relative((IResizer)this.area).x(0.0f, 10).y(1.0f, -20).w(150).anchorY(1.0f);
        this.add(new IGuiElement[]{this.pickMorph, this.onionSkinPanel});
        this.actor = new DummyEntity((World)this.mc.field_71441_e);
    }

    @Override
    public void setMorph(AbstractMorph morph) {
        ((MorphAction)this.action).morph = morph;
        this.pickMorph.setMorph(((MorphAction)this.action).morph);
    }

    @Override
    public void fill(MorphAction action) {
        super.fill(action);
        ClientProxy.panels.morphs.removeFromParent();
        this.pickMorph.setMorph(action.morph);
        this.onionSkinPanel.setVisible(CameraHandler.get() != null && CameraHandler.isCameraEditorOpen());
    }

    @Override
    public void disappear() {
        ClientProxy.panels.morphs.finish();
        ClientProxy.panels.morphs.removeFromParent();
        if (this.isImmersiveEditing) {
            ClientProxy.panels.closeImmersiveEditor();
        }
        ((MorphAction)this.action).morph = MorphUtils.copy((AbstractMorph)((MorphAction)this.action).morph);
        super.disappear();
    }

    @Override
    public void draw(GuiContext context) {
        if (((MorphAction)this.action).morph != null) {
            int x = this.area.mx();
            int y = this.area.y(0.8f);
            GuiDraw.scissor((int)this.area.x, (int)this.area.y, (int)this.area.w, (int)this.area.h, (GuiContext)context);
            ((MorphAction)this.action).morph.renderOnScreen((EntityPlayer)this.mc.field_71439_g, x, y, (float)this.area.h / 3.0f, 1.0f);
            GuiDraw.unscissor((GuiContext)context);
        }
        super.draw(context);
    }

    public void doNestEdit(boolean editing) {
        if (CameraHandler.get() != null && CameraHandler.isCameraEditorOpen()) {
            this.lastTick = -1;
            if (((Boolean)Blockbuster.immersiveRecordEditor.get()).booleanValue()) {
                this.cursor = Math.max(0, CameraHandler.getOffset());
                CameraHandler.detachOutside();
                GuiImmersiveEditor editor = ClientProxy.panels.showImmersiveEditor(editing, ((MorphAction)this.action).morph);
                editor.morphs.updateCallback = this::updateMorphEditor;
                editor.morphs.frameProvider = this::getFrame;
                editor.onClose = this::onImmersiveEditorClose;
                this.panel.records.removeFromParent();
                this.panel.records.flex().relative((GuiElement)editor.outerPanel);
                this.panel.timeline.removeFromParent();
                this.panel.timeline.flex().relative((GuiElement)editor.outerPanel);
                editor.outerPanel.add(new IGuiElement[]{this.panel.records, this.panel.timeline});
                this.addOnionSkin((GuiCreativeMorphsList)editor.morphs);
                this.isImmersiveEditing = true;
                this.showRecordList = this.panel.records.isVisible();
                this.panel.records.setVisible(true);
            } else {
                ClientProxy.panels.addMorphs(this, editing, ((MorphAction)this.action).morph);
                this.addOnionSkin((GuiCreativeMorphsList)ClientProxy.panels.morphs);
            }
        } else {
            ClientProxy.panels.addMorphs(this, editing, ((MorphAction)this.action).morph);
        }
    }

    public void updateMorphEditor(GuiImmersiveMorphMenu menu) {
        Record record = ClientProxy.manager.records.get(this.panel.record.filename);
        int tick = this.panel.timeline.getCurrentTick();
        tick = menu.isNested() ? this.lastTick : (tick += ((GuiAbstractMorph)menu.editor.delegate).getCurrentTick());
        if (tick != this.lastTick) {
            Dispatcher.sendToServer(new PacketSceneGoto(CameraHandler.get(), tick, (Boolean)CameraHandler.actions.get()));
            if (record != null && record.getFrameSafe(0) != null) {
                record.applyFrame(Math.max(tick - 1, 0), (EntityLivingBase)this.actor, true, true);
                Frame frame = record.getFrameSafe(tick - 1);
                if (frame.hasBodyYaw) {
                    this.actor.field_70761_aq = frame.bodyYaw;
                }
            } else {
                menu.target = null;
            }
            this.lastTick = tick;
        }
        boolean refreshTarget = true;
        if (menu.target != null && menu.target != this.actor && this.mc.field_71441_e.func_72910_y().contains(menu.target)) {
            refreshTarget = false;
        }
        if (refreshTarget) {
            DummyEntity entity = null;
            Iterator iterator = Minecraft.func_71410_x().field_71441_e.func_175644_a(EntityLivingBase.class, actor -> actor.func_70089_S() && EntityUtils.getRecordPlayer(actor) != null && EntityUtils.getRecordPlayer((EntityLivingBase)actor).record != null && this.panel.record.filename.equals(EntityUtils.getRecordPlayer((EntityLivingBase)actor).record.filename)).iterator();
            if (iterator.hasNext()) {
                EntityLivingBase actor2 = (EntityLivingBase)iterator.next();
                entity = actor2;
            }
            if (entity == null) {
                entity = this.actor;
            }
            menu.target = entity;
        }
        if (menu.target instanceof EntityActor) {
            ((EntityActor)menu.target).morph.setDirect(null);
        } else if (menu.target instanceof EntityPlayer) {
            MorphAPI.morph((EntityPlayer)((EntityPlayer)menu.target), null, (boolean)true);
        }
        if (record != null && !record.frames.isEmpty() && this.skin != null && menu.target != null) {
            Frame last = record.getFrameSafe(this.panel.timeline.getCurrentTick() - 1);
            EntityLivingBase actor3 = menu.target;
            float yaw = actor3.field_70177_z;
            Vec3d pos = new Vec3d(last.x - actor3.field_70165_t, last.y - actor3.field_70163_u, last.z - actor3.field_70161_v);
            pos = pos.func_178785_b((float)Math.toRadians(yaw));
            this.skin.offset(pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, last.pitch, last.yawHead - yaw, last.bodyYaw - yaw);
        }
    }

    public Frame getFrame(int tick) {
        Record record = ClientProxy.manager.records.get(this.panel.record.filename);
        if (record != null) {
            return record.getFrameSafe(this.panel.timeline.getCurrentTick() + tick - 1);
        }
        return null;
    }

    public void addOnionSkin(GuiCreativeMorphsList morphs) {
        if (this.onionSkin.picker.color.a < 0.003921f) {
            return;
        }
        ArrayList<GuiCreativeMorphsList.OnionSkin> skins = new ArrayList<GuiCreativeMorphsList.OnionSkin>();
        Record record = this.panel.record;
        Color color = this.onionSkin.picker.color;
        if (record != null) {
            Record.FoundAction found = record.seekMorphAction(this.panel.timeline.getCurrentTick(), (MorphAction)this.action);
            AbstractMorph morph = null;
            int tick = 0;
            if (found != null) {
                morph = found.action.morph;
                tick = found.tick;
            } else {
                for (Replay replay : ClientProxy.panels.scenePanel.getReplays()) {
                    if (!replay.id.equals(this.panel.record.filename)) continue;
                    morph = replay.morph;
                    break;
                }
            }
            if (morph != null) {
                MorphUtils.pause((AbstractMorph)morph, null, (int)Math.max(0, this.panel.timeline.getCurrentTick() - tick));
                this.skin = new GuiCreativeMorphsList.OnionSkin().color(color.r, color.g, color.b, color.a).morph(morph);
                skins.add(this.skin);
            }
        }
        morphs.lastOnionSkins = skins;
    }

    public void onImmersiveEditorClose(GuiImmersiveEditor editor) {
        this.isImmersiveEditing = false;
        this.panel.records.setVisible(this.showRecordList);
        CameraHandler.updatePlayerPosition();
        CameraHandler.attachOutside();
        CameraHandler.moveRecordPanel(this.panel);
        Dispatcher.sendToServer(new PacketSceneGoto(CameraHandler.get(), this.cursor, (Boolean)CameraHandler.actions.get()));
    }
}

