/*
 * Decompiled with CFR 0.152.
 */
package mchorse.blockbuster.client.gui.dashboard.panels.snowstorm.sections;

import mchorse.blockbuster.client.gui.dashboard.panels.snowstorm.GuiSnowstorm;
import mchorse.blockbuster.client.gui.dashboard.panels.snowstorm.sections.GuiSnowstormSection;
import mchorse.blockbuster.client.particles.BedrockScheme;
import mchorse.blockbuster.client.particles.components.expiration.BedrockComponentExpireBlocks;
import mchorse.blockbuster.client.particles.components.expiration.BedrockComponentExpireInBlocks;
import mchorse.blockbuster.client.particles.components.expiration.BedrockComponentExpireNotInBlocks;
import mchorse.blockbuster.client.particles.components.expiration.BedrockComponentKillPlane;
import mchorse.blockbuster.client.particles.components.expiration.BedrockComponentParticleLifetime;
import mchorse.mclib.client.gui.framework.elements.GuiElement;
import mchorse.mclib.client.gui.framework.elements.IGuiElement;
import mchorse.mclib.client.gui.framework.elements.buttons.GuiCirculateElement;
import mchorse.mclib.client.gui.framework.elements.buttons.GuiIconElement;
import mchorse.mclib.client.gui.framework.elements.buttons.GuiSlotElement;
import mchorse.mclib.client.gui.framework.elements.context.GuiSimpleContextMenu;
import mchorse.mclib.client.gui.framework.elements.input.GuiTextElement;
import mchorse.mclib.client.gui.framework.elements.input.GuiTrackpadElement;
import mchorse.mclib.client.gui.framework.elements.utils.GuiLabel;
import mchorse.mclib.client.gui.framework.tooltips.LabelTooltip;
import mchorse.mclib.client.gui.utils.Elements;
import mchorse.mclib.client.gui.utils.Icons;
import mchorse.mclib.client.gui.utils.keys.IKey;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;

public class GuiSnowstormExpirationSection
extends GuiSnowstormSection {
    public GuiCirculateElement mode;
    public GuiTextElement expression;
    public GuiTrackpadElement a;
    public GuiTrackpadElement b;
    public GuiTrackpadElement c;
    public GuiTrackpadElement d;
    public GuiBlocksSection inBlocksSection;
    public GuiBlocksSection notInBlocksSection;
    private BedrockComponentParticleLifetime lifetime;
    private BedrockComponentKillPlane plane;
    private BedrockComponentExpireInBlocks inBlocks;
    private BedrockComponentExpireNotInBlocks notInBlocks;

    public GuiSnowstormExpirationSection(Minecraft mc, GuiSnowstorm parent) {
        super(mc, parent);
        this.mode = new GuiCirculateElement(mc, b -> {
            this.lifetime.max = this.mode.getValue() == 1;
            this.updateTooltip();
            this.parent.dirty();
        });
        this.mode.addLabel(IKey.lang((String)"blockbuster.gui.snowstorm.expiration.expression"));
        this.mode.addLabel(IKey.lang((String)"blockbuster.gui.snowstorm.expiration.max"));
        this.expression = new GuiTextElement(mc, 10000, str -> {
            this.lifetime.expression = this.parse((String)str, this.expression, this.lifetime.expression);
        });
        this.expression.tooltip(IKey.lang((String)""));
        this.a = new GuiTrackpadElement(mc, value -> {
            this.plane.a = value.floatValue();
            this.parent.dirty();
        });
        this.a.tooltip(IKey.str((String)"Ax"));
        this.b = new GuiTrackpadElement(mc, value -> {
            this.plane.b = value.floatValue();
            this.parent.dirty();
        });
        this.b.tooltip(IKey.str((String)"By"));
        this.c = new GuiTrackpadElement(mc, value -> {
            this.plane.c = value.floatValue();
            this.parent.dirty();
        });
        this.c.tooltip(IKey.str((String)"Cz"));
        this.d = new GuiTrackpadElement(mc, value -> {
            this.plane.d = value.floatValue();
            this.parent.dirty();
        });
        this.d.tooltip(IKey.str((String)"D"));
        this.inBlocksSection = new GuiBlocksSection(mc, IKey.lang((String)"blockbuster.gui.snowstorm.expiration.in_blocks"), this);
        this.notInBlocksSection = new GuiBlocksSection(mc, IKey.lang((String)"blockbuster.gui.snowstorm.expiration.not_in_blocks"), this);
        this.fields.add((IGuiElement)Elements.row((Minecraft)mc, (int)5, (int)0, (int)20, (GuiElement[])new GuiElement[]{Elements.label((IKey)IKey.lang((String)"blockbuster.gui.snowstorm.mode"), (int)20).anchor(0.0f, 0.5f), this.mode}));
        this.fields.add((IGuiElement)this.expression);
        this.fields.add((IGuiElement)Elements.label((IKey)IKey.lang((String)"blockbuster.gui.snowstorm.expiration.kill_plane")).marginTop(12).tooltip(IKey.lang((String)"blockbuster.gui.snowstorm.expiration.kill_plane_tooltip")));
        this.fields.add((IGuiElement)Elements.row((Minecraft)mc, (int)5, (int)0, (int)20, (GuiElement[])new GuiElement[]{this.a, this.b}));
        this.fields.add((IGuiElement)Elements.row((Minecraft)mc, (int)5, (int)0, (int)20, (GuiElement[])new GuiElement[]{this.c, this.d}));
        this.fields.add(new IGuiElement[]{this.inBlocksSection, this.notInBlocksSection});
    }

    private void updateTooltip() {
        ((LabelTooltip)this.expression.tooltip).label.set(this.lifetime.max ? "blockbuster.gui.snowstorm.expiration.max_tooltip" : "blockbuster.gui.snowstorm.expiration.expression_tooltip");
    }

    @Override
    public String getTitle() {
        return "blockbuster.gui.snowstorm.expiration.title";
    }

    @Override
    public void setScheme(BedrockScheme scheme) {
        super.setScheme(scheme);
        this.lifetime = scheme.getOrCreate(BedrockComponentParticleLifetime.class);
        this.plane = scheme.getOrCreate(BedrockComponentKillPlane.class);
        this.inBlocks = scheme.getOrCreate(BedrockComponentExpireInBlocks.class);
        this.notInBlocks = scheme.getOrCreate(BedrockComponentExpireNotInBlocks.class);
        this.mode.setValue(this.lifetime.max ? 1 : 0);
        this.set(this.expression, this.lifetime.expression);
        this.updateTooltip();
        this.a.setValue((double)this.plane.a);
        this.b.setValue((double)this.plane.b);
        this.c.setValue((double)this.plane.c);
        this.d.setValue((double)this.plane.d);
        this.inBlocksSection.setComponent(this.inBlocks);
        this.notInBlocksSection.setComponent(this.notInBlocks);
    }

    @Override
    public void beforeSave(BedrockScheme scheme) {
        this.compileBlocks(this.inBlocks, this.inBlocksSection);
        this.compileBlocks(this.notInBlocks, this.notInBlocksSection);
    }

    private void compileBlocks(BedrockComponentExpireBlocks component, GuiBlocksSection section) {
        component.blocks.clear();
        for (IGuiElement child : section.blocks.getChildren()) {
            if (!(child instanceof GuiSlotElement)) continue;
            GuiSlotElement slot = (GuiSlotElement)child;
            if (slot.getStack().func_77973_b() instanceof ItemBlock) {
                component.blocks.add(((ItemBlock)slot.getStack().func_77973_b()).func_179223_d());
                continue;
            }
            if (!slot.getStack().func_190926_b()) continue;
            component.blocks.add(Blocks.field_150350_a);
        }
    }

    public static class GuiBlocksSection
    extends GuiElement {
        public GuiElement blocks;
        private GuiSnowstormExpirationSection parent;
        private BedrockComponentExpireBlocks component;

        public GuiBlocksSection(Minecraft mc, IKey title, GuiSnowstormExpirationSection parent) {
            super(mc);
            this.parent = parent;
            GuiIconElement add = new GuiIconElement(mc, Icons.ADD, b -> {
                this.addBlock(Blocks.field_150350_a);
                this.parent.resizeParent();
            });
            GuiLabel label = Elements.label((IKey)title).anchor(0.0f, 0.5f);
            GuiElement row = Elements.row((Minecraft)mc, (int)5, (int)0, (int)20, (GuiElement[])new GuiElement[]{label, add});
            this.blocks = new GuiElement(mc);
            add.flex().wh(10, 16);
            label.flex().h(0);
            row.flex().row(5).preferred(0);
            this.blocks.flex().grid(7).items(6).resizes(true);
            this.flex().column(5).vertical().stretch();
            this.add(new IGuiElement[]{row, this.blocks});
        }

        public void setComponent(BedrockComponentExpireBlocks component) {
            this.component = component;
            this.blocks.removeAll();
            for (Block block : this.component.blocks) {
                this.addBlock(block);
            }
        }

        public void addBlock(Block block) {
            GuiSlotElement slotElement = new GuiSlotElement(this.mc, 0, null);
            slotElement.callback = stack -> {
                if (!(stack.func_77973_b() instanceof ItemBlock)) {
                    slotElement.setStack(ItemStack.field_190927_a);
                }
            };
            slotElement.setStack(new ItemStack(block, 1));
            slotElement.context(() -> new GuiSimpleContextMenu(this.mc).action(Icons.REMOVE, IKey.lang((String)"Remove block"), () -> {
                slotElement.removeFromParent();
                this.parent.resizeParent();
            }));
            this.blocks.add((IGuiElement)slotElement);
        }
    }
}

