/*
 * Decompiled with CFR 0.152.
 */
package mchorse.blockbuster.client.gui.dashboard.panels.snowstorm.utils;

import mchorse.blockbuster.client.gui.dashboard.panels.snowstorm.sections.GuiSnowstormSection;
import mchorse.blockbuster.client.particles.components.appearance.Tint;
import mchorse.mclib.client.gui.framework.elements.GuiElement;
import mchorse.mclib.client.gui.framework.elements.context.GuiContextMenu;
import mchorse.mclib.client.gui.framework.elements.context.GuiSimpleContextMenu;
import mchorse.mclib.client.gui.framework.elements.input.GuiColorElement;
import mchorse.mclib.client.gui.framework.elements.utils.GuiContext;
import mchorse.mclib.client.gui.framework.elements.utils.GuiDraw;
import mchorse.mclib.client.gui.utils.Area;
import mchorse.mclib.client.gui.utils.Icons;
import mchorse.mclib.client.gui.utils.keys.IKey;
import mchorse.mclib.math.Constant;
import mchorse.mclib.math.IValue;
import mchorse.mclib.math.molang.expressions.MolangValue;
import mchorse.mclib.utils.Color;
import mchorse.mclib.utils.MathUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.GlStateManager;

public class GuiGradientEditor
extends GuiElement {
    private GuiSnowstormSection section;
    private GuiColorElement color;
    private Tint.Gradient gradient;
    private Tint.Gradient.ColorStop current;
    private int dragging = -1;
    private int lastX;
    private Area a = new Area();
    private Area b = new Area();
    private Color c = new Color();

    public GuiGradientEditor(Minecraft mc, GuiSnowstormSection section, GuiColorElement color) {
        super(mc);
        this.section = section;
        this.color = color;
        this.flex().h(20);
    }

    private Color fillColor(Tint.Solid solid) {
        this.c.r = (float)solid.r.get();
        this.c.g = (float)solid.g.get();
        this.c.b = (float)solid.b.get();
        this.c.a = (float)solid.a.get();
        return this.c;
    }

    private Area fillBound(Tint.Gradient.ColorStop stop) {
        int x = this.a.x(stop.stop);
        this.b.set(x - 3, this.a.ey() - 7, 6, 10);
        return this.b;
    }

    private void fillStop(Tint.Gradient.ColorStop stop) {
        this.current = stop;
        this.color.picker.setColor(this.fillColor(stop.color).getRGBAColor());
    }

    public void setColor(int color) {
        this.c.set(color, true);
        ((MolangValue)this.current.color.r).value.set((double)this.c.r);
        ((MolangValue)this.current.color.g).value.set((double)this.c.g);
        ((MolangValue)this.current.color.b).value.set((double)this.c.b);
        ((MolangValue)this.current.color.a).value.set((double)this.c.a);
        this.section.dirty();
    }

    public void setGradient(Tint.Gradient gradient) {
        this.gradient = gradient;
        if (this.gradient.stops.isEmpty()) {
            this.gradient.stops.add(new Tint.Gradient.ColorStop(0.0f, new Tint.Solid()));
        }
        this.fillStop(this.gradient.stops.get(0));
        this.color.picker.setColor(this.fillColor(this.current.color).getRGBAColor());
    }

    public GuiContextMenu createContextMenu(GuiContext context) {
        GuiSimpleContextMenu menu = new GuiSimpleContextMenu(context.mc);
        menu.action(Icons.ADD, IKey.lang((String)"blockbuster.gui.snowstorm.lighting.context.add_stop"), () -> this.addColorStop(context.mouseX));
        if (this.gradient.stops.size() > 1) {
            menu.action(Icons.REMOVE, IKey.lang((String)"blockbuster.gui.snowstorm.lighting.context.remove_stop"), this::removeColorStop);
        }
        return menu;
    }

    private void addColorStop(int mouseX) {
        float x = (float)(mouseX - this.area.x) / (float)this.area.w;
        Tint.Solid color = new Tint.Solid();
        Tint.Gradient.ColorStop stop = new Tint.Gradient.ColorStop(x, color);
        color.r = new MolangValue(null, (IValue)new Constant(1.0));
        color.g = new MolangValue(null, (IValue)new Constant(1.0));
        color.b = new MolangValue(null, (IValue)new Constant(1.0));
        color.a = new MolangValue(null, (IValue)new Constant(1.0));
        this.gradient.stops.add(stop);
        this.gradient.sort();
        this.section.dirty();
        this.fillStop(stop);
    }

    private void removeColorStop() {
        if (this.gradient.stops.size() > 2) {
            int index = this.gradient.stops.indexOf(this.current);
            this.gradient.stops.remove(index);
            index = MathUtils.clamp((int)index, (int)0, (int)(this.gradient.stops.size() - 1));
            this.section.dirty();
            this.fillStop(this.gradient.stops.get(index));
        }
    }

    public void resize() {
        super.resize();
        this.a.copy(this.area);
        this.a.offset(-1);
    }

    public boolean mouseClicked(GuiContext context) {
        if (super.mouseClicked(context)) {
            return true;
        }
        if (this.area.isInside(context)) {
            for (Tint.Gradient.ColorStop stop : this.gradient.stops) {
                Area area = this.fillBound(stop);
                if (!area.isInside(context)) continue;
                this.dragging = 0;
                this.lastX = context.mouseX;
                this.fillStop(stop);
                return true;
            }
            return true;
        }
        return false;
    }

    public void mouseReleased(GuiContext context) {
        super.mouseReleased(context);
        if (this.dragging != -1) {
            this.section.dirty();
        }
        this.dragging = -1;
    }

    public void draw(GuiContext context) {
        int i;
        if (this.dragging == 0 && Math.abs(context.mouseX - this.lastX) > 3) {
            this.dragging = 1;
        } else if (this.dragging == 1) {
            float x = (float)(context.mouseX - this.area.x) / (float)this.area.w;
            this.current.stop = MathUtils.clamp((float)x, (float)0.0f, (float)1.0f);
            this.gradient.sort();
        }
        this.area.draw(-16777216);
        int size = this.gradient.stops.size();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Icons.CHECKBOARD.renderArea(this.a.x, this.a.y, this.a.w, this.a.h);
        Tint.Gradient.ColorStop first = this.gradient.stops.get(0);
        if (first.stop > 0.0f) {
            int x1 = this.a.x(first.stop);
            int rgba1 = this.fillColor(first.color).getRGBAColor();
            Gui.func_73734_a((int)this.a.x, (int)this.a.y, (int)x1, (int)this.a.ey(), (int)rgba1);
        }
        for (i = 0; i < size; ++i) {
            Tint.Gradient.ColorStop stop = this.gradient.stops.get(i);
            Tint.Gradient.ColorStop next = i + 1 < size ? this.gradient.stops.get(i + 1) : stop;
            int x1 = this.a.x(stop.stop);
            int x2 = this.a.x(next == stop ? 1.0f : next.stop);
            int rgba1 = this.fillColor(stop.color).getRGBAColor();
            int rgba2 = this.fillColor(next.color).getRGBAColor();
            GuiDraw.drawHorizontalGradientRect((int)x1, (int)this.a.y, (int)x2, (int)this.a.ey(), (int)rgba1, (int)rgba2);
        }
        for (i = 0; i < size; ++i) {
            Tint.Gradient.ColorStop stop = this.gradient.stops.get(i);
            Area area = this.fillBound(stop);
            int x = this.a.x(stop.stop);
            Gui.func_73734_a((int)area.x, (int)area.y, (int)area.ex(), (int)area.ey(), (int)(this.current == stop ? -1 : -16777216));
            Gui.func_73734_a((int)(area.x + 1), (int)(area.y + 1), (int)(area.ex() - 1), (int)(area.ey() - 1), (int)this.fillColor(stop.color).getRGBAColor());
        }
        super.draw(context);
    }
}

