/*
 * Decompiled with CFR 0.152.
 */
package mchorse.blockbuster.client.gui.utils;

import java.util.List;
import java.util.function.Supplier;
import mchorse.blockbuster.api.Model;
import mchorse.blockbuster.api.formats.obj.ShapeKey;
import mchorse.blockbuster_pack.client.gui.GuiCustomMorph;
import mchorse.mclib.client.gui.framework.GuiBase;
import mchorse.mclib.client.gui.framework.elements.GuiElement;
import mchorse.mclib.client.gui.framework.elements.IGuiElement;
import mchorse.mclib.client.gui.framework.elements.buttons.GuiToggleElement;
import mchorse.mclib.client.gui.framework.elements.context.GuiContextMenu;
import mchorse.mclib.client.gui.framework.elements.context.GuiSimpleContextMenu;
import mchorse.mclib.client.gui.framework.elements.input.GuiTrackpadElement;
import mchorse.mclib.client.gui.framework.elements.list.GuiListElement;
import mchorse.mclib.client.gui.framework.elements.utils.GuiContext;
import mchorse.mclib.client.gui.utils.Icons;
import mchorse.mclib.client.gui.utils.keys.IKey;
import mchorse.mclib.client.gui.utils.resizers.IResizer;
import mchorse.mclib.utils.Direction;
import mchorse.mclib.utils.MathUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;

public class GuiShapeKeysEditor
extends GuiElement {
    public GuiListElement<ShapeKey> shapes;
    public GuiTrackpadElement factor;
    public GuiToggleElement relative;
    private Supplier<Model> supplier;

    public GuiShapeKeysEditor(Minecraft mc, Supplier<Model> supplier) {
        super(mc);
        this.supplier = supplier;
        this.shapes = new GuiCustomMorph.GuiShapeKeyListElement(mc, str -> this.setFactor((ShapeKey)str.get(0)));
        this.shapes.sorting().background();
        this.shapes.context(() -> {
            GuiSimpleContextMenu menu = new GuiSimpleContextMenu(mc);
            menu.action(Icons.ADD, IKey.lang((String)"blockbuster.gui.builder.context.add"), () -> {
                Model model;
                Model model2 = model = this.supplier == null ? null : this.supplier.get();
                if (model == null) {
                    return;
                }
                GuiSimpleContextMenu nested = new GuiSimpleContextMenu(mc);
                for (String key : model.shapes) {
                    nested.action(Icons.ADD, IKey.format((String)"blockbuster.gui.builder.context.add_to", (Object[])new Object[]{key}), () -> {
                        ShapeKey shapeKey = new ShapeKey(key, 0.0f);
                        this.shapes.getList().add(shapeKey);
                        this.shapes.update();
                        this.shapes.setCurrent((Object)shapeKey);
                        this.setFactor(shapeKey);
                    });
                }
                GuiBase.getCurrent().replaceContextMenu((GuiContextMenu)nested);
            });
            if (this.shapes.getIndex() != -1) {
                menu.action(Icons.REMOVE, IKey.lang((String)"blockbuster.gui.builder.context.remove"), () -> {
                    int index = this.shapes.getIndex();
                    this.shapes.getList().remove(index);
                    index = MathUtils.clamp((int)index, (int)0, (int)(this.shapes.getList().size() - 1));
                    this.shapes.setIndex(index);
                    this.setFactor((ShapeKey)this.shapes.getCurrentFirst());
                });
            }
            return menu;
        });
        this.factor = new GuiTrackpadElement(mc, value -> this.setFactor(value.floatValue()));
        this.factor.tooltip(IKey.lang((String)"blockbuster.gui.builder.shape_keys_factor_tooltip"), Direction.TOP);
        this.relative = new GuiToggleElement(mc, IKey.lang((String)"blockbuster.gui.builder.relative"), b -> {
            ((ShapeKey)this.shapes.getCurrentFirst()).relative = b.isToggled();
        });
        this.relative.tooltip(IKey.lang((String)"blockbuster.gui.builder.relative_tooltip"), Direction.TOP);
        this.shapes.flex().relative((GuiElement)this).y(12).w(1.0f).hTo((IResizer)this.factor.flex(), -17);
        this.factor.flex().relative((IResizer)this.relative.flex()).y(-25).w(1.0f).h(20);
        this.relative.flex().relative((GuiElement)this).y(1.0f).w(1.0f).anchorY(1.0f);
        this.add(new IGuiElement[]{this.relative, this.factor, this.shapes});
    }

    private void setFactor(ShapeKey key) {
        this.factor.setEnabled(key != null);
        this.relative.setEnabled(key != null);
        if (key != null) {
            this.factor.setValue((double)key.value);
            this.relative.toggled(key.relative);
        }
    }

    private void setFactor(float value) {
        ((ShapeKey)this.shapes.getCurrentFirst()).value = value;
    }

    public void fillData(List<ShapeKey> shapeKeys) {
        this.shapes.setList(shapeKeys);
        if (!shapeKeys.isEmpty()) {
            this.shapes.setIndex(0);
            this.setFactor((ShapeKey)this.shapes.getCurrentFirst());
        } else {
            this.setFactor(null);
        }
    }

    public void draw(GuiContext context) {
        super.draw(context);
        if (this.shapes.isVisible()) {
            this.font.func_175063_a(I18n.func_135052_a((String)"blockbuster.gui.builder.shape_keys", (Object[])new Object[0]), (float)this.shapes.area.x, (float)(this.shapes.area.y - 12), 0xFFFFFF);
        }
        if (this.factor.isVisible()) {
            this.font.func_175063_a(I18n.func_135052_a((String)"blockbuster.gui.builder.shape_keys_factor", (Object[])new Object[0]), (float)this.factor.area.x, (float)(this.factor.area.y - 12), 0xFFFFFF);
        }
    }
}

