/*
 * Decompiled with CFR 0.152.
 */
package mchorse.blockbuster.client.model;

import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import mchorse.blockbuster.api.ModelLimb;
import mchorse.blockbuster.api.ModelTransform;
import mchorse.blockbuster.api.formats.obj.MeshOBJ;
import mchorse.blockbuster.api.formats.obj.MeshesOBJ;
import mchorse.blockbuster.api.formats.obj.OBJMaterial;
import mchorse.blockbuster.api.formats.obj.ShapeKey;
import mchorse.blockbuster.client.model.ModelCustom;
import mchorse.blockbuster.client.model.ModelCustomRenderer;
import mchorse.blockbuster.client.render.RenderCustomModel;
import mchorse.blockbuster.client.textures.MipmapTexture;
import mchorse.mclib.client.render.VertexBuilder;
import mchorse.mclib.utils.Interpolations;
import mchorse.mclib.utils.ReflectionUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.ITextureObject;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class ModelOBJRenderer
extends ModelCustomRenderer {
    public MeshesOBJ mesh;
    public OBJDisplayList[] displayLists;
    public Map<String, ResourceLocation> materials;
    public List<ShapeKey> shapes;
    protected int solidColorTex = -1;

    public ModelOBJRenderer(ModelCustom model, ModelLimb limb, ModelTransform transform, MeshesOBJ mesh) {
        super(model, limb, transform);
        this.mesh = mesh;
        this.min = mesh.getMin();
        this.max = mesh.getMax();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void func_78788_d(float scale) {
        if (this.mesh != null) {
            this.displayLists = new OBJDisplayList[this.mesh.meshes.size()];
            int index = 0;
            int texture = 0;
            int count = 0;
            for (MeshOBJ meshOBJ : this.mesh.meshes) {
                count += meshOBJ.material != null && !meshOBJ.material.useTexture ? 1 : 0;
            }
            if (count > 0) {
                ByteBuffer buffer = GLAllocation.func_74524_c((int)(count * 4));
                texture = GL11.glGenTextures();
                for (MeshOBJ mesh : this.mesh.meshes) {
                    if (mesh.material == null || mesh.material.useTexture) continue;
                    buffer.put((byte)(mesh.material.r * 255.0f));
                    buffer.put((byte)(mesh.material.g * 255.0f));
                    buffer.put((byte)(mesh.material.b * 255.0f));
                    buffer.put((byte)-1);
                }
                buffer.flip();
                GlStateManager.func_179144_i((int)texture);
                GlStateManager.func_187421_b((int)3553, (int)10241, (int)9728);
                GlStateManager.func_187421_b((int)3553, (int)10240, (int)9728);
                GL11.glTexImage2D((int)3553, (int)0, (int)32856, (int)count, (int)1, (int)0, (int)6408, (int)5121, (ByteBuffer)buffer);
            }
            int j = 0;
            boolean bl = false;
            for (MeshOBJ mesh : this.mesh.meshes) {
                void var6_11;
                OBJMaterial material = mesh.material;
                if (material != null && material.useTexture && material.texture != null) {
                    this.setupTexture(material);
                }
                int id = GLAllocation.func_74526_a((int)1);
                boolean hasColor = material != null && !mesh.material.useTexture;
                BufferBuilder renderer = Tessellator.func_178181_a().func_178180_c();
                GlStateManager.func_187423_f((int)id, (int)4864);
                renderer.func_181668_a(4, VertexBuilder.getFormat((boolean)false, (boolean)true, (boolean)false, (boolean)true));
                float texF = ((float)j + 0.5f) / (float)count;
                int c = mesh.triangles;
                for (int i = 0; i < c; ++i) {
                    float x = mesh.posData[i * 3] - this.limb.origin[0];
                    float y = -mesh.posData[i * 3 + 1] + this.limb.origin[1];
                    float z = mesh.posData[i * 3 + 2] - this.limb.origin[2];
                    float u = mesh.texData[i * 2];
                    float v = mesh.texData[i * 2 + 1];
                    float nx = mesh.normData[i * 3];
                    float ny = -mesh.normData[i * 3 + 1];
                    float nz = mesh.normData[i * 3 + 2];
                    if (!this.model.model.legacyObj) {
                        x = -mesh.posData[i * 3] + this.limb.origin[0];
                        nx *= -1.0f;
                    }
                    if (hasColor) {
                        renderer.func_181662_b((double)x, (double)y, (double)z).func_187315_a((double)texF, 0.5).func_181663_c(nx, ny, nz).func_181675_d();
                    } else {
                        renderer.func_181662_b((double)x, (double)y, (double)z).func_187315_a((double)u, (double)v).func_181663_c(nx, ny, nz).func_181675_d();
                    }
                    if (i % 3 != 2) continue;
                    VertexBuilder.calcTangent((BufferBuilder)renderer, (boolean)false);
                }
                Tessellator.func_178181_a().func_78381_a();
                GlStateManager.func_187415_K();
                this.displayLists[index++] = new OBJDisplayList((int)var6_11, id, texture, mesh, this.mesh.shapes == null);
                j += hasColor ? 1 : 0;
                ++var6_11;
            }
            this.field_78812_q = true;
            this.solidColorTex = texture;
            if (this.mesh.shapes == null) {
                this.mesh = null;
            }
        } else {
            super.func_78788_d(scale);
        }
    }

    private void setupTexture(OBJMaterial material) {
        TextureManager manager = Minecraft.func_71410_x().field_71446_o;
        Object texture = manager.func_110581_b(material.texture);
        Map map = ReflectionUtils.getTextures((TextureManager)manager);
        if (texture != null && !(texture instanceof MipmapTexture)) {
            GlStateManager.func_179150_h((int)((ITextureObject)map.remove(material.texture)).func_110552_b());
            texture = null;
        }
        if (texture == null) {
            try {
                texture = new MipmapTexture(material.texture);
                texture.func_110551_a(Minecraft.func_71410_x().func_110442_L());
                map.put(material.texture, texture);
            }
            catch (Exception e) {
                System.err.println("An error occurred during loading manually a mipmap'd texture '" + material.texture + "'");
                e.printStackTrace();
            }
        }
        boolean loaded = texture instanceof MipmapTexture;
        manager.func_110577_a(material.texture);
        int mod = material.linear ? (loaded ? 9987 : 9729) : (loaded ? 9986 : 9728);
        int mag = material.linear ? 9729 : 9728;
        GlStateManager.func_187421_b((int)3553, (int)10241, (int)mod);
        GlStateManager.func_187421_b((int)3553, (int)10240, (int)mag);
    }

    @Override
    protected void renderDisplayList() {
        for (OBJDisplayList list : this.displayLists) {
            boolean hasTexture;
            boolean hasColor = list.material != null && !list.material.useTexture;
            boolean bl = hasTexture = list.material != null && list.material.useTexture;
            if (hasColor) {
                GlStateManager.func_179144_i((int)list.texId);
            }
            if (hasTexture && list.material.texture != null) {
                ResourceLocation texture = list.material.texture;
                if (this.materials != null && this.materials.containsKey(list.material.name)) {
                    texture = this.materials.get(list.material.name);
                }
                Minecraft.func_71410_x().field_71446_o.func_110577_a(texture);
            }
            list.render(this);
            if (!hasColor && (!hasTexture || list.material.texture == null)) continue;
            RenderCustomModel.bindLastTexture();
        }
    }

    @Override
    public void delete() {
        super.delete();
        if (this.displayLists != null) {
            for (OBJDisplayList list : this.displayLists) {
                if (list.id == -1) continue;
                GL11.glDeleteLists((int)list.id, (int)1);
            }
        }
        if (this.solidColorTex != -1) {
            GL11.glDeleteTextures((int)this.solidColorTex);
        }
    }

    public static class OBJDisplayList {
        public int index;
        public int id;
        public int texId;
        public OBJMaterial material;
        private MeshOBJ mesh;
        private MeshOBJ temporary;

        public OBJDisplayList(int index, int id, int texId, MeshOBJ mesh, boolean discard) {
            this.index = index;
            this.id = id;
            this.texId = texId;
            this.material = mesh.material;
            if (!discard) {
                this.mesh = mesh;
                this.temporary = new MeshOBJ(new float[mesh.posData.length], new float[mesh.texData.length], new float[mesh.normData.length]);
            }
        }

        public void render(ModelOBJRenderer renderer) {
            if (renderer.shapes != null && !renderer.shapes.isEmpty() && this.mesh != null) {
                BufferBuilder builder = Tessellator.func_178181_a().func_178180_c();
                builder.func_181668_a(4, VertexBuilder.getFormat((boolean)false, (boolean)true, (boolean)false, (boolean)true));
                int c = this.mesh.triangles;
                for (int i = 0; i < c; ++i) {
                    this.temporary.posData[i * 3] = this.mesh.posData[i * 3];
                    this.temporary.posData[i * 3 + 1] = this.mesh.posData[i * 3 + 1];
                    this.temporary.posData[i * 3 + 2] = this.mesh.posData[i * 3 + 2];
                    this.temporary.texData[i * 2] = this.mesh.texData[i * 2];
                    this.temporary.texData[i * 2 + 1] = this.mesh.texData[i * 2 + 1];
                    this.temporary.normData[i * 3] = this.mesh.normData[i * 3];
                    this.temporary.normData[i * 3 + 1] = this.mesh.normData[i * 3 + 1];
                    this.temporary.normData[i * 3 + 2] = this.mesh.normData[i * 3 + 2];
                }
                for (ShapeKey key : renderer.shapes) {
                    List<MeshOBJ> list = renderer.mesh.shapes.get(key.name);
                    if (list == null) continue;
                    MeshOBJ mesh = list.get(this.index);
                    float factor = key.value;
                    if (mesh == null || this.temporary.triangles != mesh.triangles) continue;
                    int c2 = this.temporary.triangles;
                    for (int i = 0; i < c2; ++i) {
                        float v;
                        float u;
                        float z;
                        float y;
                        float x;
                        float nx = this.temporary.normData[i * 3];
                        float ny = this.temporary.normData[i * 3 + 1];
                        float nz = this.temporary.normData[i * 3 + 2];
                        if (key.relative) {
                            x = this.temporary.posData[i * 3] + Interpolations.lerp((float)this.mesh.posData[i * 3], (float)mesh.posData[i * 3], (float)factor) - this.mesh.posData[i * 3];
                            y = this.temporary.posData[i * 3 + 1] + Interpolations.lerp((float)this.mesh.posData[i * 3 + 1], (float)mesh.posData[i * 3 + 1], (float)factor) - this.mesh.posData[i * 3 + 1];
                            z = this.temporary.posData[i * 3 + 2] + Interpolations.lerp((float)this.mesh.posData[i * 3 + 2], (float)mesh.posData[i * 3 + 2], (float)factor) - this.mesh.posData[i * 3 + 2];
                            u = this.temporary.texData[i * 2] + Interpolations.lerp((float)this.mesh.texData[i * 2], (float)mesh.texData[i * 2], (float)factor) - this.mesh.texData[i * 2];
                            v = this.temporary.texData[i * 2 + 1] + Interpolations.lerp((float)this.mesh.texData[i * 2 + 1], (float)mesh.texData[i * 2 + 1], (float)factor) - this.mesh.texData[i * 2 + 1];
                        } else {
                            x = Interpolations.lerp((float)this.temporary.posData[i * 3], (float)mesh.posData[i * 3], (float)factor);
                            y = Interpolations.lerp((float)this.temporary.posData[i * 3 + 1], (float)mesh.posData[i * 3 + 1], (float)factor);
                            z = Interpolations.lerp((float)this.temporary.posData[i * 3 + 2], (float)mesh.posData[i * 3 + 2], (float)factor);
                            u = Interpolations.lerp((float)this.temporary.texData[i * 2], (float)mesh.texData[i * 2], (float)factor);
                            v = Interpolations.lerp((float)this.temporary.texData[i * 2 + 1], (float)mesh.texData[i * 2 + 1], (float)factor);
                        }
                        if (nx == mesh.normData[i * 3] && ny == mesh.normData[i * 3 + 1] && nz == mesh.normData[i * 3 + 2]) {
                            nx = Interpolations.lerp((float)nx, (float)mesh.normData[i * 3], (float)factor);
                            ny = Interpolations.lerp((float)ny, (float)mesh.normData[i * 3 + 1], (float)factor);
                            nz = Interpolations.lerp((float)nz, (float)mesh.normData[i * 3 + 2], (float)factor);
                        }
                        this.temporary.posData[i * 3] = x;
                        this.temporary.posData[i * 3 + 1] = y;
                        this.temporary.posData[i * 3 + 2] = z;
                        this.temporary.texData[i * 2] = u;
                        this.temporary.texData[i * 2 + 1] = v;
                        this.temporary.normData[i * 3] = nx;
                        this.temporary.normData[i * 3 + 1] = ny;
                        this.temporary.normData[i * 3 + 2] = nz;
                    }
                }
                c = this.temporary.triangles;
                for (int i = 0; i < c; ++i) {
                    float x = this.temporary.posData[i * 3] - renderer.limb.origin[0];
                    float y = -this.temporary.posData[i * 3 + 1] + renderer.limb.origin[1];
                    float z = this.temporary.posData[i * 3 + 2] - renderer.limb.origin[2];
                    float u = this.temporary.texData[i * 2];
                    float v = this.temporary.texData[i * 2 + 1];
                    float nx = this.temporary.normData[i * 3];
                    float ny = -this.temporary.normData[i * 3 + 1];
                    float nz = this.temporary.normData[i * 3 + 2];
                    if (!renderer.model.model.legacyObj) {
                        x = -this.temporary.posData[i * 3] + renderer.limb.origin[0];
                        nx *= -1.0f;
                    }
                    builder.func_181662_b((double)x, (double)y, (double)z).func_187315_a((double)u, (double)v).func_181663_c(nx, ny, nz).func_181675_d();
                    if (i % 3 != 2) continue;
                    VertexBuilder.calcTangent((BufferBuilder)builder, (boolean)false);
                }
                Tessellator.func_178181_a().func_78381_a();
            } else {
                GL11.glCallList((int)this.id);
            }
        }
    }
}

