/*
 * Decompiled with CFR 0.152.
 */
package mchorse.blockbuster.client.particles.components.rate;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import mchorse.blockbuster.client.particles.components.BedrockComponentBase;
import mchorse.blockbuster.client.particles.components.IComponentEmitterUpdate;
import mchorse.blockbuster.client.particles.components.rate.BedrockComponentRate;
import mchorse.blockbuster.client.particles.emitter.BedrockEmitter;
import mchorse.mclib.math.Constant;
import mchorse.mclib.math.IValue;
import mchorse.mclib.math.Operation;
import mchorse.mclib.math.molang.MolangException;
import mchorse.mclib.math.molang.MolangParser;
import mchorse.mclib.math.molang.expressions.MolangExpression;
import mchorse.mclib.math.molang.expressions.MolangValue;

public class BedrockComponentRateInstant
extends BedrockComponentRate
implements IComponentEmitterUpdate {
    public static final MolangExpression DEFAULT_PARTICLES = new MolangValue(null, (IValue)new Constant(10.0));

    public BedrockComponentRateInstant() {
        this.particles = DEFAULT_PARTICLES;
    }

    @Override
    public BedrockComponentBase fromJson(JsonElement elem, MolangParser parser) throws MolangException {
        if (!elem.isJsonObject()) {
            return super.fromJson(elem, parser);
        }
        JsonObject element = elem.getAsJsonObject();
        if (element.has("num_particles")) {
            this.particles = parser.parseJson(element.get("num_particles"));
        }
        return super.fromJson((JsonElement)element, parser);
    }

    @Override
    public JsonElement toJson() {
        JsonObject object = new JsonObject();
        if (!MolangExpression.isConstant((MolangExpression)this.particles, (double)10.0)) {
            object.add("num_particles", this.particles.toJson());
        }
        return object;
    }

    @Override
    public void update(BedrockEmitter emitter) {
        double age = emitter.getAge();
        if (emitter.playing && Operation.equals((double)age, (double)0.0)) {
            emitter.setEmitterVariables(0.0f);
            int c = (int)this.particles.get();
            for (int i = 0; i < c; ++i) {
                emitter.spawnParticle();
            }
        }
    }
}

