/*
 * Decompiled with CFR 0.152.
 */
package mchorse.blockbuster.client.render;

import mchorse.blockbuster.Blockbuster;
import mchorse.blockbuster.client.KeyboardHandler;
import mchorse.blockbuster.common.GunProps;
import mchorse.blockbuster.common.item.ItemGun;
import mchorse.blockbuster.network.Dispatcher;
import mchorse.blockbuster.network.common.guns.PacketZoomCommand;
import mchorse.blockbuster.utils.NBTUtils;
import mchorse.metamorph.api.morphs.AbstractMorph;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.util.vector.Vector3f;

@SideOnly(value=Side.CLIENT)
public class GunMiscRender {
    public static float ZOOM_TIME;
    public static float UN_ZOOM_TIME;
    public static boolean onZoom;
    private boolean hasChangedSensitivity = false;
    private boolean hasChangedFov = false;
    private float lastMouseSensitivity;
    private float lastFov;
    public Vector3f translate = new Vector3f();
    public Vector3f scale = new Vector3f(1.0f, 1.0f, 1.0f);
    public Vector3f rotate = new Vector3f();

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onTick(TickEvent.RenderTickEvent event) {
        if (Minecraft.func_71410_x().field_71439_g != null && event.phase.equals((Object)TickEvent.Phase.END)) {
            EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
            ItemStack heldItem = player.func_184586_b(EnumHand.MAIN_HAND);
            GunProps props = NBTUtils.getGunProps(heldItem);
            if (heldItem.func_77973_b().equals(Blockbuster.gunItem)) {
                this.handleZoom(event.renderTickTime);
            }
            if (ZOOM_TIME == 0.0f) {
                if (this.hasChangedFov) {
                    this.hasChangedFov = false;
                    Minecraft.func_71410_x().field_71474_y.field_74334_X = this.lastFov;
                } else {
                    this.lastFov = Minecraft.func_71410_x().field_71474_y.field_74334_X;
                }
                Minecraft.func_71410_x().field_71438_f.func_174979_m();
                if (this.hasChangedSensitivity) {
                    this.hasChangedSensitivity = false;
                    Minecraft.func_71410_x().field_71474_y.field_74341_c = this.lastMouseSensitivity;
                } else {
                    this.lastMouseSensitivity = Minecraft.func_71410_x().field_71474_y.field_74341_c;
                }
            } else if (ZOOM_TIME != 0.0f) {
                if (heldItem.func_77973_b().equals(Blockbuster.gunItem) && KeyboardHandler.zoom.func_151470_d()) {
                    this.hasChangedSensitivity = true;
                    this.hasChangedFov = true;
                    if (props != null) {
                        Minecraft.func_71410_x().field_71474_y.field_74341_c = this.lastMouseSensitivity * props.mouseZoom - 0.3f;
                        Minecraft.func_71410_x().field_71474_y.field_74334_X = this.lastFov - this.lastFov * ZOOM_TIME * props.zoomFactor;
                        Minecraft.func_71410_x().field_71438_f.func_174979_m();
                    }
                } else {
                    this.hasChangedSensitivity = true;
                    this.hasChangedFov = true;
                    Minecraft.func_71410_x().field_71474_y.field_74341_c = this.lastMouseSensitivity;
                    Minecraft.func_71410_x().field_71474_y.field_74334_X = this.lastFov;
                }
            }
        }
    }

    private void handleZoom(float partialTick) {
        boolean zoomed = onZoom;
        if (KeyboardHandler.zoom.func_151470_d()) {
            onZoom = true;
            ZOOM_TIME = Math.min(ZOOM_TIME + partialTick * 0.1f, 1.0f);
            UN_ZOOM_TIME = Math.max(UN_ZOOM_TIME - partialTick * 0.2f, 0.0f);
            if (!zoomed) {
                Dispatcher.sendToServer(new PacketZoomCommand(Minecraft.func_71410_x().field_71439_g.func_145782_y(), true));
            }
        } else {
            onZoom = false;
            ZOOM_TIME = Math.max(ZOOM_TIME - partialTick * 0.1f, 0.0f);
            UN_ZOOM_TIME = Math.min(UN_ZOOM_TIME + partialTick * 0.2f, 1.0f);
            if (zoomed) {
                Dispatcher.sendToServer(new PacketZoomCommand(Minecraft.func_71410_x().field_71439_g.func_145782_y(), false));
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void renderGameOverlay(RenderGameOverlayEvent event) {
        if (event.getType() == RenderGameOverlayEvent.ElementType.CROSSHAIRS) {
            Minecraft mc = Minecraft.func_71410_x();
            ItemStack gun = mc.field_71439_g.func_184614_ca();
            if (gun.func_77973_b() instanceof ItemGun) {
                GunProps props = NBTUtils.getGunProps(gun);
                if (props == null) {
                    return;
                }
                if (props.hideCrosshairOnZoom && KeyboardHandler.zoom.func_151470_d() || !props.currentCrosshair.isEmpty()) {
                    event.setCanceled(true);
                }
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onHUDRender(RenderGameOverlayEvent.Post event) {
        GunProps props;
        EntityPlayerSP player;
        ScaledResolution resolution = event.getResolution();
        if (!(event.getType() != RenderGameOverlayEvent.ElementType.ALL || !((player = Minecraft.func_71410_x().field_71439_g).func_184614_ca().func_77973_b() instanceof ItemGun) || (props = NBTUtils.getGunProps(player.func_184614_ca())) == null || props.crosshairMorph == null || KeyboardHandler.zoom.func_151470_d() && props.hideCrosshairOnZoom)) {
            this.render(props.currentCrosshair.get(), resolution.func_78326_a(), resolution.func_78328_b());
        }
    }

    public void render(AbstractMorph morph, int width, int height) {
        if (morph == null) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)0.5f, (float)0.0f, (float)0.5f);
        this.enableGLStates();
        morph.renderOnScreen((EntityPlayer)mc.field_71439_g, width / 2 + (int)morph.cachedTranslation.x, height / 2 + (int)morph.cachedTranslation.y, 15.0f, 1.0f);
        GlStateManager.func_179121_F();
    }

    private void enableGLStates() {
        RenderHelper.func_74519_b();
        GlStateManager.func_179147_l();
        GlStateManager.func_179141_d();
        GlStateManager.func_179091_B();
        GlStateManager.func_179126_j();
        GlStateManager.func_179129_p();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    static {
        onZoom = true;
    }
}

