/*
 * Decompiled with CFR 0.152.
 */
package mchorse.blockbuster.client.textures;

import at.dhyan.open_imaging.GifDecoder;
import java.util.HashMap;
import java.util.Map;
import mchorse.blockbuster.client.textures.GifFrameTexture;
import mchorse.blockbuster.client.textures.GifTexture;
import mchorse.blockbuster.utils.mclib.GifFolder;
import mchorse.mclib.utils.ReflectionUtils;
import mchorse.mclib.utils.resources.MultiResourceLocation;
import mchorse.mclib.utils.resources.RLUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.ITextureObject;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GifProcessThread
implements Runnable {
    public static final Map<ResourceLocation, GifProcessThread> THREADS = new HashMap<ResourceLocation, GifProcessThread>();
    public ResourceLocation texture;
    public GifFolder gifFile;

    public GifProcessThread(ResourceLocation texture, GifFolder gif) {
        this.texture = texture;
        this.gifFile = gif;
    }

    @Override
    public void run() {
        if (this.texture instanceof MultiResourceLocation) {
            return;
        }
        try {
            ITextureObject old;
            Minecraft mc = Minecraft.func_71410_x();
            GifDecoder.GifImage image = this.gifFile.gif;
            int[] delays = new int[image.getFrameCount()];
            ResourceLocation[] frames = new ResourceLocation[delays.length];
            Map map = ReflectionUtils.getTextures((TextureManager)mc.field_71446_o);
            for (int i = 0; i < delays.length; ++i) {
                delays[i] = image.getDelay(i);
                frames[i] = RLUtils.create((String)this.texture.func_110624_b(), (String)(this.texture.func_110623_a() + ">/frame" + i + ".png"));
                old = (ITextureObject)map.remove(frames[i]);
                if (old != null && old instanceof AbstractTexture) {
                    ((AbstractTexture)old).func_147631_c();
                }
                mc.field_71446_o.func_110579_a(frames[i], (ITextureObject)new GifFrameTexture(this.gifFile, i));
            }
            GifTexture texture = new GifTexture(this.texture, delays, frames);
            old = (ITextureObject)map.remove(this.texture);
            if (old != null && old instanceof AbstractTexture) {
                ((AbstractTexture)old).func_147631_c();
            }
            map.put(this.texture, texture);
            texture.calculateDuration();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void create(ResourceLocation location, GifFolder gif) {
        GifProcessThread thread = new GifProcessThread(location, gif);
        THREADS.put(location, thread);
        thread.run();
        THREADS.remove(location);
    }
}

