/*
 * Decompiled with CFR 0.152.
 */
package mchorse.blockbuster.commands.record;

import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Set;
import mchorse.blockbuster.Blockbuster;
import mchorse.blockbuster.commands.CommandRecord;
import mchorse.blockbuster.commands.record.SubCommandRecordBase;
import mchorse.blockbuster.recording.RecordUtils;
import mchorse.blockbuster.recording.data.Frame;
import mchorse.blockbuster.recording.data.Record;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;

public class SubCommandRecordClean
extends SubCommandRecordBase {
    public static final Set<String> PROPERTIES = ImmutableSet.of((Object)"x", (Object)"y", (Object)"z", (Object)"yaw", (Object)"yaw_head", (Object)"body_yaw", (Object[])new String[]{"pitch", "fall_distance", "sprinting", "sneaking", "active_hands", "mounted", "roll"});

    public static double get(String property, Frame frame) {
        if (property.equals("x")) {
            return frame.x;
        }
        if (property.equals("y")) {
            return frame.y;
        }
        if (property.equals("z")) {
            return frame.z;
        }
        if (property.equals("yaw")) {
            return frame.yaw;
        }
        if (property.equals("yaw_head")) {
            return frame.yawHead;
        }
        if (property.equals("body_yaw")) {
            return frame.bodyYaw;
        }
        if (property.equals("pitch")) {
            return frame.pitch;
        }
        if (property.equals("fall_distance")) {
            return frame.fallDistance;
        }
        if (property.equals("sprinting")) {
            return frame.isSprinting ? 1.0 : 0.0;
        }
        if (property.equals("sneaking")) {
            return frame.isSneaking ? 1.0 : 0.0;
        }
        if (property.equals("active_hands")) {
            return frame.activeHands;
        }
        if (property.equals("mounted")) {
            return frame.isMounted ? 1.0 : 0.0;
        }
        if (property.equals("roll")) {
            return frame.roll;
        }
        return 0.0;
    }

    public static void set(String property, Frame frame, double value) {
        if (property.equals("x")) {
            frame.x = value;
        } else if (property.equals("y")) {
            frame.y = value;
        } else if (property.equals("z")) {
            frame.z = value;
        } else if (property.equals("yaw")) {
            frame.yaw = (float)value;
        } else if (property.equals("yaw_head")) {
            frame.yawHead = (float)value;
        } else if (property.equals("body_yaw")) {
            frame.hasBodyYaw = true;
            frame.bodyYaw = (float)value;
        } else if (property.equals("pitch")) {
            frame.pitch = (float)value;
        } else if (property.equals("fall_distance")) {
            frame.fallDistance = (float)value;
        } else if (property.equals("sprinting")) {
            frame.isSprinting = value == 1.0;
        } else if (property.equals("sneaking")) {
            frame.isSneaking = value == 1.0;
        } else if (property.equals("active_hands")) {
            frame.activeHands = (int)value;
        } else if (property.equals("mounted")) {
            frame.isMounted = value == 1.0;
        } else if (property.equals("roll")) {
            frame.roll = (float)value;
        }
    }

    public String func_71517_b() {
        return "clean";
    }

    public String func_71518_a(ICommandSender sender) {
        return "blockbuster.commands.record.clean";
    }

    public String getSyntax() {
        return "{l}{6}/{r}record {8}clean{r} {7}<filename> <property> [value] [from] [to]{r}";
    }

    @Override
    public int getRequiredArgs() {
        return 2;
    }

    public void executeCommand(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        String filename = args[0];
        String property = args[1];
        Record record = CommandRecord.getRecord(filename);
        if (!PROPERTIES.contains(property)) {
            throw new CommandException("record.wrong_clean_property", new Object[]{property});
        }
        int start = 0;
        int end = record.getLength() - 1;
        if (args.length >= 4) {
            start = CommandBase.func_175764_a((String)args[3], (int)start, (int)end);
        }
        if (args.length >= 5) {
            end = CommandBase.func_175764_a((String)args[4], (int)start, (int)end);
        }
        double original = SubCommandRecordClean.get(property, record.frames.get(start));
        if (args.length >= 3) {
            original = CommandBase.func_175761_b((double)original, (String)args[2], (boolean)false);
        }
        for (int i = start; i <= end; ++i) {
            SubCommandRecordClean.set(property, record.frames.get(i), original);
        }
        try {
            RecordUtils.saveRecord(record);
            Blockbuster.l10n.success(sender, "record.clean", new Object[]{filename, property, start, end});
        }
        catch (Exception e) {
            e.printStackTrace();
            Blockbuster.l10n.error(sender, "record.couldnt_save", new Object[]{args[1]});
        }
    }

    @Override
    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, BlockPos pos) {
        if (args.length == 2) {
            return SubCommandRecordClean.func_175762_a((String[])args, PROPERTIES);
        }
        return super.func_184883_a(server, sender, args, pos);
    }
}

