/*
 * Decompiled with CFR 0.152.
 */
package mchorse.blockbuster.commands.record;

import mchorse.blockbuster.Blockbuster;
import mchorse.blockbuster.CommonProxy;
import mchorse.blockbuster.commands.record.SubCommandRecordBase;
import mchorse.blockbuster.recording.RecordUtils;
import mchorse.blockbuster.recording.data.Frame;
import mchorse.blockbuster.recording.data.Record;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.Vec3d;

public class SubCommandRecordCreate
extends SubCommandRecordBase {
    public String func_71517_b() {
        return "create";
    }

    public String func_71518_a(ICommandSender sender) {
        return "blockbuster.commands.record.create";
    }

    public String getSyntax() {
        return "{l}{6}/{r}record {8}create{r} {7}<filename> <duration> [x] [y] [z] [yaw] [pitch]{r}";
    }

    @Override
    public int getRequiredArgs() {
        return 2;
    }

    public void executeCommand(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        String filename = args[0];
        try {
            Vec3d pos = sender.func_174791_d();
            EntityPlayer player = sender instanceof EntityPlayer ? (EntityPlayer)sender : null;
            int duration = CommandBase.func_175764_a((String)args[1], (int)1, (int)100000);
            float yaw = player == null ? 0.0f : player.field_70177_z;
            float pitch = player == null ? 0.0f : player.field_70125_A;
            double x = args.length >= 3 ? CommandBase.func_175761_b((double)pos.field_72450_a, (String)args[2], (boolean)false) : pos.field_72450_a;
            double y = args.length >= 4 ? CommandBase.func_175761_b((double)pos.field_72448_b, (String)args[3], (boolean)false) : pos.field_72448_b;
            double z = args.length >= 5 ? CommandBase.func_175761_b((double)pos.field_72449_c, (String)args[4], (boolean)false) : pos.field_72449_c;
            yaw = args.length >= 6 ? (float)CommandBase.func_175761_b((double)yaw, (String)args[5], (boolean)false) : yaw;
            pitch = args.length >= 7 ? (float)CommandBase.func_175761_b((double)pitch, (String)args[6], (boolean)false) : pitch;
            Record record = this.generateProfile(player, filename, duration, x, y, z, yaw, pitch);
            CommonProxy.manager.records.put(filename, record);
            RecordUtils.saveRecord(record);
            Blockbuster.l10n.success(sender, "record.create", new Object[]{filename, duration});
        }
        catch (Exception e) {
            e.printStackTrace();
            Blockbuster.l10n.error(sender, "record.couldnt_save", new Object[]{filename});
        }
    }

    private Record generateProfile(EntityPlayer player, String filename, int duration, double x, double y, double z, float yaw, float pitch) {
        Record record = new Record(filename);
        Frame original = new Frame();
        if (player != null) {
            original.fromPlayer(player);
        }
        original.x = x;
        original.y = y;
        original.z = z;
        original.yawHead = original.bodyYaw = yaw;
        original.yaw = original.bodyYaw;
        original.pitch = pitch;
        original.hasBodyYaw = true;
        for (int i = 0; i <= duration; ++i) {
            record.frames.add(original.copy());
            record.actions.add(null);
        }
        return record;
    }
}

