/*
 * Decompiled with CFR 0.152.
 */
package mchorse.blockbuster.commands.record;

import java.util.List;
import mchorse.blockbuster.Blockbuster;
import mchorse.blockbuster.commands.CommandRecord;
import mchorse.blockbuster.commands.record.SubCommandRecordBase;
import mchorse.blockbuster.recording.actions.Action;
import mchorse.blockbuster.recording.actions.ActionRegistry;
import mchorse.blockbuster.recording.data.Record;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;

public class SubCommandRecordGet
extends SubCommandRecordBase {
    public String func_71517_b() {
        return "get";
    }

    public String func_71518_a(ICommandSender sender) {
        return "blockbuster.commands.record.get";
    }

    public String getSyntax() {
        return "{l}{6}/{r}record {8}get{r} {7}<filename> <tick>{r}";
    }

    @Override
    public int getRequiredArgs() {
        return 2;
    }

    public void executeCommand(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        String filename = args[0];
        int tick = CommandBase.func_180528_a((String)args[1], (int)0);
        Record record = CommandRecord.getRecord(filename);
        if (tick <= 0 || tick >= record.actions.size()) {
            throw new CommandException("record.tick_out_range", new Object[]{tick, record.actions.size() - 1});
        }
        List<Action> actions = record.actions.get(tick);
        if (actions == null) {
            throw new CommandException("record.no_action", new Object[]{filename, tick});
        }
        int c = actions.size();
        for (int i = 0; i < c; ++i) {
            Action action = actions.get(i);
            NBTTagCompound tag = new NBTTagCompound();
            String type = (String)ActionRegistry.NAME_TO_CLASS.inverse().get(action.getClass());
            action.toNBT(tag);
            Blockbuster.l10n.info(sender, "record.action", new Object[]{tick, type, i, tag.toString()});
        }
    }
}

