/*
 * Decompiled with CFR 0.152.
 */
package mchorse.blockbuster.commands.record;

import java.util.List;
import mchorse.blockbuster.Blockbuster;
import mchorse.blockbuster.commands.CommandRecord;
import mchorse.blockbuster.commands.record.SubCommandRecordBase;
import mchorse.blockbuster.commands.record.SubCommandRecordClean;
import mchorse.blockbuster.recording.RecordUtils;
import mchorse.blockbuster.recording.data.Frame;
import mchorse.blockbuster.recording.data.Record;
import mchorse.mclib.commands.SubCommandBase;
import mchorse.mclib.math.IValue;
import mchorse.mclib.math.MathBuilder;
import mchorse.mclib.math.Variable;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;

public class SubCommandRecordProcess
extends SubCommandRecordBase {
    public MathBuilder builder = new MathBuilder();
    public Variable initial = new Variable("initial", 0.0);
    public Variable value;
    public Variable tick;
    public Variable from;
    public Variable to;
    public Variable factor;

    public SubCommandRecordProcess() {
        this.builder.register(this.initial);
        this.value = new Variable("value", 0.0);
        this.builder.register(this.value);
        this.tick = new Variable("tick", 0.0);
        this.builder.register(this.tick);
        this.from = new Variable("from", 0.0);
        this.builder.register(this.from);
        this.to = new Variable("to", 0.0);
        this.builder.register(this.to);
        this.factor = new Variable("factor", 0.0);
        this.builder.register(this.factor);
    }

    public String func_71517_b() {
        return "process";
    }

    public String func_71518_a(ICommandSender sender) {
        return "blockbuster.commands.record.process";
    }

    public String getSyntax() {
        return "{l}{6}/{r}record {8}process{r} {7}<filename> <property> <from> <to> <math>{r}";
    }

    @Override
    public int getRequiredArgs() {
        return 5;
    }

    public void executeCommand(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        IValue math;
        String filename = args[0];
        String property = args[1];
        Record record = CommandRecord.getRecord(filename);
        if (!SubCommandRecordClean.PROPERTIES.contains(property)) {
            throw new CommandException("record.wrong_clean_property", new Object[]{property});
        }
        int start = 0;
        int end = record.getLength() - 1;
        start = CommandBase.func_175764_a((String)args[2], (int)start, (int)end);
        end = CommandBase.func_175764_a((String)args[3], (int)start, (int)end);
        double initial = SubCommandRecordClean.get(property, record.frames.get(start));
        String expression = String.join((CharSequence)" ", SubCommandBase.dropFirstArguments((String[])args, (int)4));
        try {
            math = this.builder.parse(expression);
        }
        catch (Exception e) {
            throw new CommandException("record.invalid_math_expression", new Object[]{expression});
        }
        this.from.set((double)start);
        this.to.set((double)end);
        for (int i = start; i <= end; ++i) {
            Frame frame = record.frames.get(i);
            this.initial.set(initial);
            this.value.set(SubCommandRecordClean.get(property, frame));
            this.tick.set((double)i);
            this.factor.set((double)(i - start) / (double)(end - start));
            SubCommandRecordClean.set(property, frame, math.get().doubleValue());
        }
        try {
            RecordUtils.saveRecord(record);
            Blockbuster.l10n.success(sender, "record.process", new Object[]{filename, property, start, end});
        }
        catch (Exception e) {
            e.printStackTrace();
            Blockbuster.l10n.error(sender, "record.couldnt_save", new Object[]{args[1]});
        }
    }

    @Override
    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, BlockPos pos) {
        if (args.length == 2) {
            return SubCommandRecordProcess.func_175762_a((String[])args, SubCommandRecordClean.PROPERTIES);
        }
        return super.func_184883_a(server, sender, args, pos);
    }
}

