/*
 * Decompiled with CFR 0.152.
 */
package mchorse.blockbuster.commands.record;

import java.util.List;
import java.util.function.Consumer;
import mchorse.blockbuster.commands.CommandRecord;
import mchorse.blockbuster.commands.record.SubCommandRecordBase;
import mchorse.blockbuster.recording.actions.Action;
import mchorse.blockbuster.recording.data.Record;
import mchorse.mclib.client.gui.utils.keys.IKey;
import mchorse.mclib.network.mclib.Dispatcher;
import mchorse.mclib.network.mclib.client.ClientHandlerConfirm;
import mchorse.mclib.network.mclib.common.PacketConfirm;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class SubCommandRecordRemove
extends SubCommandRecordBase {
    public String func_71517_b() {
        return "remove";
    }

    public String func_71518_a(ICommandSender sender) {
        return "blockbuster.commands.record.remove";
    }

    public String getSyntax() {
        return "{l}{6}/{r}record {8}remove{r} {7}<filename> <tick> [index] [force]{r}";
    }

    @Override
    public int getRequiredArgs() {
        return 2;
    }

    public void executeCommand(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        String filename = args[0];
        int tick = CommandBase.func_180528_a((String)args[1], (int)0);
        Record record = CommandRecord.getRecord(filename);
        if (tick < 0 || tick >= record.actions.size()) {
            throw new CommandException("record.tick_out_range", new Object[]{tick, record.actions.size() - 1});
        }
        this.removeActions(args, sender, record, tick);
    }

    private void removeActions(String[] args, ICommandSender sender, Record record, int tick) throws CommandException {
        boolean force;
        EntityPlayerMP player = SubCommandRecordRemove.func_71521_c((ICommandSender)sender);
        boolean bl = force = args.length > 3 ? CommandBase.func_180527_d((String)args[3]) : false;
        if (args.length > 2 && CommandBase.func_175755_a((String)args[2]) != -1) {
            int index = CommandBase.func_175755_a((String)args[2]);
            List<Action> actions = record.actions.get(tick);
            if (actions == null) {
                throw new CommandException("record.already_empty", new Object[]{args[1], args[0]});
            }
            if (index < -1 || index >= actions.size()) {
                throw new CommandException("record.index_out_range", new Object[]{index, actions.size() - 1});
            }
            this.dispatchConfirm(player, force, value -> {
                if (value.booleanValue()) {
                    if (actions.size() <= 1) {
                        record.actions.set(tick, null);
                    } else {
                        actions.remove(index);
                    }
                }
            });
        } else {
            this.dispatchConfirm(player, force, value -> {
                if (value.booleanValue()) {
                    record.actions.set(tick, null);
                }
            });
        }
        record.dirty = true;
    }

    private void dispatchConfirm(EntityPlayerMP player, boolean force, Consumer<Boolean> callback) {
        if (force) {
            callback.accept(force);
        } else {
            Dispatcher.sendTo((IMessage)new PacketConfirm(ClientHandlerConfirm.GUI.MCSCREEN, IKey.lang((String)"blockbuster.commands.record.remove_modal"), value -> callback.accept((Boolean)value)), (EntityPlayerMP)player);
        }
    }
}

