/*
 * Decompiled with CFR 0.152.
 */
package mchorse.blockbuster.commands.record;

import java.io.File;
import java.util.List;
import mchorse.blockbuster.Blockbuster;
import mchorse.blockbuster.CommonProxy;
import mchorse.blockbuster.commands.CommandRecord;
import mchorse.blockbuster.commands.record.SubCommandRecordBase;
import mchorse.blockbuster.recording.RecordUtils;
import mchorse.blockbuster.recording.data.Record;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;

public class SubCommandRecordRestore
extends SubCommandRecordBase {
    public String func_71517_b() {
        return "restore";
    }

    public String func_71518_a(ICommandSender sender) {
        return "blockbuster.commands.record.restore";
    }

    public String getSyntax() {
        return "{l}{6}/{r}record {8}restore{r} {7}<filename> <iteration>{r}";
    }

    @Override
    public int getRequiredArgs() {
        return 2;
    }

    public void executeCommand(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        String name = args[0];
        String iteration = args[1];
        Record record = CommandRecord.getRecord(name);
        if (RecordUtils.getReplayIterations(record.filename).contains(iteration)) {
            File current = RecordUtils.replayFile(name);
            File toRestore = new File(RecordUtils.replayFile(name).getAbsolutePath() + "~" + iteration);
            File temporary = RecordUtils.replayFile("mchorse is the coolest");
            if (temporary.exists()) {
                Blockbuster.l10n.error(sender, "record.cant_restore", new Object[]{name});
            } else {
                current.renameTo(temporary);
                toRestore.renameTo(current);
                temporary.renameTo(toRestore);
                CommonProxy.manager.records.remove(record.filename);
                RecordUtils.unloadRecord(record);
                Blockbuster.l10n.success(sender, "record.restored", new Object[]{name, iteration});
            }
        } else {
            Blockbuster.l10n.error(sender, "record.not_exist_iteration", new Object[]{name, iteration});
        }
    }

    @Override
    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, BlockPos pos) {
        List<String> iterations;
        if (args.length == 2 && !(iterations = RecordUtils.getReplayIterations(args[0])).isEmpty()) {
            return SubCommandRecordRestore.func_175762_a((String[])args, iterations);
        }
        return super.func_184883_a(server, sender, args, pos);
    }
}

