/*
 * Decompiled with CFR 0.152.
 */
package mchorse.blockbuster.common.block;

import java.util.List;
import mchorse.blockbuster.Blockbuster;
import mchorse.blockbuster.common.BlockbusterPermissions;
import mchorse.blockbuster.common.GuiHandler;
import mchorse.blockbuster.common.tileentity.TileEntityModel;
import mchorse.blockbuster.recording.capturing.ActionHandler;
import mchorse.mclib.permissions.PermissionCategory;
import mchorse.mclib.permissions.PermissionUtils;
import mchorse.mclib.utils.EntityUtils;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockModel
extends Block
implements ITileEntityProvider {
    public static final PropertyInteger LIGHT = PropertyInteger.func_177719_a((String)"light", (int)0, (int)15);
    private float lastYaw;

    public BlockModel() {
        super(Material.field_151576_e);
        this.func_149647_a(Blockbuster.blockbusterTab);
        this.func_149752_b(6000000.0f);
        this.setRegistryName("model");
        this.func_149663_c("blockbuster.model");
        this.func_180632_j(this.func_176223_P().func_177226_a((IProperty)LIGHT, (Comparable)Integer.valueOf(0)));
    }

    public static ItemStack getItemStack(int meta) {
        Item modelBlockItem = Blockbuster.modelBlockItems[0];
        if (meta >= 0 && meta <= 15) {
            modelBlockItem = Blockbuster.modelBlockItems[meta];
        }
        return new ItemStack(modelBlockItem, 1);
    }

    public ItemStack getItemStack(IBlockState state) {
        int meta = this.func_180651_a(state);
        return BlockModel.getItemStack(meta);
    }

    public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
        return (Integer)state.func_177229_b((IProperty)LIGHT);
    }

    public ItemStack func_185473_a(World worldIn, BlockPos pos, IBlockState state) {
        ItemStack stack = this.getItemStack(state);
        TileEntityModel model = new TileEntityModel();
        model.getSettings().setLightValue(this.func_180651_a(state));
        this.setTENBTtoStack(stack, model);
        return stack;
    }

    public int func_180651_a(IBlockState state) {
        return this.func_176201_c(state);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{LIGHT});
    }

    public int func_176201_c(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)LIGHT);
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)LIGHT, (Comparable)Integer.valueOf(meta));
    }

    @SideOnly(value=Side.CLIENT)
    public void func_190948_a(ItemStack stack, World player, List<String> tooltip, ITooltipFlag advanced) {
        tooltip.add(I18n.func_135052_a((String)"blockbuster.info.model_block", (Object[])new Object[0]));
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        ItemStack stack = this.getItemStack(state);
        TileEntity te = ActionHandler.lastTE;
        if (te instanceof TileEntityModel) {
            TileEntityModel model = (TileEntityModel)te;
            this.setTENBTtoStack(stack, model);
        }
        drops.add((Object)stack);
    }

    public ItemStack setTENBTtoStack(ItemStack stack, TileEntityModel teModel) {
        NBTTagCompound tag = teModel.func_189515_b(new NBTTagCompound());
        NBTTagCompound block = new NBTTagCompound();
        tag.func_82580_o("x");
        tag.func_82580_o("y");
        tag.func_82580_o("z");
        block.func_74782_a("BlockEntityTag", (NBTBase)tag);
        if (!(tag.func_186856_d() == 2 && tag.func_74764_b("id") && tag.func_74764_b("Morph") && tag.func_74781_a("Morph").equals((Object)TileEntityModel.getDefaultMorph().toNBT()))) {
            stack.func_77982_d(block);
        }
        return stack;
    }

    public boolean addDestroyEffects(World world, BlockPos pos, ParticleManager manager) {
        return true;
    }

    public boolean canHarvestBlock(IBlockAccess world, BlockPos pos, EntityPlayer player) {
        return true;
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (worldIn.field_72995_K && !EntityUtils.isAdventureMode((EntityPlayer)playerIn)) {
            PermissionUtils.hasPermission((EntityPlayer)playerIn, (PermissionCategory)BlockbusterPermissions.editModelBlock, bool -> {
                if (bool.booleanValue()) {
                    GuiHandler.open(playerIn, 3, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
                }
            });
        }
        return true;
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        this.lastYaw = placer.func_70093_af() ? MathHelper.func_76142_g((float)(180.0f - placer.field_70177_z)) : 0.0f;
        return super.getStateForPlacement(world, pos, facing, hitX, hitY, hitZ, meta, placer, hand);
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        TileEntity tileEntity;
        if (world.field_72995_K && stack.func_77942_o() && this.hasTileEntity(state) && stack.func_77978_p().func_74764_b("BlockEntityTag") && (tileEntity = world.func_175625_s(pos)) != null) {
            tileEntity.handleUpdateTag(stack.func_77978_p().func_74775_l("BlockEntityTag"));
        }
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        TileEntityModel entity = new TileEntityModel(this.lastYaw);
        this.lastYaw = 0.0f;
        return entity;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_181623_g() {
        return true;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.ENTITYBLOCK_ANIMATED;
    }

    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        TileEntity te = worldIn.func_175625_s(pos);
        if (te instanceof TileEntityModel && ((TileEntityModel)te).getSettings().isBlockHitbox()) {
            return super.func_180646_a(blockState, worldIn, pos);
        }
        return null;
    }
}

