/*
 * Decompiled with CFR 0.152.
 */
package mchorse.blockbuster.common.entity;

import io.netty.buffer.ByteBuf;
import java.util.List;
import mchorse.blockbuster.Blockbuster;
import mchorse.blockbuster.common.GunProps;
import mchorse.blockbuster.common.entity.EntityActor;
import mchorse.blockbuster.network.Dispatcher;
import mchorse.blockbuster.network.common.guns.PacketGunProjectile;
import mchorse.blockbuster.network.common.guns.PacketGunProjectileVanish;
import mchorse.blockbuster.network.common.guns.PacketGunStuck;
import mchorse.mclib.utils.NBTUtils;
import mchorse.metamorph.api.Morph;
import mchorse.metamorph.api.MorphUtils;
import mchorse.metamorph.api.morphs.AbstractMorph;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityGunProjectile
extends EntityThrowable
implements IEntityAdditionalSpawnData {
    public GunProps props;
    public AbstractMorph original;
    public Morph morph = new Morph();
    public int hits;
    public int impact;
    public boolean vanish;
    public int vanishDelay;
    public boolean stuck;
    public int updatePos;
    public double targetX;
    public double targetY;
    public double targetZ;
    public double initMX;
    public double initMY;
    public double initMZ;
    public boolean setInit;

    public EntityGunProjectile(World worldIn) {
        this(worldIn, null, null);
    }

    public EntityGunProjectile(World worldIn, GunProps props, AbstractMorph morph) {
        super(worldIn);
        this.props = props;
        this.morph.setDirect(morph);
        this.original = this.morph.copy();
        if (props != null) {
            this.func_70105_a(props.hitboxX, props.hitboxY);
        }
        this.impact = -1;
    }

    public void func_184538_a(Entity entityThrower, float rotationPitchIn, float rotationYawIn, float pitchOffset, float velocity, float inaccuracy) {
        if (entityThrower instanceof EntityActor.EntityFakePlayer) {
            this.field_70192_c = ((EntityActor.EntityFakePlayer)entityThrower).actor;
        } else if (entityThrower instanceof EntityLivingBase) {
            this.field_70192_c = (EntityLivingBase)entityThrower;
        }
        super.func_184538_a(entityThrower, rotationPitchIn, rotationYawIn, pitchOffset, velocity, inaccuracy);
    }

    public void setInitialMotion() {
        this.initMX = this.field_70159_w;
        this.initMY = this.field_70181_x;
        this.initMZ = this.field_70179_y;
    }

    public void func_70071_h_() {
        if (this.vanish) {
            if (!this.field_70170_p.field_72995_K && this.vanishDelay <= 0) {
                this.func_70106_y();
            }
            if (this.vanishDelay > 0) {
                --this.vanishDelay;
            }
        }
        if (!this.field_70170_p.func_175668_a(this.func_180425_c(), false)) {
            this.func_70106_y();
        }
        this.field_70142_S = this.field_70165_t;
        this.field_70137_T = this.field_70163_u;
        this.field_70136_U = this.field_70161_v;
        if (!this.field_70170_p.field_72995_K) {
            this.func_70052_a(6, this.func_184202_aL());
        } else if (!this.setInit) {
            this.setInit = true;
            this.field_70159_w = this.initMX;
            this.field_70181_x = this.initMY;
            this.field_70179_y = this.initMZ;
        }
        this.func_70030_z();
        if (!this.stuck) {
            float friction;
            Vec3d position = new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v);
            Vec3d next = new Vec3d(this.field_70165_t + this.field_70159_w, this.field_70163_u + this.field_70181_x, this.field_70161_v + this.field_70179_y);
            Entity entity = null;
            RayTraceResult result = this.field_70170_p.func_147447_a(position, next, false, true, false);
            if (result != null) {
                next = new Vec3d(result.field_72307_f.field_72450_a, result.field_72307_f.field_72448_b, result.field_72307_f.field_72449_c);
            }
            if (!this.props.ignoreEntities) {
                List list = this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ().func_72321_a(this.field_70159_w, this.field_70181_x, this.field_70179_y).func_186662_g(1.0));
                double dist = 0.0;
                for (int i = 0; i < list.size(); ++i) {
                    AxisAlignedBB box;
                    RayTraceResult ray;
                    Entity current = (Entity)list.get(i);
                    if (!current.func_70067_L() || (ray = (box = current.func_174813_aQ().func_186662_g((double)0.3f)).func_72327_a(position, next)) == null) continue;
                    double d1 = position.func_72436_e(ray.field_72307_f);
                    if (current instanceof EntityGunProjectile || current == this.field_70192_c || !(d1 < dist) && dist != 0.0) continue;
                    entity = current;
                    dist = d1;
                }
            }
            if (entity != null) {
                result = new RayTraceResult(entity);
            }
            this.field_70165_t += this.field_70159_w;
            this.field_70163_u += this.field_70181_x;
            this.field_70161_v += this.field_70179_y;
            if (result != null) {
                if (result.field_72313_a == RayTraceResult.Type.BLOCK && this.field_70170_p.func_180495_p(result.func_178782_a()).func_177230_c() == Blocks.field_150427_aO) {
                    this.func_181015_d(result.func_178782_a());
                } else if (!ForgeHooks.onThrowableImpact((EntityThrowable)this, (RayTraceResult)result)) {
                    this.func_70184_a(result);
                }
            }
            float distance = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y));
            this.field_70177_z = (float)(MathHelper.func_181159_b((double)this.field_70159_w, (double)this.field_70179_y) * 57.29577951308232);
            this.field_70125_A = (float)(MathHelper.func_181159_b((double)this.field_70181_x, (double)distance) * 57.29577951308232);
            while (this.field_70125_A - this.field_70127_C < -180.0f) {
                this.field_70127_C -= 360.0f;
            }
            while (this.field_70125_A - this.field_70127_C >= 180.0f) {
                this.field_70127_C += 360.0f;
            }
            while (this.field_70177_z - this.field_70126_B < -180.0f) {
                this.field_70126_B -= 360.0f;
            }
            while (this.field_70177_z - this.field_70126_B >= 180.0f) {
                this.field_70126_B += 360.0f;
            }
            this.field_70125_A = this.field_70127_C + (this.field_70125_A - this.field_70127_C) * 0.2f;
            this.field_70177_z = this.field_70126_B + (this.field_70177_z - this.field_70126_B) * 0.2f;
            float f = friction = this.props == null ? 1.0f : this.props.friction;
            if (this.func_70090_H()) {
                for (int j = 0; j < 4; ++j) {
                    this.field_70170_p.func_175688_a(EnumParticleTypes.WATER_BUBBLE, this.field_70165_t - this.field_70159_w * 0.25, this.field_70163_u - this.field_70181_x * 0.25, this.field_70161_v - this.field_70179_y * 0.25, this.field_70159_w, this.field_70181_x, this.field_70179_y, new int[0]);
                }
                friction *= 0.8f;
            }
            if (this.field_70122_E) {
                friction *= 0.9f;
            }
            this.field_70159_w *= (double)friction;
            this.field_70181_x *= (double)friction;
            this.field_70179_y *= (double)friction;
            if (!this.func_189652_ae()) {
                this.field_70181_x -= (double)this.func_70185_h();
            }
            if (this.hits < this.props.hits) {
                double diff = this.field_70159_w * this.field_70159_w + this.field_70181_x * this.field_70181_x + this.field_70179_y * this.field_70179_y;
                if (diff < 10000.0) {
                    this.field_70145_X = this.props.ignoreBlocks;
                    this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
                } else {
                    this.func_70106_y();
                }
            } else {
                this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
            }
        }
        this.updateProjectile();
    }

    private void updateProjectile() {
        AbstractMorph morph;
        if (this.field_70170_p.field_72995_K && this.updatePos > 0) {
            double d0 = this.field_70165_t + (this.targetX - this.field_70165_t) / (double)this.updatePos;
            double d1 = this.field_70163_u + (this.targetY - this.field_70163_u) / (double)this.updatePos;
            double d2 = this.field_70161_v + (this.targetZ - this.field_70161_v) / (double)this.updatePos;
            --this.updatePos;
            this.func_70107_b(d0, d1, d2);
        }
        if ((morph = this.morph.get()) != null) {
            this.props.createEntity(this.field_70170_p);
            this.props.target.field_70165_t = this.field_70165_t;
            this.props.target.field_70163_u = this.field_70163_u;
            this.props.target.field_70161_v = this.field_70161_v;
            morph.update(this.props.getEntity(this));
        }
        if (this.props == null || this.field_70170_p.field_72995_K) {
            return;
        }
        if (this.field_70173_aa > this.props.lifeSpan) {
            this.func_70106_y();
            if (!this.props.vanishCommand.isEmpty()) {
                this.func_184102_h().field_71321_q.func_71556_a((ICommandSender)this, this.props.vanishCommand);
            }
        }
        if (this.props.ticking > 0 && this.field_70173_aa % this.props.ticking == 0 && !this.props.tickCommand.isEmpty()) {
            this.func_184102_h().field_71321_q.func_71556_a((ICommandSender)this, this.props.tickCommand);
        }
        if (this.impact >= 0) {
            if (this.impact == 0) {
                AbstractMorph original = MorphUtils.copy((AbstractMorph)this.original);
                this.morph.set(original);
                Dispatcher.sendToTracked((Entity)this, new PacketGunProjectile(this.func_145782_y(), original));
            }
            --this.impact;
        }
    }

    protected void func_70184_a(RayTraceResult result) {
        if (this.stuck || this.vanish || this.props == null) {
            return;
        }
        ++this.hits;
        boolean shouldDie = this.props.vanish && this.hits >= this.props.hits && !this.props.sticks;
        boolean impactMorph = false;
        if (result.field_72313_a == RayTraceResult.Type.BLOCK && !this.props.ignoreBlocks) {
            EnumFacing.Axis axis = result.field_178784_b.func_176740_k();
            float factor = this.props.bounce && this.hits <= this.props.hits ? -1 : 0;
            if (axis == EnumFacing.Axis.X) {
                this.field_70159_w *= (double)factor;
            }
            if (axis == EnumFacing.Axis.Y) {
                this.field_70181_x *= (double)factor;
            }
            if (axis == EnumFacing.Axis.Z) {
                this.field_70179_y *= (double)factor;
            }
            this.field_70159_w *= (double)this.props.bounceFactor;
            this.field_70181_x *= (double)this.props.bounceFactor;
            this.field_70179_y *= (double)this.props.bounceFactor;
            this.field_70165_t = result.field_72307_f.field_72450_a + (double)(this.field_70130_N / 2.0f * (float)result.field_178784_b.func_82601_c());
            this.field_70163_u = result.field_72307_f.field_72448_b - (double)(this.field_70131_O * (float)(result.field_178784_b == EnumFacing.DOWN ? 1 : 0));
            this.field_70161_v = result.field_72307_f.field_72449_c + (double)(this.field_70130_N / 2.0f * (float)result.field_178784_b.func_82599_e());
            if (this.props.sticks) {
                this.stuck = true;
                if (!this.field_70170_p.field_72995_K) {
                    if (result.field_178784_b == EnumFacing.WEST || result.field_178784_b == EnumFacing.EAST) {
                        this.field_70165_t += (double)(this.props.penetration * (float)result.field_178784_b.func_82601_c());
                    } else if (result.field_178784_b == EnumFacing.UP || result.field_178784_b == EnumFacing.DOWN) {
                        this.field_70163_u += (double)(this.props.penetration * (float)result.field_178784_b.func_96559_d());
                    } else if (result.field_178784_b == EnumFacing.NORTH || result.field_178784_b == EnumFacing.SOUTH) {
                        this.field_70161_v += (double)(this.props.penetration * (float)result.field_178784_b.func_82599_e());
                    }
                    Dispatcher.sendToTracked((Entity)this, new PacketGunStuck(this.func_145782_y(), (float)this.field_70165_t, (float)this.field_70163_u, (float)this.field_70161_v));
                }
            }
        }
        if (!this.field_70170_p.field_72995_K) {
            if (result.field_72313_a == RayTraceResult.Type.BLOCK && !this.props.ignoreBlocks) {
                if (!this.props.impactCommand.isEmpty()) {
                    String command = this.props.impactCommand;
                    int x = Math.round((float)this.field_70165_t);
                    int y = Math.round((float)this.field_70163_u);
                    int z = Math.round((float)this.field_70161_v);
                    if (result.field_72313_a == RayTraceResult.Type.BLOCK) {
                        x = result.func_178782_a().func_177958_n();
                        y = result.func_178782_a().func_177956_o();
                        z = result.func_178782_a().func_177952_p();
                    }
                    command = command.replaceAll("\\$\\{x\\}", String.valueOf(x));
                    command = command.replaceAll("\\$\\{y\\}", String.valueOf(y));
                    command = command.replaceAll("\\$\\{z\\}", String.valueOf(z));
                    if (this.func_184102_h() != null) {
                        this.func_184102_h().field_71321_q.func_71556_a((ICommandSender)this, command);
                    }
                }
                impactMorph = true;
            }
            if (result.field_72313_a == RayTraceResult.Type.ENTITY && !this.props.ignoreEntities) {
                if (!this.props.impactEntityCommand.isEmpty()) {
                    this.func_184102_h().field_71321_q.func_71556_a((ICommandSender)this, this.props.impactEntityCommand);
                }
                if (this.props.damage > 0.0f) {
                    if (result.field_72308_g instanceof EntityLiving) {
                        EntityLiving living = (EntityLiving)result.field_72308_g;
                        result.field_72308_g.func_70097_a(DamageSource.func_76356_a((Entity)this, null), 0.0f);
                        living.func_70606_j(living.func_110143_aJ() - this.props.damage);
                    } else {
                        result.field_72308_g.func_70097_a(DamageSource.func_76356_a((Entity)this, null), this.props.damage);
                    }
                }
                if (this.props.knockbackHorizontal != 0.0f && result.field_72308_g instanceof EntityLivingBase) {
                    ((EntityLivingBase)result.field_72308_g).func_70653_a((Entity)this, Math.abs(this.props.knockbackHorizontal), -this.field_70159_w, -this.field_70179_y);
                    if (this.props.knockbackHorizontal < 0.0f) {
                        result.field_72308_g.field_70159_w *= -1.0;
                        result.field_72308_g.field_70179_y *= -1.0;
                    }
                }
                result.field_72308_g.field_70181_x += (double)this.props.knockbackVertical;
                impactMorph = true;
            }
            if (shouldDie) {
                this.vanish = true;
                this.vanishDelay = this.props.vanishDelay;
                if (this.vanishDelay > 0) {
                    Dispatcher.sendToTracked((Entity)this, new PacketGunProjectileVanish(this.func_145782_y(), this.vanishDelay));
                }
                return;
            }
            if (impactMorph && this.props.impactDelay > 0) {
                AbstractMorph morph = MorphUtils.copy((AbstractMorph)this.props.impactMorph);
                this.morph.set(morph);
                this.impact = this.props.impactDelay;
                Dispatcher.sendToTracked((Entity)this, new PacketGunProjectile(this.func_145782_y(), morph));
            }
        }
    }

    protected float func_70185_h() {
        return this.props == null ? super.func_70185_h() : this.props.gravity;
    }

    public void writeSpawnData(ByteBuf buffer) {
        buffer.writeBoolean(this.props != null);
        if (this.props != null) {
            ByteBufUtils.writeTag((ByteBuf)buffer, (NBTTagCompound)this.props.toNBT());
        }
        buffer.writeBoolean(this.morph.get() != null);
        if (this.morph.get() != null) {
            ByteBufUtils.writeTag((ByteBuf)buffer, (NBTTagCompound)this.morph.toNBT());
        }
        buffer.writeDouble(this.initMX);
        buffer.writeDouble(this.initMY);
        buffer.writeDouble(this.initMZ);
    }

    public void readSpawnData(ByteBuf additionalData) {
        if (additionalData.readBoolean()) {
            this.props = new GunProps(NBTUtils.readInfiniteTag((ByteBuf)additionalData));
            this.func_70105_a(this.props.hitboxX, this.props.hitboxY);
        }
        if (additionalData.readBoolean()) {
            this.morph.fromNBT(NBTUtils.readInfiniteTag((ByteBuf)additionalData));
        }
        this.initMX = additionalData.readDouble();
        this.initMY = additionalData.readDouble();
        this.initMZ = additionalData.readDouble();
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.func_70106_y();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180426_a(double x, double y, double z, float yaw, float pitch, int posRotationIncrements, boolean teleport) {
        if (this.stuck) {
            return;
        }
        double dx = this.field_70165_t - x;
        double dy = this.field_70163_u - y;
        double dz = this.field_70161_v - z;
        double dist = dx * dx + dy * dy + dz * dz;
        double syncDistance = ((Float)Blockbuster.bbGunSyncDistance.get()).floatValue();
        if (syncDistance > 0.0 && dist > syncDistance * syncDistance) {
            this.updatePos = posRotationIncrements;
            this.targetX = x;
            this.targetY = y;
            this.targetZ = z;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_70112_a(double distance) {
        double d0 = ((Integer)Blockbuster.actorRenderingRange.get()).intValue();
        return distance < d0 * d0;
    }
}

