/*
 * Decompiled with CFR 0.152.
 */
package mchorse.blockbuster.common.tileentity;

import io.netty.buffer.ByteBuf;
import javax.vecmath.Vector3d;
import mchorse.blockbuster.Blockbuster;
import mchorse.blockbuster.client.RenderingHandler;
import mchorse.blockbuster.client.render.IRenderLast;
import mchorse.blockbuster.common.entity.EntityActor;
import mchorse.blockbuster.common.tileentity.TileEntityModelSettings;
import mchorse.blockbuster.network.Dispatcher;
import mchorse.blockbuster.network.common.PacketModifyModelBlock;
import mchorse.blockbuster.recording.scene.Scene;
import mchorse.mclib.network.IByteBufSerializable;
import mchorse.metamorph.api.Morph;
import mchorse.metamorph.api.MorphManager;
import mchorse.metamorph.api.MorphUtils;
import mchorse.metamorph.api.morphs.AbstractMorph;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityModel
extends TileEntity
implements ITickable,
IRenderLast,
IByteBufSerializable {
    private static AbstractMorph DEFAULT_MORPH;
    public Morph morph = new Morph();
    public EntityLivingBase entity;
    private long lastModelUpdate;
    private TileEntityModelSettings settings = new TileEntityModelSettings();

    public TileEntityModel() {
        this.morph.setDirect(MorphUtils.copy((AbstractMorph)TileEntityModel.getDefaultMorph()));
        this.lastModelUpdate = Scene.lastUpdate;
    }

    public TileEntityModel(float yaw) {
        this();
        this.settings.setRy(yaw);
    }

    public TileEntityModelSettings getSettings() {
        return this.settings;
    }

    public static AbstractMorph getDefaultMorph() {
        return DEFAULT_MORPH;
    }

    @Override
    public Vector3d getRenderLastPos() {
        BlockPos blockPos = this.func_174877_v();
        return new Vector3d((double)((float)blockPos.func_177958_n() + this.settings.getX()), (double)((float)blockPos.func_177956_o() + this.settings.getY()), (double)((float)blockPos.func_177952_p() + this.settings.getZ()));
    }

    public boolean shouldRenderInPass(int pass) {
        return super.shouldRenderInPass(pass) && (!this.settings.isRenderLast() || !RenderingHandler.addRenderLast(this));
    }

    public void setMorph(AbstractMorph morph) {
        this.morph.set(morph);
        this.func_70296_d();
    }

    public void createEntity(World world) {
        if (world == null) {
            return;
        }
        this.entity = new EntityActor(world);
        this.entity.field_70122_E = true;
        this.updateEntity();
    }

    public void updateEntity() {
        if (this.entity == null) {
            return;
        }
        for (int i = 0; i < this.settings.getSlots().length; ++i) {
            this.entity.func_184201_a(EntityEquipmentSlot.values()[i], this.settings.getSlots()[i]);
        }
        this.entity.field_70165_t = (double)((float)this.field_174879_c.func_177958_n() + this.settings.getX()) + 0.5;
        this.entity.field_70163_u = (float)this.field_174879_c.func_177956_o() + this.settings.getY();
        this.entity.field_70161_v = (double)((float)this.field_174879_c.func_177952_p() + this.settings.getZ()) + 0.5;
    }

    public void func_73660_a() {
        if (this.entity == null) {
            this.createEntity(this.field_145850_b);
        }
        if (this.entity != null && this.settings.isEnabled()) {
            ++this.entity.field_70173_aa;
            this.entity.field_70165_t = (double)((float)this.field_174879_c.func_177958_n() + this.settings.getX()) + 0.5;
            this.entity.field_70163_u = (float)this.field_174879_c.func_177956_o() + this.settings.getY();
            this.entity.field_70161_v = (double)((float)this.field_174879_c.func_177952_p() + this.settings.getZ()) + 0.5;
            if (!this.morph.isEmpty()) {
                this.morph.get().update(this.entity);
            }
        }
        if (this.lastModelUpdate < Scene.lastUpdate && !this.settings.isExcludeResetPlayback()) {
            if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
                BlockPos pos = this.field_174879_c;
                PacketModifyModelBlock message = new PacketModifyModelBlock(pos, this);
                Dispatcher.DISPATCHER.get().sendToDimension((IMessage)message, this.field_145850_b.field_73011_w.getDimension());
            }
            this.lastModelUpdate = Scene.lastUpdate;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return TileEntity.INFINITE_EXTENT_AABB;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        float range = ((Integer)Blockbuster.actorRenderingRange.get()).intValue();
        return range * range;
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newSate) {
        return oldState.func_177230_c() != newSate.func_177230_c();
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, this.func_145832_p(), this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public void copyData(TileEntityModel model, boolean merge) {
        this.settings.copy(model.settings);
        if (merge) {
            this.morph.set(model.morph.get());
        } else {
            this.morph.setDirect(model.morph.get());
        }
        this.updateEntity();
        this.func_70296_d();
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        this.settings.toNBT(compound);
        if (!this.morph.isEmpty()) {
            compound.func_74782_a("Morph", (NBTBase)this.morph.toNBT());
        }
        return super.func_189515_b(compound);
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.settings.fromNBT(compound);
        if (compound.func_150297_b("Morph", 10)) {
            this.morph.setDirect(MorphManager.INSTANCE.morphFromNBT(compound.func_74775_l("Morph")));
        }
    }

    public void fromBytes(ByteBuf buf) {
        this.settings.fromBytes(buf);
        this.morph.setDirect(MorphUtils.morphFromBuf((ByteBuf)buf));
    }

    public void toBytes(ByteBuf buf) {
        this.settings.toBytes(buf);
        MorphUtils.morphToBuf((ByteBuf)buf, (AbstractMorph)this.morph.get());
    }

    static {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74778_a("Name", "blockbuster.fred");
        DEFAULT_MORPH = MorphManager.INSTANCE.morphFromNBT(tag);
    }
}

