/*
 * Decompiled with CFR 0.152.
 */
package mchorse.blockbuster.common.tileentity;

import io.netty.buffer.ByteBuf;
import javax.vecmath.Tuple4f;
import javax.vecmath.Vector4f;
import mchorse.mclib.client.gui.framework.elements.input.GuiTransformations;
import mchorse.mclib.config.values.GenericBaseValue;
import mchorse.mclib.config.values.ValueBoolean;
import mchorse.mclib.config.values.ValueFloat;
import mchorse.mclib.config.values.ValueInt;
import mchorse.mclib.config.values.ValueItemSlots;
import mchorse.mclib.config.values.ValueRotationOrder;
import mchorse.mclib.network.IByteBufSerializable;
import mchorse.mclib.network.INBTSerializable;
import mchorse.mclib.utils.ICopy;
import mchorse.mclib.utils.ITransformationObject;
import mchorse.mclib.utils.MatrixUtils;
import mchorse.mclib.utils.ValueSerializer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class TileEntityModelSettings
implements IByteBufSerializable,
INBTSerializable,
ITransformationObject,
ICopy<TileEntityModelSettings> {
    private final ValueBoolean enabled = new ValueBoolean("enabled", true);
    private final ValueInt lightValue = new ValueInt("lightValue");
    private final ValueBoolean shadow = new ValueBoolean("shadow", true);
    private final ValueBoolean global = new ValueBoolean("global");
    private final ValueBoolean excludeResetPlayback = new ValueBoolean("excludeResetPlayback");
    private final ValueBoolean renderLast = new ValueBoolean("renderLast");
    private final ValueBoolean renderAlways = new ValueBoolean("renderAlways");
    private final ValueBoolean enableBlockHitbox = new ValueBoolean("enableBlockHitbox");
    private final ValueItemSlots slots = new ValueItemSlots("slots", 6);
    private final ValueFloat rotateYawHead = new ValueFloat("rotateYawHead");
    private final ValueFloat rotatePitch = new ValueFloat("rotatePitch");
    private final ValueFloat rotateBody = new ValueFloat("rotateBody");
    private final ValueFloat x = new ValueFloat("x");
    private final ValueFloat y = new ValueFloat("y");
    private final ValueFloat z = new ValueFloat("z");
    private final ValueRotationOrder order = new ValueRotationOrder("order", MatrixUtils.RotationOrder.ZYX);
    private final ValueFloat rx = new ValueFloat("rx");
    private final ValueFloat ry = new ValueFloat("ry");
    private final ValueFloat rz = new ValueFloat("rz");
    private final ValueBoolean uniform = new ValueBoolean("uniform");
    private final ValueFloat sx = new ValueFloat("sx", 1.0f);
    private final ValueFloat sy = new ValueFloat("sy", 1.0f);
    private final ValueFloat sz = new ValueFloat("sz", 1.0f);
    private ValueSerializer serializer = new ValueSerializer();

    public TileEntityModelSettings() {
        this.serializer.registerValue((GenericBaseValue)this.enabled).serializeNBT("Enabled");
        this.serializer.registerValue((GenericBaseValue)this.order).serializeNBT("Order");
        this.serializer.registerValue((GenericBaseValue)this.rotateYawHead).serializeNBT("Yaw");
        this.serializer.registerValue((GenericBaseValue)this.rotatePitch).serializeNBT("Pitch");
        this.serializer.registerValue((GenericBaseValue)this.rotateBody).serializeNBT("Body");
        this.serializer.registerValue((GenericBaseValue)this.x).serializeNBT("ShiftX");
        this.serializer.registerValue((GenericBaseValue)this.y).serializeNBT("ShiftY");
        this.serializer.registerValue((GenericBaseValue)this.z).serializeNBT("ShiftZ");
        this.serializer.registerValue((GenericBaseValue)this.rx).serializeNBT("RotateX");
        this.serializer.registerValue((GenericBaseValue)this.ry).serializeNBT("RotateY");
        this.serializer.registerValue((GenericBaseValue)this.rz).serializeNBT("RotateZ");
        this.serializer.registerValue((GenericBaseValue)this.uniform).serializeNBT("Scale");
        this.serializer.registerValue((GenericBaseValue)this.sx).serializeNBT("ScaleX");
        this.serializer.registerValue((GenericBaseValue)this.sy).serializeNBT("ScaleY");
        this.serializer.registerValue((GenericBaseValue)this.sz).serializeNBT("ScaleZ");
        this.serializer.registerValue((GenericBaseValue)this.shadow).serializeNBT("Shadow");
        this.serializer.registerValue((GenericBaseValue)this.global).serializeNBT("Global");
        this.serializer.registerValue((GenericBaseValue)this.slots).serializeNBT("Items");
        this.serializer.registerValue((GenericBaseValue)this.lightValue).serializeNBT("LightValue");
        this.serializer.registerValue((GenericBaseValue)this.renderLast).serializeNBT("RenderLast");
        this.serializer.registerValue((GenericBaseValue)this.renderAlways).serializeNBT("RenderAlways");
        this.serializer.registerValue((GenericBaseValue)this.enableBlockHitbox).serializeNBT("Hitbox");
        this.serializer.registerValue((GenericBaseValue)this.excludeResetPlayback).serializeNBT("ExcludeResetPlayback");
    }

    public boolean isBlockHitbox() {
        return (Boolean)this.enableBlockHitbox.get();
    }

    public void setEnableBlockHitbox(boolean enableBlockHitbox) {
        this.enableBlockHitbox.set((Object)enableBlockHitbox);
    }

    public int getLightValue() {
        return (Integer)this.lightValue.get();
    }

    public void setLightValue(int lightValue) {
        this.lightValue.set((Number)lightValue);
    }

    public boolean isExcludeResetPlayback() {
        return (Boolean)this.excludeResetPlayback.get();
    }

    public void setExcludeResetPlayback(boolean excludeResetPlayback) {
        this.excludeResetPlayback.set((Object)excludeResetPlayback);
    }

    public boolean isRenderLast() {
        return (Boolean)this.renderLast.get();
    }

    public void setRenderLast(boolean renderLast) {
        this.renderLast.set((Object)renderLast);
    }

    public boolean isRenderAlways() {
        return (Boolean)this.renderAlways.get();
    }

    public void setRenderAlways(boolean renderAlways) {
        this.renderAlways.set((Object)renderAlways);
    }

    public ItemStack[] getSlots() {
        return this.slots.get();
    }

    public void setSlots(ItemStack[] slots) {
        this.slots.set(slots);
    }

    public void setSlot(ItemStack item, int slot) {
        this.slots.set(item, slot);
    }

    public MatrixUtils.RotationOrder getOrder() {
        return (MatrixUtils.RotationOrder)this.order.get();
    }

    public void setOrder(MatrixUtils.RotationOrder order) {
        this.order.set((Object)order);
    }

    public float getRotateYawHead() {
        return ((Float)this.rotateYawHead.get()).floatValue();
    }

    public void setRotateYawHead(float rotateYawHead) {
        this.rotateYawHead.set((Number)Float.valueOf(rotateYawHead));
    }

    public float getRotatePitch() {
        return ((Float)this.rotatePitch.get()).floatValue();
    }

    public void setRotatePitch(float rotatePitch) {
        this.rotatePitch.set((Number)Float.valueOf(rotatePitch));
    }

    public float getRotateBody() {
        return ((Float)this.rotateBody.get()).floatValue();
    }

    public void setRotateBody(float rotateBody) {
        this.rotateBody.set((Number)Float.valueOf(rotateBody));
    }

    public float getX() {
        return ((Float)this.x.get()).floatValue();
    }

    public void setX(float x) {
        this.x.set((Number)Float.valueOf(x));
    }

    public float getY() {
        return ((Float)this.y.get()).floatValue();
    }

    public void setY(float y) {
        this.y.set((Number)Float.valueOf(y));
    }

    public float getZ() {
        return ((Float)this.z.get()).floatValue();
    }

    public void setZ(float z) {
        this.z.set((Number)Float.valueOf(z));
    }

    public void addTranslation(double x, double y, double z, GuiTransformations.TransformOrientation orientation) {
        Vector4f trans = new Vector4f((float)x, (float)y, (float)z, 1.0f);
        if (orientation == GuiTransformations.TransformOrientation.LOCAL) {
            float rotX = (float)Math.toRadians(this.getRx());
            float rotY = (float)Math.toRadians(this.getRy());
            float rotZ = (float)Math.toRadians(this.getRz());
            MatrixUtils.getRotationMatrix((float)rotX, (float)rotY, (float)rotZ, (MatrixUtils.RotationOrder)((MatrixUtils.RotationOrder)this.order.get())).transform((Tuple4f)trans);
        }
        this.x.set((Number)Float.valueOf(((Float)this.x.get()).floatValue() + trans.x));
        this.y.set((Number)Float.valueOf(((Float)this.y.get()).floatValue() + trans.y));
        this.z.set((Number)Float.valueOf(((Float)this.z.get()).floatValue() + trans.z));
    }

    public float getRx() {
        return ((Float)this.rx.get()).floatValue();
    }

    public void setRx(float rx) {
        this.rx.set((Number)Float.valueOf(rx));
    }

    public float getRy() {
        return ((Float)this.ry.get()).floatValue();
    }

    public void setRy(float ry) {
        this.ry.set((Number)Float.valueOf(ry));
    }

    public float getRz() {
        return ((Float)this.rz.get()).floatValue();
    }

    public void setRz(float rz) {
        this.rz.set((Number)Float.valueOf(rz));
    }

    public boolean isUniform() {
        return (Boolean)this.uniform.get();
    }

    public void setUniform(boolean uniform) {
        this.uniform.set((Object)uniform);
    }

    public float getSx() {
        return ((Float)this.sx.get()).floatValue();
    }

    public void setSx(float sx) {
        this.sx.set((Number)Float.valueOf(sx));
    }

    public float getSy() {
        return ((Float)this.sy.get()).floatValue();
    }

    public void setSy(float sy) {
        this.sy.set((Number)Float.valueOf(sy));
    }

    public float getSz() {
        return ((Float)this.sz.get()).floatValue();
    }

    public void setSz(float sz) {
        this.sz.set((Number)Float.valueOf(sz));
    }

    public boolean isShadow() {
        return (Boolean)this.shadow.get();
    }

    public void setShadow(boolean shadow) {
        this.shadow.set((Object)shadow);
    }

    public boolean isGlobal() {
        return (Boolean)this.global.get();
    }

    public void setGlobal(boolean global) {
        this.global.set((Object)global);
    }

    public boolean isEnabled() {
        return (Boolean)this.enabled.get();
    }

    public void setEnabled(boolean enabled) {
        this.enabled.set((Object)enabled);
    }

    public TileEntityModelSettings copy() {
        TileEntityModelSettings copy = new TileEntityModelSettings();
        copy.copy(this);
        return copy;
    }

    public void copy(TileEntityModelSettings settings) {
        this.serializer.copyValues(settings.serializer);
    }

    public void fromBytes(ByteBuf byteBuf) {
        this.serializer.fromBytes(byteBuf);
    }

    public void toBytes(ByteBuf byteBuf) {
        this.serializer.toBytes(byteBuf);
    }

    public void fromNBT(NBTTagCompound nbtTagCompound) {
        this.serializer.fromNBT(nbtTagCompound);
    }

    public NBTTagCompound toNBT(NBTTagCompound nbtTagCompound) {
        return this.serializer.toNBT(nbtTagCompound);
    }
}

