/*
 * Decompiled with CFR 0.152.
 */
package mchorse.blockbuster.events;

import java.util.Iterator;
import java.util.Map;
import java.util.function.Function;
import mchorse.blockbuster.CommonProxy;
import mchorse.blockbuster.client.RenderingHandler;
import mchorse.blockbuster.client.SkinHandler;
import mchorse.blockbuster.client.render.tileentity.TileEntityGunItemStackRenderer;
import mchorse.blockbuster.client.render.tileentity.TileEntityModelItemStackRenderer;
import mchorse.blockbuster.client.textures.GifTexture;
import mchorse.blockbuster.common.GunProps;
import mchorse.blockbuster.common.item.ItemGun;
import mchorse.blockbuster.recording.scene.Scene;
import mchorse.blockbuster.utils.NBTUtils;
import mchorse.blockbuster_pack.morphs.StructureMorph;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.NonNullList;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PlayerHandler {
    private Function<GunProps, Boolean> leftHandler = props -> props.preventLeftClick;
    private Function<GunProps, Boolean> rightHandler = props -> props.preventRightClick;
    private Function<GunProps, Boolean> attackHandler = props -> props.preventEntityAttack;
    private int timer;
    private int skinsTimer;
    private static NonNullList<ItemStack> mainInventoryBefore = NonNullList.func_191197_a((int)36, (Object)ItemStack.field_190927_a);

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onLivingAttack(LivingAttackEvent event) {
        Entity source = event.getSource().func_76346_g();
        if (source instanceof EntityPlayer) {
            this.handle((EntityPlayer)source, (LivingEvent)event, this.attackHandler);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onPlayerInteract(PlayerInteractEvent.LeftClickBlock event) {
        this.handle(event.getEntityPlayer(), (LivingEvent)event, this.leftHandler);
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onPlayerInteract(PlayerInteractEvent.EntityInteract event) {
        this.handle(event.getEntityPlayer(), (LivingEvent)event, this.rightHandler);
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onPlayerInteract(PlayerInteractEvent.RightClickBlock event) {
        this.handle(event.getEntityPlayer(), (LivingEvent)event, this.rightHandler);
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onPlayerInteract(PlayerInteractEvent.RightClickItem event) {
        this.handle(event.getEntityPlayer(), (LivingEvent)event, this.rightHandler);
    }

    private static void preventItemPickUpScenePlayback(InventoryPlayer inventoryPlayer) {
        for (Map.Entry<String, Scene> scene : CommonProxy.scenes.getScenes().entrySet()) {
            for (EntityPlayer player : scene.getValue().getTargetPlaybackPlayers()) {
                if (player.field_71071_by != inventoryPlayer) continue;
                PlayerHandler.preventItemPickUp(player);
            }
        }
    }

    public static void preventItemPickUp(EntityPlayer player) {
        for (int i = 0; i < player.field_71071_by.field_70462_a.size(); ++i) {
            ItemStack itemStackBefore;
            ItemStack itemStackNow = (ItemStack)player.field_71071_by.field_70462_a.get(i);
            if (ItemStack.func_77989_b((ItemStack)itemStackNow, (ItemStack)(itemStackBefore = (ItemStack)mainInventoryBefore.get(i)))) continue;
            player.field_71071_by.field_70462_a.set(i, (Object)itemStackBefore);
        }
    }

    public static void beforePlayerItemPickUp(EntityPlayer entity, ItemStack itemStack) {
    }

    public static void beforeItemStackAdd(InventoryPlayer inventory) {
        for (int i = 0; i < inventory.field_70462_a.size(); ++i) {
            ItemStack copy = ((ItemStack)inventory.field_70462_a.get(i)).func_77946_l();
            mainInventoryBefore.set(i, (Object)copy);
        }
    }

    public static void afterItemStackAdd(InventoryPlayer inventory) {
        PlayerHandler.preventItemPickUpScenePlayback(inventory);
    }

    private void handle(EntityPlayer player, LivingEvent event, Function<GunProps, Boolean> handler) {
        ItemStack stack = player.func_184614_ca();
        if (!(stack.func_77973_b() instanceof ItemGun)) {
            return;
        }
        GunProps props = NBTUtils.getGunProps(stack);
        if (props == null) {
            return;
        }
        if (handler.apply(props).booleanValue() && event.isCancelable()) {
            event.setCanceled(true);
            if (event instanceof PlayerInteractEvent) {
                ((PlayerInteractEvent)event).setCancellationResult(EnumActionResult.FAIL);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            if (event.player.field_70170_p.field_72995_K) {
                if (Minecraft.func_71410_x().field_71439_g == event.player) {
                    this.updateClient();
                }
            } else {
                if (this.timer % 100 == 0) {
                    StructureMorph.checkStructures();
                    this.timer = 0;
                }
                ++this.timer;
            }
            return;
        }
        EntityPlayer player = event.player;
        ItemStack stack = player.func_184614_ca();
        if (stack.func_77973_b() instanceof ItemGun) {
            ItemGun.decreaseReload(stack, player);
            ItemGun.decreaseTime(stack, player);
            ItemGun.checkGunState(stack, player);
            ItemGun.checkGunReload(stack, player);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void updateClient() {
        Iterator<Map.Entry<NBTTagCompound, TileEntityModelItemStackRenderer.TEModel>> iter0 = TileEntityModelItemStackRenderer.models.entrySet().iterator();
        while (iter0.hasNext()) {
            TileEntityModelItemStackRenderer.TEModel model = iter0.next().getValue();
            if (model.timer <= 0) {
                iter0.remove();
                continue;
            }
            model.model.func_73660_a();
            --model.timer;
        }
        Iterator<Map.Entry<ItemStack, TileEntityGunItemStackRenderer.GunEntry>> iter1 = TileEntityGunItemStackRenderer.models.entrySet().iterator();
        while (iter1.hasNext()) {
            TileEntityGunItemStackRenderer.GunEntry model = iter1.next().getValue();
            if (model.timer <= 0) {
                iter1.remove();
                continue;
            }
            model.props.update();
            --model.timer;
        }
        if (this.skinsTimer++ >= 30) {
            SkinHandler.checkSkinsFolder();
            this.skinsTimer = 0;
        }
        RenderingHandler.updateEmitters();
        GifTexture.updateTick();
    }
}

