/*
 * Decompiled with CFR 0.152.
 */
package mchorse.blockbuster.network.client;

import mchorse.blockbuster.network.common.structure.PacketStructure;
import mchorse.blockbuster_pack.morphs.StructureMorph;
import mchorse.blockbuster_pack.morphs.structure.StructureRenderer;
import mchorse.mclib.network.ClientMessageHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.multiplayer.ChunkProviderClient;
import net.minecraft.init.Biomes;
import net.minecraft.profiler.Profiler;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.GameType;
import net.minecraft.world.World;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.WorldProviderSurface;
import net.minecraft.world.WorldSettings;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.structure.template.PlacementSettings;
import net.minecraft.world.gen.structure.template.Template;
import net.minecraft.world.storage.ISaveHandler;
import net.minecraft.world.storage.WorldInfo;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ClientHandlerStructure
extends ClientMessageHandler<PacketStructure> {
    @SideOnly(value=Side.CLIENT)
    public void run(EntityPlayerSP player, PacketStructure message) {
        Minecraft.func_71410_x().func_152344_a(() -> {
            try {
                if (message.tag == null) {
                    StructureRenderer renderer = StructureMorph.STRUCTURES.get(message.name);
                    if (renderer != null) {
                        renderer.delete();
                    }
                    return;
                }
                StructureRenderer renderer = this.createListFromTemplate(message);
                StructureRenderer old = StructureMorph.STRUCTURES.remove(message.name);
                if (old != null) {
                    old.delete();
                }
                StructureMorph.STRUCTURES.put(message.name, renderer);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
    }

    @SideOnly(value=Side.CLIENT)
    private StructureRenderer createListFromTemplate(PacketStructure message) {
        Profiler profiler = new Profiler();
        Template template = new Template();
        PlacementSettings placement = new PlacementSettings();
        WorldSettings settings = new WorldSettings(0L, GameType.CREATIVE, true, false, WorldType.field_77137_b);
        WorldInfo info = new WorldInfo(settings, message.name);
        WorldProviderSurface provider = new WorldProviderSurface();
        FakeWorld world = new FakeWorld(null, info, (WorldProvider)provider, profiler, true);
        provider.func_76558_a((World)world);
        template.func_186256_b(message.tag);
        BlockPos origin = new BlockPos(1, 1, 1);
        int w = template.func_186259_a().func_177958_n();
        int d = template.func_186259_a().func_177952_p();
        int cx = (w + 2) / 16 + 1;
        for (int x = 0; x < cx; ++x) {
            int cz = (d + 2) / 16 + 1;
            for (int z = 0; z < cz; ++z) {
                ((ChunkProviderClient)world.func_72863_F()).func_73158_c(x, z);
            }
        }
        template.func_186253_b((World)world, origin, placement);
        return new StructureRenderer(template.func_186259_a(), world);
    }

    @SideOnly(value=Side.CLIENT)
    public static class FakeWorld
    extends World {
        public ChunkProviderClient clientChunkProvider;
        public Biome biome;

        public FakeWorld(ISaveHandler saveHandlerIn, WorldInfo info, WorldProvider providerIn, Profiler profilerIn, boolean client) {
            super(saveHandlerIn, info, providerIn, profilerIn, client);
            this.field_73020_y = this.func_72970_h();
            this.biome = Biomes.field_180279_ad;
        }

        protected boolean func_175680_a(int x, int z, boolean allowEmpty) {
            return allowEmpty || !this.func_72863_F().func_186025_d(x, z).func_76621_g();
        }

        protected IChunkProvider func_72970_h() {
            if (this.clientChunkProvider == null) {
                this.clientChunkProvider = new ChunkProviderClient((World)this);
            }
            return this.clientChunkProvider;
        }

        public boolean func_175648_a(BlockPos center, int radius, boolean allowEmpty) {
            return true;
        }

        public Biome func_180494_b(BlockPos pos) {
            return this.biome;
        }
    }
}

