/*
 * Decompiled with CFR 0.152.
 */
package mchorse.blockbuster.network.common.recording;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import mchorse.blockbuster.recording.data.Frame;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public abstract class PacketFrames
implements IMessage {
    public String filename;
    public int preDelay;
    public int postDelay;
    public List<Frame> frames;

    public PacketFrames() {
    }

    public PacketFrames(String filename, int preDelay, int postDelay, List<Frame> frames) {
        this.filename = filename;
        this.preDelay = preDelay;
        this.postDelay = postDelay;
        this.frames = frames;
    }

    public void fromBytes(ByteBuf buf) {
        ArrayList<Frame> frames = new ArrayList<Frame>();
        this.filename = ByteBufUtils.readUTF8String((ByteBuf)buf);
        this.preDelay = buf.readInt();
        this.postDelay = buf.readInt();
        if (buf.readBoolean()) {
            int count = buf.readInt();
            for (int i = 0; i < count; ++i) {
                Frame frame = new Frame();
                frame.fromBytes(buf);
                frames.add(frame);
            }
            this.frames = frames;
        }
    }

    public void toBytes(ByteBuf buf) {
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.filename);
        buf.writeInt(this.preDelay);
        buf.writeInt(this.postDelay);
        buf.writeBoolean(this.frames != null);
        if (this.frames != null) {
            buf.writeInt(this.frames.size());
            for (Frame frame : this.frames) {
                frame.toBytes(buf);
            }
        }
    }
}

