/*
 * Decompiled with CFR 0.152.
 */
package mchorse.blockbuster.network.common.recording.actions;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import mchorse.blockbuster.recording.actions.Action;
import mchorse.blockbuster.recording.actions.ActionRegistry;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class PacketActionsChange
implements IMessage {
    private String filename;
    private int fromTick = -1;
    private int index = -1;
    private List<List<Action>> actions;
    private List<List<Boolean>> mask;
    private Type type;

    public PacketActionsChange() {
    }

    public PacketActionsChange(String filename, int from, int index, Action action, Type type) {
        this.filename = filename;
        this.fromTick = from;
        this.index = index;
        ArrayList<List<Action>> actions = new ArrayList<List<Action>>();
        actions.add(new ArrayList());
        ((List)actions.get(0)).add(action);
        this.actions = actions;
        this.type = type;
    }

    public PacketActionsChange(String filename, int from, List<List<Action>> actions, Type type) {
        this.filename = filename;
        this.fromTick = from;
        this.actions = actions;
        this.type = type;
    }

    public PacketActionsChange(String filename, int tick, int index, List<List<Action>> actions, Type type) {
        this.filename = filename;
        this.fromTick = tick;
        this.index = index;
        this.actions = actions;
        this.type = type;
    }

    public PacketActionsChange(String filename, int tick, List<List<Boolean>> deletionMask) {
        this(filename, tick, null, Type.DELETE);
        this.mask = deletionMask;
    }

    public boolean containsOneAction() {
        return this.actions != null && !this.actions.isEmpty() && this.actions.get(0) != null && !this.actions.get(0).isEmpty();
    }

    public int getIndex() {
        return this.index;
    }

    public int getFromTick() {
        return this.fromTick;
    }

    public List<List<Action>> getActions() {
        return this.actions;
    }

    public String getFilename() {
        return this.filename;
    }

    public Type getStatus() {
        return this.type;
    }

    public List<List<Boolean>> getMask() {
        return this.mask;
    }

    public void fromBytes(ByteBuf buf) {
        int j;
        int i;
        int size;
        this.filename = ByteBufUtils.readUTF8String((ByteBuf)buf);
        this.fromTick = buf.readInt();
        this.index = buf.readInt();
        this.type = Type.values()[buf.readInt()];
        if (buf.readBoolean()) {
            this.actions = new ArrayList<List<Action>>();
            size = buf.readInt();
            for (i = 0; i < size; ++i) {
                int count = buf.readByte();
                if (count != 0) {
                    ArrayList<Action> actions = new ArrayList<Action>();
                    for (j = 0; j < count; ++j) {
                        Action action = ActionRegistry.fromByteBuf(buf);
                        if (action == null) continue;
                        actions.add(action);
                    }
                    this.actions.add(actions);
                    continue;
                }
                this.actions.add(null);
            }
        }
        if (buf.readBoolean()) {
            this.mask = new ArrayList<List<Boolean>>();
            size = buf.readInt();
            for (i = 0; i < size; ++i) {
                ArrayList<Boolean> maskFrame = new ArrayList<Boolean>();
                int count = buf.readByte();
                if (count != 0) {
                    for (j = 0; j < count; ++j) {
                        maskFrame.add(buf.readBoolean());
                    }
                } else {
                    maskFrame.add(false);
                }
                this.mask.add(maskFrame);
            }
        }
    }

    public void toBytes(ByteBuf buf) {
        int count;
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.filename);
        buf.writeInt(this.fromTick);
        buf.writeInt(this.index);
        buf.writeInt(this.type.ordinal());
        buf.writeBoolean(this.actions != null);
        if (this.actions != null) {
            buf.writeInt(this.actions.size());
            for (List<Action> list : this.actions) {
                count = list == null ? 0 : list.size();
                buf.writeByte(count);
                if (count == 0) continue;
                for (Action action : list) {
                    ActionRegistry.toByteBuf(action, buf);
                }
            }
        }
        buf.writeBoolean(this.mask != null);
        if (this.mask != null) {
            buf.writeInt(this.mask.size());
            for (List<Object> list : this.mask) {
                count = list == null ? 0 : list.size();
                buf.writeByte(count);
                if (count == 0) continue;
                for (Boolean bl : list) {
                    buf.writeBoolean(bl.booleanValue());
                }
            }
        }
    }

    public static enum Type {
        DELETE,
        ADD,
        EDIT;

    }
}

