/*
 * Decompiled with CFR 0.152.
 */
package mchorse.blockbuster.network.server.recording.actions;

import java.util.List;
import mchorse.blockbuster.CommonProxy;
import mchorse.blockbuster.network.Dispatcher;
import mchorse.blockbuster.network.common.recording.actions.PacketActionsChange;
import mchorse.blockbuster.recording.RecordUtils;
import mchorse.blockbuster.recording.actions.Action;
import mchorse.blockbuster.recording.data.Record;
import mchorse.mclib.network.ServerMessageHandler;
import mchorse.mclib.utils.OpHelper;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ServerHandlerActionsChange
extends ServerMessageHandler<PacketActionsChange> {
    public void run(EntityPlayerMP player, PacketActionsChange message) {
        if (!OpHelper.isPlayerOp((EntityPlayerMP)player)) {
            return;
        }
        Record record = null;
        try {
            record = CommonProxy.manager.get(message.getFilename());
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (record == null) {
            return;
        }
        if (message.getFromTick() >= 0) {
            switch (message.getStatus()) {
                case DELETE: {
                    record.removeActionsMask(message.getFromTick(), message.getMask());
                    break;
                }
                case ADD: {
                    if (message.getIndex() != -1) {
                        if (!message.containsOneAction()) break;
                        record.addActionCollection(message.getFromTick(), message.getIndex(), message.getActions());
                        break;
                    }
                    record.addActionCollection(message.getFromTick(), message.getActions());
                    break;
                }
                case EDIT: {
                    if (message.getIndex() == -1 || !message.containsOneAction()) break;
                    record.replaceAction(message.getFromTick(), message.getIndex(), message.getActions().get(0).get(0));
                }
            }
            try {
                RecordUtils.saveRecord(record, false, false);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void deleteActions(Record record, int from, List<List<Boolean>> mask) {
        record.removeActionsMask(from, mask);
        Dispatcher.sendToServer(new PacketActionsChange(record.filename, from, mask));
    }

    @SideOnly(value=Side.CLIENT)
    public static void addActions(List<List<Action>> actions, Record record, int tick) {
        record.addActionCollection(tick, actions);
        Dispatcher.sendToServer(new PacketActionsChange(record.filename, tick, actions, PacketActionsChange.Type.ADD));
    }

    @SideOnly(value=Side.CLIENT)
    public static void addActions(List<List<Action>> actions, Record record, int tick, int index) {
        if (index == -1) {
            ServerHandlerActionsChange.addActions(actions, record, tick);
        } else {
            record.addActionCollection(tick, index, actions);
            Dispatcher.sendToServer(new PacketActionsChange(record.filename, tick, index, actions, PacketActionsChange.Type.ADD));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void addAction(Action action, Record record, int tick, int index) {
        record.addAction(tick, index, action);
        Dispatcher.sendToServer(new PacketActionsChange(record.filename, tick, index, action, PacketActionsChange.Type.ADD));
    }

    @SideOnly(value=Side.CLIENT)
    public static void editAction(Action action, Record record, int tick, int index) {
        record.replaceAction(tick, index, action);
        Dispatcher.sendToServer(new PacketActionsChange(record.filename, tick, index, action, PacketActionsChange.Type.EDIT));
    }
}

