/*
 * Decompiled with CFR 0.152.
 */
package mchorse.blockbuster.recording;

import java.util.ArrayList;
import java.util.List;
import mchorse.blockbuster.recording.actions.Action;
import mchorse.blockbuster.recording.capturing.PlayerTracker;
import mchorse.blockbuster.recording.data.Frame;
import mchorse.blockbuster.recording.data.Mode;
import mchorse.blockbuster.recording.data.Record;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.math.MathHelper;

public class RecordRecorder {
    public Record record;
    public List<Action> actions = new ArrayList<Action>();
    public Mode mode;
    public int tick = 0;
    public int offset = 0;
    public boolean teleportBack;
    private Frame first;
    private float yawOffset;
    public PlayerTracker tracker;

    public RecordRecorder(Record record, Mode mode, EntityPlayer player, boolean teleportBack) {
        this.record = record;
        this.mode = mode;
        this.teleportBack = teleportBack;
        this.first = new Frame();
        this.first.fromPlayer(player);
        this.yawOffset = this.first.yaw - MathHelper.func_76142_g((float)this.first.yaw);
        if (mode == Mode.ACTIONS || mode == Mode.BOTH) {
            this.tracker = new PlayerTracker(this);
        }
    }

    public void record(EntityPlayer player) {
        boolean both;
        boolean bl = both = this.mode == Mode.BOTH;
        if (this.mode == Mode.FRAMES || both) {
            Frame frame = new Frame();
            frame.fromPlayer(player);
            frame.yaw -= this.yawOffset;
            frame.yawHead -= this.yawOffset;
            frame.bodyYaw -= this.yawOffset;
            frame.mountYaw -= this.yawOffset;
            this.record.frames.add(frame);
        }
        if (this.mode == Mode.ACTIONS || both) {
            this.tracker.track(player);
            ArrayList<Action> list = null;
            if (!this.actions.isEmpty()) {
                list = new ArrayList<Action>();
                list.addAll(this.actions);
                this.actions.clear();
            }
            this.record.actions.add(list);
        }
        ++this.tick;
    }

    public void stop(EntityPlayer player) {
        if (this.teleportBack && player instanceof EntityPlayerMP) {
            ((EntityPlayerMP)player).field_71135_a.func_147364_a(this.first.x, this.first.y, this.first.z, this.first.yaw, this.first.pitch);
        }
    }

    public void applyOld(Record oldRecord) {
        this.record.frames.addAll(oldRecord.frames);
        if (this.offset > 0) {
            List<List<Action>> actions = this.record.actions;
            int newSize = this.offset + actions.size();
            this.record.actions = oldRecord.actions;
            if (this.record.actions.size() < newSize) {
                while (this.record.actions.size() < newSize) {
                    this.record.actions.add(null);
                }
            }
            for (int i = 0; i < actions.size(); ++i) {
                this.record.addActions(this.offset + i, actions.get(i));
            }
        }
    }
}

