/*
 * Decompiled with CFR 0.152.
 */
package mchorse.blockbuster.recording.actions;

import io.netty.buffer.ByteBuf;
import mchorse.blockbuster.recording.actions.InteractBlockAction;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.ByteBufUtils;

public class PlaceBlockAction
extends InteractBlockAction {
    public byte metadata;
    public String block = "";

    public PlaceBlockAction() {
    }

    public PlaceBlockAction(BlockPos pos, byte metadata, String block) {
        super(pos);
        this.metadata = metadata;
        this.block = block;
    }

    @Override
    public void apply(EntityLivingBase actor) {
        Block block = (Block)Block.field_149771_c.func_82594_a((Object)new ResourceLocation(this.block));
        if (block != null) {
            IBlockState state = actor.field_70170_p.func_180495_p(this.pos);
            if (InteractBlockAction.BLACKLIST.contains(state.func_177230_c().getRegistryName())) {
                return;
            }
            state = block.func_176203_a((int)this.metadata);
            actor.field_70170_p.func_175656_a(this.pos, state);
            World world = actor.field_70170_p;
            SoundType soundtype = world.func_180495_p(this.pos).func_177230_c().getSoundType(world.func_180495_p(this.pos), world, this.pos, null);
            world.func_184133_a(null, this.pos, soundtype.func_185841_e(), SoundCategory.BLOCKS, (soundtype.func_185843_a() + 1.0f) / 2.0f, soundtype.func_185847_b() * 0.8f);
        }
    }

    @Override
    public void fromBuf(ByteBuf buf) {
        super.fromBuf(buf);
        this.metadata = buf.readByte();
        this.block = ByteBufUtils.readUTF8String((ByteBuf)buf);
    }

    @Override
    public void toBuf(ByteBuf buf) {
        super.toBuf(buf);
        buf.writeByte((int)this.metadata);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.block);
    }

    @Override
    public void fromNBT(NBTTagCompound tag) {
        super.fromNBT(tag);
        this.metadata = tag.func_74771_c("Meta");
        this.block = tag.func_74779_i("Block");
    }

    @Override
    public void toNBT(NBTTagCompound tag) {
        super.toNBT(tag);
        tag.func_74774_a("Meta", this.metadata);
        tag.func_74778_a("Block", this.block);
    }
}

