/*
 * Decompiled with CFR 0.152.
 */
package mchorse.blockbuster.recording.capturing;

import java.io.IOException;
import java.util.List;
import mchorse.blockbuster.Blockbuster;
import mchorse.blockbuster.CommonProxy;
import mchorse.blockbuster.capabilities.recording.IRecording;
import mchorse.blockbuster.capabilities.recording.Recording;
import mchorse.blockbuster.recording.RecordPlayer;
import mchorse.blockbuster.recording.RecordRecorder;
import mchorse.blockbuster.recording.RecordUtils;
import mchorse.blockbuster.recording.actions.Action;
import mchorse.blockbuster.recording.actions.AttackAction;
import mchorse.blockbuster.recording.actions.BreakBlockAction;
import mchorse.blockbuster.recording.actions.ChatAction;
import mchorse.blockbuster.recording.actions.CommandAction;
import mchorse.blockbuster.recording.actions.DropAction;
import mchorse.blockbuster.recording.actions.InteractBlockAction;
import mchorse.blockbuster.recording.actions.InteractEntityAction;
import mchorse.blockbuster.recording.actions.ItemUseAction;
import mchorse.blockbuster.recording.actions.ItemUseBlockAction;
import mchorse.blockbuster.recording.actions.MorphAction;
import mchorse.blockbuster.recording.actions.MorphActionAction;
import mchorse.blockbuster.recording.actions.MountingAction;
import mchorse.blockbuster.recording.actions.PlaceBlockAction;
import mchorse.blockbuster.recording.actions.ShootArrowAction;
import mchorse.blockbuster.recording.capturing.WorldEventListener;
import mchorse.metamorph.api.events.MorphActionEvent;
import mchorse.metamorph.api.events.MorphEvent;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IWorldEventListener;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.event.CommandEvent;
import net.minecraftforge.event.ServerChatEvent;
import net.minecraftforge.event.entity.EntityMountEvent;
import net.minecraftforge.event.entity.item.ItemTossEvent;
import net.minecraftforge.event.entity.player.ArrowLooseEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.FillBucketEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class ActionHandler {
    public static TileEntity lastTE;

    @SubscribeEvent
    public void onWorldLoad(WorldEvent.Load event) {
        World world = event.getWorld();
        if (!world.field_72995_K) {
            world.func_72954_a((IWorldEventListener)new WorldEventListener(world));
        }
        if (world instanceof WorldServer && ((WorldServer)world).field_73011_w.getDimension() == 0) {
            Blockbuster.reloadServerModels(true);
        }
    }

    @SubscribeEvent
    public void onItemUse(PlayerInteractEvent.RightClickItem event) {
        EntityPlayer player = event.getEntityPlayer();
        List<Action> events = CommonProxy.manager.getActions(player);
        if (!player.field_70170_p.field_72995_K && events != null) {
            events.add(new ItemUseAction(event.getHand()));
        }
    }

    @SubscribeEvent
    public void onItemUseBlock(PlayerInteractEvent.RightClickBlock event) {
        EntityPlayer player = event.getEntityPlayer();
        List<Action> events = CommonProxy.manager.getActions(player);
        if (!player.field_70170_p.field_72995_K && events != null) {
            Vec3d hit = event.getHitVec();
            BlockPos pos = event.getPos();
            if (hit == null) {
                events.add(new ItemUseBlockAction(pos, event.getHand(), event.getFace()));
            } else {
                events.add(new ItemUseBlockAction(pos, event.getHand(), event.getFace(), (float)hit.field_72450_a - (float)pos.func_177958_n(), (float)hit.field_72448_b - (float)pos.func_177956_o(), (float)hit.field_72449_c - (float)pos.func_177952_p()));
            }
        }
    }

    @SubscribeEvent
    public void onPlayerBreaksBlock(BlockEvent.BreakEvent event) {
        EntityPlayer player = event.getPlayer();
        List<Action> events = CommonProxy.manager.getActions(player);
        if (!player.field_70170_p.field_72995_K && events != null) {
            events.add(new BreakBlockAction(event.getPos(), !player.func_184812_l_()));
        }
    }

    @SubscribeEvent
    public void onPlayerRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        EntityPlayer player = event.getEntityPlayer();
        List<Action> events = CommonProxy.manager.getActions(player);
        if (!player.field_70170_p.field_72995_K && events != null) {
            events.add(new InteractBlockAction(event.getPos()));
        }
    }

    @SubscribeEvent
    public void onRightClickEntity(PlayerInteractEvent.EntityInteract event) {
        EntityPlayer player = event.getEntityPlayer();
        List<Action> events = CommonProxy.manager.getActions(player);
        if (!player.field_70170_p.field_72995_K && events != null) {
            events.add(new InteractEntityAction(event.getHand()));
        }
    }

    @SubscribeEvent
    public void onPlayerPlacesBlock(BlockEvent.PlaceEvent event) {
        EntityPlayer player = event.getPlayer();
        List<Action> events = CommonProxy.manager.getActions(player);
        if (!player.field_70170_p.field_72995_K && events != null) {
            IBlockState state = event.getPlacedBlock();
            Block block = state.func_177230_c();
            this.placeBlock(events, event.getPos(), block, state);
        }
    }

    @SubscribeEvent
    public void onPlayerPlacesMultiBlock(BlockEvent.MultiPlaceEvent event) {
        EntityPlayer player = event.getPlayer();
        List<Action> events = CommonProxy.manager.getActions(player);
        if (!player.field_70170_p.field_72995_K && events != null) {
            List blocks = event.getReplacedBlockSnapshots();
            for (BlockSnapshot snapshot : blocks) {
                IBlockState state = snapshot.getCurrentBlock();
                Block block = state.func_177230_c();
                this.placeBlock(events, snapshot.getPos(), block, state);
            }
        }
    }

    @SubscribeEvent
    public void onPlayerAttack(AttackEntityEvent event) {
        EntityPlayer player = event.getEntityPlayer();
        List<Action> events = CommonProxy.manager.getActions(player);
        if (!player.field_70170_p.field_72995_K && events != null && !((Boolean)Blockbuster.recordAttackOnSwipe.get()).booleanValue()) {
            events.add(new AttackAction());
        }
    }

    @SubscribeEvent
    public void onPlayerUseBucket(FillBucketEvent event) {
        EntityPlayer player = event.getEntityPlayer();
        List<Action> events = CommonProxy.manager.getActions(player);
        RayTraceResult target = event.getTarget();
        if (!player.field_70170_p.field_72995_K && events != null && target != null && target.field_72313_a == RayTraceResult.Type.BLOCK) {
            Item bucket = event.getEmptyBucket().func_77973_b();
            BlockPos pos = target.func_178782_a().func_177972_a(target.field_178784_b);
            if (bucket == Items.field_151129_at) {
                this.placeBlock(events, pos, (Block)Blocks.field_150356_k, 0);
            } else if (bucket == Items.field_151131_as) {
                this.placeBlock(events, pos, (Block)Blocks.field_150358_i, 0);
            }
        }
    }

    private void placeBlock(List<Action> events, BlockPos pos, Block block, IBlockState state) {
        this.placeBlock(events, pos, block, block.func_176201_c(state));
    }

    private void placeBlock(List<Action> events, BlockPos pos, Block block, int metadata) {
        ResourceLocation id = block.getRegistryName();
        events.add(new PlaceBlockAction(pos, (byte)metadata, id.toString()));
    }

    @SubscribeEvent
    public void onPlayerMountsSomething(EntityMountEvent event) {
        if (event.getEntityMounting() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.getEntityMounting();
            List<Action> events = CommonProxy.manager.getActions(player);
            if (!player.field_70170_p.field_72995_K && events != null) {
                events.add(new MountingAction(event.getEntityBeingMounted().func_110124_au(), event.isMounting()));
            }
        }
    }

    @SubscribeEvent
    public void onArrowLooseEvent(ArrowLooseEvent event) throws IOException {
        EntityPlayer player = event.getEntityPlayer();
        List<Action> events = CommonProxy.manager.getActions(player);
        if (!player.field_70170_p.field_72995_K && events != null) {
            events.add(new ShootArrowAction(event.getCharge()));
        }
    }

    @SubscribeEvent
    public void onItemTossEvent(ItemTossEvent event) throws IOException {
        EntityPlayer player = event.getPlayer();
        List<Action> events = CommonProxy.manager.getActions(player);
        if (!player.field_70170_p.field_72995_K && events != null) {
            events.add(new DropAction(event.getEntityItem().func_92059_d()));
        }
    }

    @SubscribeEvent
    public void onServerChatEvent(ServerChatEvent event) {
        EntityPlayerMP player = event.getPlayer();
        List<Action> events = CommonProxy.manager.getActions((EntityPlayer)player);
        if (!player.field_70170_p.field_72995_K && events != null) {
            events.add(new ChatAction(event.getMessage()));
        }
    }

    @SubscribeEvent
    public void onPlayerCommand(CommandEvent event) {
        if (!((Boolean)Blockbuster.recordCommands.get()).booleanValue()) {
            return;
        }
        ICommandSender sender = event.getSender();
        if (sender instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)sender;
            List<Action> events = CommonProxy.manager.getActions(player);
            if (!player.field_70170_p.field_72995_K && events != null) {
                String command = "/" + event.getCommand().func_71517_b();
                for (String value : event.getParameters()) {
                    command = command + " " + value;
                }
                events.add(new CommandAction(command));
            }
        }
    }

    @SubscribeEvent
    public void onPlayerLogOut(PlayerEvent.PlayerLoggedOutEvent event) {
        EntityPlayer player = event.player;
        if (!player.field_70170_p.field_72995_K) {
            CommonProxy.manager.abort(player);
        }
    }

    @SubscribeEvent
    public void onPlayerMorph(MorphEvent.Post event) {
        EntityPlayer player = event.player;
        List<Action> events = CommonProxy.manager.getActions(player);
        if (!player.field_70170_p.field_72995_K && events != null) {
            events.add(new MorphAction(event.morph));
        }
    }

    @SubscribeEvent
    public void onPlayerMorphAction(MorphActionEvent event) {
        EntityPlayer player = event.player;
        List<Action> events = CommonProxy.manager.getActions(player);
        if (!player.field_70170_p.field_72995_K && events != null && event.isValid()) {
            events.add(new MorphActionAction());
        }
    }

    @SubscribeEvent
    public void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            return;
        }
        CommonProxy.manager.tick();
        CommonProxy.scenes.tick();
    }

    @SubscribeEvent
    public void onWorldServerTick(TickEvent.WorldTickEvent event) {
        if (event.phase == TickEvent.Phase.END || event.world.field_72995_K) {
            return;
        }
        CommonProxy.scenes.worldTick(event.world);
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        IRecording recording;
        RecordPlayer record;
        boolean server;
        if (event.phase == TickEvent.Phase.START) {
            return;
        }
        EntityPlayer player = event.player;
        boolean bl = server = !player.field_70170_p.field_72995_K;
        if (server && CommonProxy.manager.recorders.containsKey(player)) {
            RecordRecorder recorder = CommonProxy.manager.recorders.get(player);
            if (player.field_70128_L) {
                CommonProxy.manager.halt(player, true, true);
                RecordUtils.broadcastInfo("recording.dead", recorder.record.filename);
            } else {
                recorder.record(player);
            }
        }
        if ((record = (recording = Recording.get(player)).getRecordPlayer()) != null) {
            record.next();
            if (record.isFinished() && server) {
                record.stopPlaying();
            }
        }
    }
}

