/*
 * Decompiled with CFR 0.152.
 */
package mchorse.blockbuster.recording.capturing;

import java.util.ArrayList;
import java.util.List;
import mchorse.blockbuster.recording.capturing.ActionHandler;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class DamageControl {
    public List<BlockEntry> blocks = new ArrayList<BlockEntry>();
    public List<Entity> entities = new ArrayList<Entity>();
    public EntityLivingBase target;
    public int maxDistance;

    public DamageControl(EntityLivingBase target, int maxDistance) {
        this.target = target;
        this.maxDistance = maxDistance;
    }

    public void addBlock(BlockPos pos, IBlockState state, World world) {
        double x = Math.abs(this.target.field_70165_t - (double)pos.func_177958_n());
        double y = Math.abs(this.target.field_70163_u - (double)pos.func_177956_o());
        double z = Math.abs(this.target.field_70161_v - (double)pos.func_177952_p());
        if (x > (double)this.maxDistance || y > (double)this.maxDistance || z > (double)this.maxDistance) {
            return;
        }
        for (BlockEntry entry : this.blocks) {
            if (entry.pos.func_177958_n() != pos.func_177958_n() || entry.pos.func_177956_o() != pos.func_177956_o() || entry.pos.func_177952_p() != pos.func_177952_p()) continue;
            return;
        }
        this.blocks.add(new BlockEntry(pos, state, ActionHandler.lastTE));
    }

    public void apply(World world) {
        for (BlockEntry entry : this.blocks) {
            world.func_175656_a(entry.pos, entry.state);
            if (entry.te == null) continue;
            world.func_175690_a(entry.pos, TileEntity.func_190200_a((World)world, (NBTTagCompound)entry.te));
        }
        for (Entity entity : this.entities) {
            entity.func_70106_y();
        }
        this.blocks.clear();
        this.entities.clear();
    }

    public static class BlockEntry {
        public BlockPos pos;
        public IBlockState state;
        public NBTTagCompound te;

        public BlockEntry(BlockPos pos, IBlockState state, TileEntity te) {
            this.pos = pos;
            this.state = state;
            if (te != null) {
                this.te = te.func_189515_b(new NBTTagCompound());
            }
        }
    }
}

