/*
 * Decompiled with CFR 0.152.
 */
package mchorse.blockbuster.recording.capturing;

import java.util.Arrays;
import mchorse.blockbuster.Blockbuster;
import mchorse.blockbuster.recording.RecordRecorder;
import mchorse.blockbuster.recording.actions.AttackAction;
import mchorse.blockbuster.recording.actions.CloseContainerAction;
import mchorse.blockbuster.recording.actions.EquipAction;
import mchorse.blockbuster.recording.actions.HotbarChangeAction;
import mchorse.blockbuster.recording.actions.SwipeAction;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;

public class PlayerTracker {
    public RecordRecorder recorder;
    private ItemStack[] items = new ItemStack[6];
    private ItemStack[] hotbar = new ItemStack[9];
    private boolean trackedHotbar = false;
    private Container container;

    public PlayerTracker(RecordRecorder recorder) {
        this.recorder = recorder;
        Arrays.fill(this.hotbar, ItemStack.field_190927_a);
    }

    public void track(EntityPlayer player) {
        this.trackSwing(player);
        this.trackHeldItem(player);
        this.trackHotBar(player);
        this.trackArmor(player);
        this.trackContainerClose(player);
    }

    private void trackArmor(EntityPlayer player) {
        for (int i = 1; i < 5; ++i) {
            this.trackItemToSlot((ItemStack)player.field_71071_by.field_70460_b.get(i - 1), i);
        }
    }

    private void trackHeldItem(EntityPlayer player) {
        ItemStack mainhand = player.func_184614_ca();
        ItemStack offhand = player.func_184592_cb();
        this.trackItemToSlot(mainhand, 0, player.field_71071_by.field_70461_c);
        this.trackItemToSlot(offhand, 5);
    }

    private void trackHotBar(EntityPlayer player) {
        NonNullList playerHotbar = player.field_71071_by.field_70462_a;
        for (int i = 0; i < playerHotbar.size() && i < this.hotbar.length; ++i) {
            if (ItemStack.func_77989_b((ItemStack)this.hotbar[i], (ItemStack)((ItemStack)playerHotbar.get(i))) && this.trackedHotbar) continue;
            this.recorder.actions.add(new HotbarChangeAction(i, ((ItemStack)playerHotbar.get(i)).func_77946_l()));
            this.hotbar[i] = ((ItemStack)playerHotbar.get(i)).func_77946_l();
        }
        this.trackedHotbar = true;
    }

    private boolean trackItemToSlot(ItemStack item, int slot) {
        return this.trackItemToSlot(item, slot, -1);
    }

    private boolean trackItemToSlot(ItemStack item, int slot, int hotbarslot) {
        if (!item.func_190926_b()) {
            if (item != this.items[slot]) {
                this.items[slot] = item;
                this.recorder.actions.add(hotbarslot != -1 ? new EquipAction((byte)slot, (byte)hotbarslot, item) : new EquipAction((byte)slot, item));
                return true;
            }
        } else if (this.items[slot] != null) {
            this.items[slot] = null;
            this.recorder.actions.add(hotbarslot != -1 ? new EquipAction((byte)slot, (byte)hotbarslot, null) : new EquipAction((byte)slot, null));
            return true;
        }
        return false;
    }

    private void trackSwing(EntityPlayer player) {
        if (player.field_82175_bq && player.field_70733_aJ == 0.0f && !player.func_70608_bn()) {
            this.recorder.actions.add(new SwipeAction());
            if (((Boolean)Blockbuster.recordAttackOnSwipe.get()).booleanValue()) {
                this.recorder.actions.add(new AttackAction());
            }
        }
    }

    private void trackContainerClose(EntityPlayer player) {
        if (this.container != null && player.field_71070_bA == player.field_71069_bz && this.container != player.field_71070_bA) {
            this.recorder.actions.add(new CloseContainerAction());
        }
        this.container = player.field_71070_bA;
    }
}

