/*
 * Decompiled with CFR 0.152.
 */
package mchorse.blockbuster.recording.data;

import java.util.ArrayList;
import java.util.List;
import mchorse.blockbuster.recording.data.Frame;

public class FrameChunk {
    public List<List<Frame>> frames;
    public int count;
    public int offset;

    public FrameChunk(int count, int offset) {
        this.frames = new ArrayList<List<Frame>>(count);
        this.count = count;
        this.offset = offset;
        for (int i = 0; i < count; ++i) {
            this.frames.add(null);
        }
    }

    public boolean isFilled() {
        for (int i = 0; i < this.count; ++i) {
            if (this.frames.get(i) != null) continue;
            return false;
        }
        return true;
    }

    public void add(int index, List<Frame> frames) {
        this.frames.set(index, frames);
    }

    public List<Frame> compile(List<Frame> oldFrames) {
        ArrayList<Frame> output = new ArrayList<Frame>();
        if (this.offset > 0) {
            ArrayList<Frame> merged = new ArrayList<Frame>();
            for (List<Frame> frames : this.frames) {
                merged.addAll(frames);
            }
            int newSize = this.offset + merged.size();
            int c = Math.max(newSize, oldFrames.size());
            for (int i = 0; i < c; ++i) {
                int index;
                Frame frame = i < this.offset ? (i < oldFrames.size() ? oldFrames.get(i) : ((Frame)merged.get(0)).copy()) : (i > newSize ? oldFrames.get(i) : ((index = i - this.offset) < merged.size() ? (Frame)merged.get(index) : oldFrames.get(i)));
                output.add(frame);
            }
        } else {
            for (List<Frame> frames : this.frames) {
                output.addAll(frames);
            }
        }
        return output;
    }
}

