/*
 * Decompiled with CFR 0.152.
 */
package mchorse.blockbuster.utils.mclib;

import mchorse.mclib.utils.resources.IResourceTransformer;
import org.apache.commons.lang3.StringUtils;

public class BlockbusterResourceTransformer
implements IResourceTransformer {
    public static final String DOMAIN = "b.a";
    public static final String OLD_DOMAIN = "blockbuster.actors";

    public String transformDomain(String domain, String path) {
        if (domain.equals(OLD_DOMAIN)) {
            domain = DOMAIN;
        }
        return domain;
    }

    public String transformPath(String domain, String path) {
        if (domain.equals(DOMAIN) || domain.equals(OLD_DOMAIN)) {
            path = this.fixPath(path);
        }
        return path;
    }

    public String transform(String location) {
        if (location.startsWith("blockbuster.actors:")) {
            location = DOMAIN + location.substring(OLD_DOMAIN.length());
        }
        if (location.startsWith("b.a:") && StringUtils.countMatches((CharSequence)location, (CharSequence)"/") == 1) {
            int index = location.indexOf(":");
            String domain = location.substring(0, index + 1);
            String path = this.fixPath(location.substring(index + 1));
            location = domain + path;
        }
        return location;
    }

    private String fixPath(String path) {
        if (path.indexOf(".") != -1) {
            return path;
        }
        String[] splits = path.split("/");
        if (splits.length != 2) {
            return path;
        }
        return splits[0] + "/skins/" + splits[1] + ".png";
    }
}

