/*
 * Decompiled with CFR 0.152.
 */
package mchorse.blockbuster.utils.mclib;

import at.dhyan.open_imaging.GifDecoder;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import mchorse.blockbuster.utils.mclib.GifFrameFile;

public class GifFolder
extends File {
    public static Map<String, Long> lastModified = new HashMap<String, Long>();
    public static Map<String, GifDecoder.GifImage> cache = new HashMap<String, GifDecoder.GifImage>();
    private static final long serialVersionUID = 3058345951609134509L;
    public GifDecoder.GifImage gif;

    public GifFolder(String pathname) {
        super(pathname);
        String path = this.getPath();
        Long last = lastModified.get(path);
        if (last != null && last <= this.lastModified()) {
            this.gif = cache.get(path);
        } else {
            try {
                FileInputStream in = new FileInputStream(pathname);
                this.gif = GifDecoder.read(in);
                ((InputStream)in).close();
                cache.put(path, this.gif);
                lastModified.put(path, this.lastModified());
            }
            catch (IOException e) {
                this.gif = null;
                cache.remove(path);
                lastModified.remove(path);
            }
        }
    }

    @Override
    public String getName() {
        return super.getName() + ">";
    }

    @Override
    public String getPath() {
        return super.getPath() + ">";
    }

    public String getFilePath() {
        return super.getPath();
    }

    @Override
    public boolean isDirectory() {
        return true;
    }

    @Override
    public boolean isFile() {
        return false;
    }

    @Override
    public File[] listFiles() {
        ArrayList<GifFrameFile> list = new ArrayList<GifFrameFile>();
        for (int i = 0; i < this.gif.getFrameCount(); ++i) {
            list.add(new GifFrameFile(this.getPath() + "/frame" + i + ".png"));
        }
        return list.toArray(new File[0]);
    }

    @Override
    public boolean exists() {
        return this.gif != null;
    }
}

