/*
 * Decompiled with CFR 0.152.
 */
package mchorse.blockbuster_pack;

import java.util.List;
import mchorse.blockbuster.api.ModelHandler;
import mchorse.blockbuster_pack.BlockbusterSection;
import mchorse.blockbuster_pack.client.gui.GuiBetterLightsMorph;
import mchorse.blockbuster_pack.client.gui.GuiCustomMorph;
import mchorse.blockbuster_pack.client.gui.GuiImageMorph;
import mchorse.blockbuster_pack.client.gui.GuiLightMorph;
import mchorse.blockbuster_pack.client.gui.GuiParticleMorph;
import mchorse.blockbuster_pack.client.gui.GuiRecordMorph;
import mchorse.blockbuster_pack.client.gui.GuiSequencerMorph;
import mchorse.blockbuster_pack.client.gui.GuiSnowstormMorph;
import mchorse.blockbuster_pack.client.gui.GuiStructureMorph;
import mchorse.blockbuster_pack.client.gui.GuiTrackerMorph;
import mchorse.blockbuster_pack.morphs.BetterLightsMorph;
import mchorse.blockbuster_pack.morphs.CustomMorph;
import mchorse.blockbuster_pack.morphs.ImageMorph;
import mchorse.blockbuster_pack.morphs.LightMorph;
import mchorse.blockbuster_pack.morphs.ParticleMorph;
import mchorse.blockbuster_pack.morphs.RecordMorph;
import mchorse.blockbuster_pack.morphs.SequencerMorph;
import mchorse.blockbuster_pack.morphs.SnowstormMorph;
import mchorse.blockbuster_pack.morphs.StructureMorph;
import mchorse.blockbuster_pack.morphs.TrackerMorph;
import mchorse.metamorph.api.IMorphFactory;
import mchorse.metamorph.api.MorphManager;
import mchorse.metamorph.api.creative.sections.MorphSection;
import mchorse.metamorph.api.morphs.AbstractMorph;
import mchorse.metamorph.client.gui.editor.GuiAbstractMorph;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.NBTTagCompound;

public class BlockbusterFactory
implements IMorphFactory {
    public ModelHandler models;
    public BlockbusterSection section;

    public void register(MorphManager manager) {
        this.section = new BlockbusterSection("blockbuster");
        manager.list.register((MorphSection)this.section);
    }

    public void registerMorphEditors(Minecraft mc, List<GuiAbstractMorph> editors) {
        editors.add(new GuiCustomMorph(mc));
        editors.add(new GuiImageMorph(mc));
        editors.add(new GuiSequencerMorph(mc));
        editors.add(new GuiRecordMorph(mc));
        editors.add(new GuiStructureMorph(mc));
        editors.add(new GuiParticleMorph(mc));
        editors.add(new GuiSnowstormMorph(mc));
        editors.add(new GuiTrackerMorph(mc));
        editors.add(new GuiLightMorph(mc));
        editors.add(new GuiBetterLightsMorph(mc));
    }

    public AbstractMorph getMorphFromNBT(NBTTagCompound tag) {
        AbstractMorph morph;
        String name = tag.func_74779_i("Name");
        if ((name = name.substring(name.indexOf(".") + 1)).equals("image")) {
            morph = new ImageMorph();
        } else if (name.equals("sequencer")) {
            morph = new SequencerMorph();
        } else if (name.equals("record")) {
            morph = new RecordMorph();
        } else if (name.equals("structure")) {
            morph = new StructureMorph();
        } else if (name.equals("particle")) {
            morph = new ParticleMorph();
        } else if (name.equals("snowstorm")) {
            morph = new SnowstormMorph();
        } else if (name.equals("tracker")) {
            morph = new TrackerMorph();
        } else if (name.equals("light")) {
            morph = new LightMorph();
        } else if (name.equals("betterLights")) {
            morph = new BetterLightsMorph();
        } else {
            CustomMorph custom = new CustomMorph();
            custom.model = this.models.models.get(name);
            morph = custom;
        }
        morph.fromNBT(tag);
        return morph;
    }

    public boolean hasMorph(String morph) {
        return morph.startsWith("blockbuster.") || morph.equals("sequencer") || morph.equals("structure") || morph.equals("particle") || morph.equals("snowstorm") || morph.equals("tracker") || morph.equals("light") || morph.equals("betterLights");
    }
}

