/*
 * Decompiled with CFR 0.152.
 */
package mchorse.blockbuster_pack.client.gui;

import mchorse.blockbuster_pack.morphs.LightMorph;
import mchorse.mclib.client.gui.framework.elements.GuiElement;
import mchorse.mclib.client.gui.framework.elements.IGuiElement;
import mchorse.mclib.client.gui.framework.elements.input.GuiTrackpadElement;
import mchorse.mclib.client.gui.framework.elements.utils.GuiLabel;
import mchorse.mclib.client.gui.utils.Elements;
import mchorse.mclib.client.gui.utils.Icons;
import mchorse.mclib.client.gui.utils.keys.IKey;
import mchorse.mclib.client.gui.utils.resizers.IResizer;
import mchorse.metamorph.api.morphs.AbstractMorph;
import mchorse.metamorph.client.gui.editor.GuiAbstractMorph;
import mchorse.metamorph.client.gui.editor.GuiAnimation;
import mchorse.metamorph.client.gui.editor.GuiMorphPanel;
import net.minecraft.client.Minecraft;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiLightMorph
extends GuiAbstractMorph<LightMorph> {
    public GuiLightMorph(Minecraft mc) {
        super(mc);
        this.defaultPanel = new GuiLightMorphPanel(mc, this);
        this.registerPanel(this.defaultPanel, IKey.lang((String)"blockbuster.gui.light_morph.name"), Icons.GEAR);
    }

    public boolean canEdit(AbstractMorph morph) {
        return morph instanceof LightMorph;
    }

    public static class GuiLightMorphPanel
    extends GuiMorphPanel<LightMorph, GuiLightMorph> {
        private GuiTrackpadElement lightValue;
        private GuiAnimation animation;

        public GuiLightMorphPanel(Minecraft mc, GuiLightMorph editor) {
            super(mc, (GuiAbstractMorph)editor);
            this.animation = new GuiAnimation(mc, true);
            this.animation.flex().relative((GuiElement)this).x(1.0f, -130).w(130);
            this.animation.ignored.removeFromParent();
            this.lightValue = new GuiTrackpadElement(mc, value -> ((LightMorph)this.morph).setLightValue(value.intValue()));
            this.lightValue.integer().limit(0.0, 15.0).tooltip(IKey.lang((String)"blockbuster.gui.light_morph.light_value_tooltip"));
            GuiLabel lightLabel = Elements.label((IKey)IKey.lang((String)"blockbuster.gui.light_morph.light_value"));
            GuiElement lightElements = Elements.column((Minecraft)mc, (int)3, (int)10, (GuiElement[])new GuiElement[]{lightLabel, this.lightValue});
            lightElements.flex().relative((IResizer)this.area).x(0.0f, 0).w(130);
            this.add(new IGuiElement[]{this.animation, lightElements});
        }

        public void fillData(LightMorph morph) {
            super.fillData((AbstractMorph)morph);
            this.lightValue.setValue((double)morph.getLightValue());
            this.animation.fill(morph.getAnimation());
        }
    }
}

